/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ds;

import com.elixirtech.arch.ICachedFile;
import com.elixirtech.arch.ISecurity;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.ds.DSHelper;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.runtime.function.JProcedure1;

public abstract class DSBuilder {
    private String name = "";
    private String description = "";
    private boolean encryptedFlag = false;
    private boolean readOnlyFlag = false;
    private boolean hideInternalsFlag = false;
    private String password = "";
    private Option iCachedFile = None$.MODULE$;

    public String name() {
        return this.name;
    }

    public void name_$eq(String x$1) {
        this.name = x$1;
    }

    public String description() {
        return this.description;
    }

    public void description_$eq(String x$1) {
        this.description = x$1;
    }

    public boolean encryptedFlag() {
        return this.encryptedFlag;
    }

    public void encryptedFlag_$eq(boolean x$1) {
        this.encryptedFlag = x$1;
    }

    public boolean readOnlyFlag() {
        return this.readOnlyFlag;
    }

    public void readOnlyFlag_$eq(boolean x$1) {
        this.readOnlyFlag = x$1;
    }

    public boolean hideInternalsFlag() {
        return this.hideInternalsFlag;
    }

    public void hideInternalsFlag_$eq(boolean x$1) {
        this.hideInternalsFlag = x$1;
    }

    public String password() {
        return this.password;
    }

    public void password_$eq(String x$1) {
        this.password = x$1;
    }

    public Option<ICachedFile> iCachedFile() {
        return this.iCachedFile;
    }

    public void iCachedFile_$eq(Option<ICachedFile> x$1) {
        this.iCachedFile = x$1;
    }

    public abstract String getType();

    public String getName() {
        return this.name();
    }

    public void setName(String name) {
        this.name_$eq(name);
    }

    public String getDescription() {
        return this.description();
    }

    public void setDescription(String desc) {
        this.description_$eq(desc);
    }

    public boolean isEncrypted() {
        return this.encryptedFlag();
    }

    public void setEncrypted(boolean b) {
        this.encryptedFlag_$eq(b);
    }

    public boolean isReadOnly() {
        return this.readOnlyFlag();
    }

    public void setReadOnly(boolean b) {
        this.readOnlyFlag_$eq(b);
    }

    public boolean isHideInternals() {
        return this.hideInternalsFlag();
    }

    public void setHideInternals(boolean b) {
        this.hideInternalsFlag_$eq(b);
    }

    public String getPassword() {
        return this.password();
    }

    public void setPassword(String pass) {
        this.password_$eq(pass);
    }

    public void setSecurity(ISecurity sec) {
        this.setEncrypted(sec.isEncrypted());
        this.setReadOnly(sec.isReadOnly());
        this.setHideInternals(sec.isHideInternals());
        this.setPassword(sec.getPassword());
    }

    public ISecurity getSecurity() {
        return new ReadOnlySecurity(this.name(), this.isEncrypted(), this.isReadOnly(), this.isHideInternals(), this.password());
    }

    public void setICachedFile(Option<ICachedFile> icf) {
        this.iCachedFile_$eq(icf);
    }

    public Option<ICachedFile> getICachedFile() {
        return this.iCachedFile();
    }

    public void applyICachedFile(IDataSource ds) {
        this.iCachedFile().foreach((Function1)(JProcedure1 & Serializable)icf -> DSHelper.applyICachedFile(ds, icf));
    }

    public abstract IDataSource build();

    public static class ReadOnlySecurity
    implements ISecurity {
        private final String name;
        private final boolean isEncryptedFlag;
        private final boolean isReadOnlyFlag;
        private final boolean isHideInternalsFlag;
        private final String password;

        public ReadOnlySecurity(String name, boolean isEncryptedFlag, boolean isReadOnlyFlag, boolean isHideInternalsFlag, String password) {
            this.name = name;
            this.isEncryptedFlag = isEncryptedFlag;
            this.isReadOnlyFlag = isReadOnlyFlag;
            this.isHideInternalsFlag = isHideInternalsFlag;
            this.password = password;
        }

        @Override
        public void setName(String name) {
            throw new RuntimeException("ReadOnlySecurity");
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isEncrypted() {
            return this.isEncryptedFlag;
        }

        @Override
        public void setEncrypted(boolean b) {
            throw new RuntimeException("ReadOnlySecurity");
        }

        @Override
        public boolean isReadOnly() {
            return this.isReadOnlyFlag;
        }

        @Override
        public void setReadOnly(boolean b) {
            throw new RuntimeException("ReadOnlySecurity");
        }

        @Override
        public boolean isHideInternals() {
            return this.isHideInternalsFlag;
        }

        @Override
        public void setHideInternals(boolean b) {
            throw new RuntimeException("ReadOnlySecurity");
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        @Override
        public void setPassword(String pass) {
            throw new RuntimeException("ReadOnlySecurity");
        }
    }
}

