/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.editor;

import com.elixirtech.arch.IDirtyState;
import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.logging.SLF4J;
import com.elixirtech.editor.RETypes;
import com.elixirtech.editor.Tokenizer;
import java.awt.Color;
import java.io.Serializable;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.ListBuffer;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class EditorDocument
extends DefaultStyledDocument
implements SLF4J,
LoggingHelper,
IDirtyState {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(EditorDocument.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private final RETypes types;
    private boolean m_IsDirty;
    private final ListBuffer m_DirtyListeners;
    private boolean highlighting;

    public EditorDocument(RETypes types) {
        this.types = types;
        this.m_IsDirty = false;
        this.m_DirtyListeners = new ListBuffer();
        this.highlighting = false;
        types.setStyles(this);
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggingHelper.logger$((LoggingHelper)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean m_IsDirty() {
        return this.m_IsDirty;
    }

    public void m_IsDirty_$eq(boolean x$1) {
        this.m_IsDirty = x$1;
    }

    public ListBuffer<IDirtyState.Listener> m_DirtyListeners() {
        return this.m_DirtyListeners;
    }

    public boolean highlighting() {
        return this.highlighting;
    }

    public void highlighting_$eq(boolean x$1) {
        this.highlighting = x$1;
    }

    @Override
    public void fireUndoableEditUpdate(UndoableEditEvent e) {
        if (!this.highlighting()) {
            super.fireUndoableEditUpdate(e);
            return;
        }
    }

    @Override
    public void setDirty(boolean b) {
        if (this.m_IsDirty() != b) {
            this.m_IsDirty_$eq(b);
            this.m_DirtyListeners().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.dirtyStateChanged(this));
            return;
        }
    }

    @Override
    public boolean isDirty() {
        return this.m_IsDirty();
    }

    @Override
    public void addDirtyListener(IDirtyState.Listener l) {
        this.m_DirtyListeners().$plus$eq((Object)l);
    }

    @Override
    public void removeDirtyListener(IDirtyState.Listener l) {
        this.m_DirtyListeners().$minus$eq((Object)l);
    }

    @Override
    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        super.replace(offset, length, text, attrs);
        this.setDirty(true);
        this.highlightSyntax();
    }

    @Override
    public void insertString(int offset, String text, AttributeSet style) throws BadLocationException {
        super.insertString(offset, text, style);
        this.setDirty(true);
        this.highlightSyntax();
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.setDirty(true);
        this.highlightSyntax();
    }

    public void highlightSyntax() {
        try {
            try {
                this.highlighting_$eq(true);
                if (this.getLength() > 0) {
                    String text = this.getText(0, this.getLength());
                    this.setCharacterAttributes(0, this.getLength(), this.getStyle("default"), true);
                    Tokenizer tokenizer = new Tokenizer(this.types, text);
                    tokenizer.tokens().foreach((Function1)(JProcedure1 & Serializable)token -> {
                        String word = token.value();
                        Option<Color> option = token.tokenType().color();
                        if (option instanceof Some) {
                            Color color = (Color)((Some)option).value();
                            this.setCharacterAttributes(token.pos(), token.value().length(), this.getStyle(token.tokenType().name()), false);
                            return;
                        }
                        if (None$.MODULE$.equals(option)) {
                            if (this.types.isKeyword(word)) {
                                this.setCharacterAttributes(token.pos(), token.value().length(), this.getStyle("keyword"), false);
                                return;
                            }
                            return;
                        }
                        throw new MatchError(option);
                    });
                }
            }
            catch (Exception ex) {
                this.warn(() -> EditorDocument.highlightSyntax$$anonfun$2(ex), Line$.MODULE$.apply(77), FullName$.MODULE$.apply("com.elixirtech.editor.EditorDocument.highlightSyntax"));
            }
        }
        finally {
            this.highlighting_$eq(false);
        }
    }

    private static final Object highlightSyntax$$anonfun$2(Exception ex$1) {
        return "Error in highlighting: " + ex$1;
    }
}

