/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.editor;

import com.elixirtech.arch.ArchAction;
import com.elixirtech.arch.IDirtyState;
import com.elixirtech.editor.EditorDocument;
import com.elixirtech.editor.JEditor$;
import com.elixirtech.editor.JEditor$DL$;
import com.elixirtech.editor.JEditor$UEL$;
import com.elixirtech.editor.LinePainter;
import com.elixirtech.editor.action.DeleteLine;
import com.elixirtech.editor.action.GoToLine;
import com.elixirtech.editor.action.InsertTabSpaces;
import com.elixirtech.editor.action.MoveSelectionDown;
import com.elixirtech.editor.action.MoveSelectionUp;
import com.elixirtech.editor.action.RemoveTab;
import com.elixirtech.editor.action.ReplicateDown;
import com.elixirtech.editor.action.ReplicateUp;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.UndoManager;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class JEditor
extends JEditorPane
implements IDirtyState {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(JEditor.class.getDeclaredField("UEL$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JEditor.class.getDeclaredField("DL$lzy1"));
    private final UndoManager undoManager = new UndoManager();
    private volatile Object DL$lzy1;
    private volatile Object UEL$lzy1;
    private final EditorAction undoAction;
    private final EditorAction redoAction;
    private final EditorAction cutAction;
    private final EditorAction copyAction;
    private final EditorAction pasteAction;

    public static Font MONOSPACED_FONT() {
        return JEditor$.MODULE$.MONOSPACED_FONT();
    }

    public JEditor(String text, StyledEditorKit kit) {
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setEditorKit(kit);
        this.setText(text);
        this.addDirtyListener(this.DL());
        this.addUndoRedoListener();
        this.addUpDownMover();
        this.addCommonEditing();
        new LinePainter(this);
        this.undoAction = new EditorAction(this, "Editor.Undo", (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$init$$$anonfun$1();
            return BoxedUnit.UNIT;
        });
        this.redoAction = new EditorAction(this, "Editor.Redo", (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$init$$$anonfun$2();
            return BoxedUnit.UNIT;
        });
        this.cutAction = new EditorAction(this, "Editor.Cut", (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$init$$$anonfun$3();
            return BoxedUnit.UNIT;
        });
        this.copyAction = new EditorAction(this, "Editor.Copy", (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$init$$$anonfun$4();
            return BoxedUnit.UNIT;
        });
        this.pasteAction = new EditorAction(this, "Editor.Paste", (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$init$$$anonfun$5();
            return BoxedUnit.UNIT;
        });
    }

    public JEditor(StyledEditorKit kit, Font font) {
        this("", kit);
        this.setEditorFont(font);
    }

    public UndoManager undoManager() {
        return this.undoManager;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container container = this.getParent();
        if (container instanceof JViewport) {
            JViewport port = (JViewport)container;
            ComponentUI tui = this.getUI();
            int w = port.getWidth();
            Dimension pref = tui.getPreferredSize(this);
            return w > pref.width;
        }
        return false;
    }

    public EditorDocument editorDocument() {
        return (EditorDocument)this.getDocument();
    }

    @Override
    public void setDirty(boolean b) {
        this.editorDocument().setDirty(b);
        if (!b) {
            this.undoManager().discardAllEdits();
            this.checkUndoRedoEnabled();
            return;
        }
    }

    @Override
    public boolean isDirty() {
        return this.editorDocument().isDirty();
    }

    @Override
    public void addDirtyListener(IDirtyState.Listener l) {
        this.editorDocument().addDirtyListener(l);
    }

    @Override
    public void removeDirtyListener(IDirtyState.Listener l) {
        this.editorDocument().removeDirtyListener(l);
    }

    public void setEditorFont(Font font) {
        EditorDocument doc = this.editorDocument();
        Style defaultStyle = doc.getStyle("default");
        StyleConstants.setFontFamily(defaultStyle, font.getFamily());
        StyleConstants.setFontSize(defaultStyle, font.getSize());
        StyleConstants.setBold(defaultStyle, font.isBold());
        StyleConstants.setItalic(defaultStyle, font.isItalic());
        doc.highlightSyntax();
        this.repaint();
    }

    public void setFontSize(int sz) {
        EditorDocument doc = this.editorDocument();
        Style defaultStyle = doc.getStyle("default");
        StyleConstants.setFontSize(defaultStyle, sz);
        doc.highlightSyntax();
        this.repaint();
    }

    public EditorAction getUndoAction() {
        return this.undoAction();
    }

    public EditorAction getRedoAction() {
        return this.redoAction();
    }

    public EditorAction getCutAction() {
        return this.cutAction();
    }

    public EditorAction getCopyAction() {
        return this.copyAction();
    }

    public EditorAction getPasteAction() {
        return this.pasteAction();
    }

    public void insert(String s, int pos) {
        Document doc = this.getDocument();
        int p = package$.MODULE$.min(package$.MODULE$.max(pos, 0), doc.getLength());
        doc.insertString(p, s, null);
    }

    public int getCaretRow() {
        int pos = this.getCaretPosition();
        Element map = this.getDocument().getDefaultRootElement();
        return map.getElementIndex(pos);
    }

    public int getCaretColumn() {
        int line;
        int pos = this.getCaretPosition();
        Element map = this.getDocument().getDefaultRootElement();
        Option option = Option$.MODULE$.apply((Object)map.getElement(line = map.getElementIndex(pos)));
        if (option instanceof Some) {
            Element le = (Element)((Some)option).value();
            return pos - le.getStartOffset();
        }
        if (None$.MODULE$.equals(option)) {
            return -1;
        }
        throw new MatchError((Object)option);
    }

    public void addUndoRedoListener() {
        this.getDocument().addUndoableEditListener(this.UEL());
        ActionMap amap = this.getActionMap();
        amap.put("undo", this.undoAction());
        amap.put("redo", this.redoAction());
        InputMap inputMap = this.getInputMap();
        KeyStroke ctrlZ = KeyStroke.getKeyStroke(90, 2);
        inputMap.put(ctrlZ, "undo");
        KeyStroke ctrlY = KeyStroke.getKeyStroke(89, 2);
        inputMap.put(ctrlY, "redo");
    }

    public void addUpDownMover() {
        ActionMap amap = this.getActionMap();
        amap.put("move-selection-up", new MoveSelectionUp());
        amap.put("move-selection-down", new MoveSelectionDown());
        InputMap inputMap = this.getInputMap();
        KeyStroke up = KeyStroke.getKeyStroke(38, 8);
        inputMap.put(up, "move-selection-up");
        KeyStroke down = KeyStroke.getKeyStroke(40, 8);
        inputMap.put(down, "move-selection-down");
    }

    public void addCommonEditing() {
        ActionMap amap = this.getActionMap();
        amap.put("insert-tab-spaces", new InsertTabSpaces());
        amap.put("remove-tab", new RemoveTab());
        amap.put("delete-line", new DeleteLine());
        amap.put("replicate-up", new ReplicateUp());
        amap.put("replicate-down", new ReplicateDown());
        amap.put("go-to-line", new GoToLine());
        InputMap inputMap = this.getInputMap();
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        inputMap.put(tab, "insert-tab-spaces");
        KeyStroke untab = KeyStroke.getKeyStroke(9, 1);
        inputMap.put(untab, "remove-tab");
        KeyStroke delLine = KeyStroke.getKeyStroke(68, 2);
        inputMap.put(delLine, "delete-line");
        KeyStroke repUp = KeyStroke.getKeyStroke(38, 10);
        inputMap.put(repUp, "replicate-up");
        KeyStroke repDown = KeyStroke.getKeyStroke(40, 10);
        inputMap.put(repDown, "replicate-down");
        KeyStroke keyStroke = KeyStroke.getKeyStroke(76, 2);
        inputMap.put(keyStroke, "go-to-line");
    }

    public void undo() {
        if (this.undoManager().canUndo()) {
            this.undoManager().undo();
            this.editorDocument().highlightSyntax();
            this.checkUndoRedoEnabled();
            return;
        }
    }

    public void redo() {
        if (this.undoManager().canRedo()) {
            this.undoManager().redo();
            this.editorDocument().highlightSyntax();
            this.checkUndoRedoEnabled();
            return;
        }
    }

    public void checkUndoRedoEnabled() {
        this.undoAction().setEnabled(this.undoManager().canUndo());
        this.redoAction().setEnabled(this.undoManager().canRedo());
    }

    public final JEditor$DL$ DL() {
        Object object = this.DL$lzy1;
        if (object instanceof JEditor$DL$) {
            return (JEditor$DL$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JEditor$DL$)this.DL$lzyINIT1();
    }

    private Object DL$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.DL$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JEditor$DL$ jEditor$DL$ = null;
                    try {
                        jEditor$DL$ = new JEditor$DL$(this);
                        object2 = jEditor$DL$ == null ? LazyVals.NullValue$.MODULE$ : jEditor$DL$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.DL$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return jEditor$DL$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final JEditor$UEL$ UEL() {
        Object object = this.UEL$lzy1;
        if (object instanceof JEditor$UEL$) {
            return (JEditor$UEL$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JEditor$UEL$)this.UEL$lzyINIT1();
    }

    private Object UEL$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.UEL$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JEditor$UEL$ jEditor$UEL$ = null;
                    try {
                        jEditor$UEL$ = new JEditor$UEL$(this);
                        object2 = jEditor$UEL$ == null ? LazyVals.NullValue$.MODULE$ : jEditor$UEL$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.UEL$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return jEditor$UEL$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public EditorAction undoAction() {
        return this.undoAction;
    }

    public EditorAction redoAction() {
        return this.redoAction;
    }

    public EditorAction cutAction() {
        return this.cutAction;
    }

    public EditorAction copyAction() {
        return this.copyAction;
    }

    public EditorAction pasteAction() {
        return this.pasteAction;
    }

    private final void $init$$$anonfun$1() {
        this.undo();
    }

    private final void $init$$$anonfun$2() {
        this.redo();
    }

    private final void $init$$$anonfun$3() {
        this.cut();
    }

    private final void $init$$$anonfun$4() {
        this.copy();
    }

    private final void $init$$$anonfun$5() {
        this.paste();
    }

    public class EditorAction
    extends ArchAction {
        private final Function0<BoxedUnit> fn;
        private final /* synthetic */ JEditor $outer;

        public EditorAction(JEditor $outer, String s, Function0<BoxedUnit> fn) {
            this.fn = fn;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(s);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fn.apply$mcV$sp();
        }

        public final /* synthetic */ JEditor com$elixirtech$editor$JEditor$EditorAction$$$outer() {
            return this.$outer;
        }
    }
}

