/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.editor;

import com.elixirtech.arch.EditorPreferences;
import com.elixirtech.editor.JEditor;
import com.elixirtech.editor.action.FindNextAction;
import com.elixirtech.editor.action.FindPreviousAction;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.ui.EventWatcher;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JEditorToolBar
extends JToolBar
implements CaretListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    JEditor m_Editor;
    private JSpinner m_FontSize;
    private JTextField m_FindField;
    private FindNextAction m_FindNextAction;
    private FindPreviousAction m_FindPreviousAction;

    public JEditorToolBar(JEditor jEditor) {
        this.m_Editor = jEditor;
        this.m_Editor.addCaretListener(this);
        this.setRollover(true);
        this.setFloatable(false);
        this.add(this.m_Editor.getUndoAction());
        this.add(this.m_Editor.getRedoAction());
        this.addSeparator();
        this.add(this.m_Editor.getCutAction());
        this.add(this.m_Editor.getCopyAction());
        this.add(this.m_Editor.getPasteAction());
        this.addSeparator();
        JLabel jLabel = new JLabel(Bundle.ARCH.getString("JSToolBar.FONT_SIZE"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.add(jLabel);
        this.m_FontSize = new JSpinner(EditorPreferences.getFontSize());
        Dimension dimension = this.m_FontSize.getPreferredSize();
        dimension.width = 80;
        this.m_FontSize.setPreferredSize(dimension);
        this.m_FontSize.setMaximumSize(dimension);
        this.m_FontSize.addChangeListener(this);
        this.m_Editor.setFontSize(((Number)this.m_FontSize.getValue()).intValue());
        this.add(this.m_FontSize);
        this.addSeparator();
        JLabel jLabel2 = new JLabel(Bundle.ARCH.getString("JSToolBar.FIND"));
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.add(jLabel2);
        this.m_FindField = new JTextField(20);
        this.add(this.m_FindField);
        this.m_FindField.getDocument().addDocumentListener(new EventWatcher(){

            @Override
            public void update() {
                JEditorToolBar.this.checkFindEnabled();
            }
        });
        this.m_FindNextAction = new FindNextAction(jEditor, this.m_FindField);
        this.m_FindPreviousAction = new FindPreviousAction(jEditor, this.m_FindField);
        this.add(new JButton(this.m_FindNextAction));
        this.add(new JButton(this.m_FindPreviousAction));
        this.m_FindField.addActionListener(this.m_FindNextAction);
        this.registerActions();
        this.checkEnabled();
    }

    public void checkEnabled() {
        String string = this.m_Editor.getSelectedText();
        boolean bl = string != null && string.length() > 0;
        this.m_Editor.getCutAction().setEnabled(bl && this.m_Editor.isEditable());
        this.m_Editor.getCopyAction().setEnabled(bl);
        this.m_Editor.getPasteAction().setEnabled(this.m_Editor.isEditable());
    }

    public void checkFindEnabled() {
        String string = this.m_FindField.getText();
        boolean bl = string.length() > 0;
        this.m_FindNextAction.setEnabled(bl);
        this.m_FindPreviousAction.setEnabled(bl);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.repaint();
        this.checkEnabled();
    }

    protected void registerActions() {
        ActionMap actionMap = this.m_Editor.getActionMap();
        actionMap.put("find", new StartFind());
        actionMap.put("find-next", this.m_FindNextAction);
        actionMap.put("find-previous", this.m_FindPreviousAction);
        InputMap inputMap = this.m_Editor.getInputMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(70, 2);
        inputMap.put(keyStroke, "find");
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(75, 2);
        inputMap.put(keyStroke2, "find-next");
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(75, 3);
        inputMap.put(keyStroke3, "find-previous");
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(UIManager.getFont("Tree.font"));
        graphics2D.setColor(Color.BLACK);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        String string = I18NUtil.getString(Bundle.ARCH, "JSToolBar.LINECOLUMN", this.line(), this.column());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = this.getSize().width - n - 10;
        if (n2 > 640) {
            graphics2D.drawString(string, n2, fontMetrics.getAscent() + 5);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.m_Editor.setFontSize(((Number)this.m_FontSize.getValue()).intValue());
    }

    public void dispose() {
        this.m_FontSize.removeChangeListener(this);
    }

    protected int line() {
        return this.m_Editor.getCaretRow() + 1;
    }

    protected int column() {
        return this.m_Editor.getCaretColumn() + 1;
    }

    private class StartFind
    extends AbstractAction {
        private StartFind() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEditorToolBar.this.m_FindField.selectAll();
            JEditorToolBar.this.m_FindField.requestFocus();
        }
    }
}

