/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.editor;

import com.elixirtech.editor.LinePainter$;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.util.control.Exception$;

public class LinePainter
implements Highlighter.HighlightPainter,
CaretListener,
MouseListener,
MouseMotionListener {
    public final JTextComponent com$elixirtech$editor$LinePainter$$component;
    private final Color color;
    private Rectangle lastView;

    public static Option<Color> $lessinit$greater$default$2() {
        return LinePainter$.MODULE$.$lessinit$greater$default$2();
    }

    public LinePainter(JTextComponent component, Option<Color> optColor) {
        this.com$elixirtech$editor$LinePainter$$component = component;
        this.color = (Color)optColor.getOrElse(() -> this.$init$$$anonfun$1(component));
        this.lastView = null;
        component.addCaretListener(this);
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        Exception$.MODULE$.allCatch().apply(() -> this.$init$$$anonfun$2(component));
    }

    public LinePainter(JTextComponent c) {
        this(c, (Option<Color>)None$.MODULE$);
    }

    public Color color() {
        return this.color;
    }

    public Rectangle lastView() {
        return this.lastView;
    }

    public void lastView_$eq(Rectangle x$1) {
        this.lastView = x$1;
    }

    public Color lighter(Color color) {
        int red = package$.MODULE$.min(255, (int)((double)color.getRed() * 1.8));
        int green = package$.MODULE$.min(255, (int)((double)color.getGreen() * 1.8));
        int blue = package$.MODULE$.min(255, (int)((double)color.getBlue() * 1.8));
        return new Color(red, green, blue, 64);
    }

    @Override
    public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
        Exception$.MODULE$.allCatch().apply((Function0 & Serializable)() -> {
            this.paint$$anonfun$1(c, g);
            return BoxedUnit.UNIT;
        });
    }

    private void resetHighlight() {
        if (this.lastView() != null) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ LinePainter $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void run() {
                    Exception$.MODULE$.allCatch().apply((Function0 & Serializable)() -> {
                        this.run$$anonfun$1();
                        return BoxedUnit.UNIT;
                    });
                }

                private final void run$$anonfun$1() {
                    int offset = this.$outer.com$elixirtech$editor$LinePainter$$component.getCaretPosition();
                    Rectangle currentView = this.$outer.com$elixirtech$editor$LinePainter$$component.modelToView2D(offset).getBounds();
                    if (this.$outer.lastView().y != currentView.y) {
                        this.$outer.com$elixirtech$editor$LinePainter$$component.repaint(0, this.$outer.lastView().y, this.$outer.com$elixirtech$editor$LinePainter$$component.getWidth(), this.$outer.lastView().height);
                        this.$outer.lastView_$eq(currentView);
                        return;
                    }
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{run$$anonfun$adapted$1()}, serializedLambda);
                }
            });
            return;
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.resetHighlight();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.resetHighlight();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.resetHighlight();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private final Color $init$$$anonfun$1(JTextComponent component$1) {
        return this.lighter(component$1.getSelectionColor());
    }

    private final Object $init$$$anonfun$2(JTextComponent component$2) {
        return component$2.getHighlighter().addHighlight(0, 0, this);
    }

    private final void paint$$anonfun$1(JTextComponent c$1, Graphics g$1) {
        Rectangle r = c$1.modelToView2D(c$1.getCaretPosition()).getBounds();
        g$1.setColor(this.color());
        g$1.fillRect(0, r.y, c$1.getWidth(), r.height);
        if (this.lastView() == null) {
            this.lastView_$eq(r);
            return;
        }
    }
}

