/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.editor;

import java.io.Serializable;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxesRunTime;

public interface TextComponentHelper {
    public static int getLineOfOffset$(TextComponentHelper $this, JTextComponent c, int offset) {
        return $this.getLineOfOffset(c, offset);
    }

    default public int getLineOfOffset(JTextComponent c, int offset) {
        Document doc = c.getDocument();
        if (offset < 0) {
            throw new BadLocationException("Can't translate offset to line", -1);
        }
        if (offset > doc.getLength()) {
            throw new BadLocationException("Can't translate offset to line", doc.getLength() + 1);
        }
        Element map = doc.getDefaultRootElement();
        return map.getElementIndex(offset);
    }

    public static int getLineStartOffset$(TextComponentHelper $this, JTextComponent c, int line) {
        return $this.getLineStartOffset(c, line);
    }

    default public int getLineStartOffset(JTextComponent c, int line) {
        Document doc = c.getDocument();
        Element map = doc.getDefaultRootElement();
        if (line < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (line >= map.getElementCount()) {
            throw new BadLocationException("No such line", doc.getLength() + 1);
        }
        Element lineElem = map.getElement(line);
        return lineElem.getStartOffset();
    }

    public static int getLineEndOffset$(TextComponentHelper $this, JTextComponent c, int line) {
        return $this.getLineEndOffset(c, line);
    }

    default public int getLineEndOffset(JTextComponent c, int line) {
        Document doc = c.getDocument();
        Element map = doc.getDefaultRootElement();
        if (line < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (line >= map.getElementCount()) {
            throw new BadLocationException("No such line", doc.getLength() + 1);
        }
        Element lineElem = map.getElement(line);
        return lineElem.getEndOffset();
    }

    public static int getColumnOfOffset$(TextComponentHelper $this, JTextComponent c, int offset) {
        return $this.getColumnOfOffset(c, offset);
    }

    default public int getColumnOfOffset(JTextComponent c, int offset) {
        int line = this.getLineOfOffset(c, offset);
        int start = this.getLineStartOffset(c, line);
        return offset - start;
    }

    public static int getLineCount$(TextComponentHelper $this, JTextComponent c) {
        return $this.getLineCount(c);
    }

    default public int getLineCount(JTextComponent c) {
        return c.getDocument().getDefaultRootElement().getElementCount();
    }

    public static int getTabSize$(TextComponentHelper $this, JTextComponent target) {
        return $this.getTabSize(target);
    }

    default public int getTabSize(JTextComponent target) {
        Option opt = Option$.MODULE$.apply(target.getDocument().getProperty("tabSize"));
        return BoxesRunTime.unboxToInt((Object)opt.map((Function1 & Serializable)_$1 -> BoxesRunTime.unboxToInt((Object)_$1)).getOrElse(TextComponentHelper::getTabSize$$anonfun$2));
    }

    private static int getTabSize$$anonfun$2() {
        return 2;
    }
}

