/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.editor.action;

import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.logging.SLF4J;
import com.elixirtech.editor.TextComponentHelper;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.math.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class RemoveTab
extends TextAction
implements TextComponentHelper,
SLF4J,
LoggingHelper {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RemoveTab.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;

    public RemoveTab() {
        super("remove-tab");
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggingHelper.logger$((LoggingHelper)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent target = this.getTextComponent(e);
        if (target != null && target.isEditable()) {
            int tabSize = this.getTabSize(target);
            Caret c = target.getCaret();
            int dot = c.getDot();
            int mark = c.getMark();
            try {
                int dotLine = this.getLineOfOffset(target, dot);
                int markLine = this.getLineOfOffset(target, mark);
                if (dotLine != markLine) {
                    int start = package$.MODULE$.min(dotLine, markLine);
                    int stop = package$.MODULE$.max(dotLine, markLine);
                    Document doc = target.getDocument();
                    RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(start), stop).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                        int dec;
                        int off = this.getLineStartOffset(target, i);
                        String s = doc.getText(off, tabSize);
                        if (s.charAt(0) == '\t') {
                            doc.remove(off, 1);
                            return;
                        }
                        int len = s.length();
                        for (dec = 0; dec < len && s.charAt(dec) == ' '; ++dec) {
                        }
                        doc.remove(off, dec);
                    });
                }
            }
            catch (BadLocationException ex) {
                this.warn(() -> RemoveTab.actionPerformed$$anonfun$2(ex), Line$.MODULE$.apply(41), FullName$.MODULE$.apply("com.elixirtech.editor.action.RemoveTab.actionPerformed"));
            }
            return;
        }
    }

    private static final Object actionPerformed$$anonfun$2(BadLocationException ex$1) {
        return "BadLocation: " + ex$1;
    }
}

