/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.canvas;

import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.GOExtras;
import com.elixirtech.canvas.extras.DiagramExtras;
import com.elixirtech.canvas.geometry.RectangleEx;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.List;

public class CanvasPrintable
implements Printable {
    private Diagram m_Diagram;

    public CanvasPrintable(Diagram diagram) {
        this.m_Diagram = diagram;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n != 0) {
            return 1;
        }
        double d = pageFormat.getImageableWidth();
        double d2 = pageFormat.getImageableHeight();
        RectangleEx rectangleEx = new RectangleEx(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        List list = this.m_Diagram.getChildGOs();
        if (!list.isEmpty()) {
            Object object;
            for (GO gO : list) {
                object = GOExtras.getPaintRect(gO);
                rectangleEx.left = Math.min(rectangleEx.left, ((RectangleEx)object).left);
                rectangleEx.top = Math.min(rectangleEx.top, ((RectangleEx)object).top);
                rectangleEx.right = Math.max(rectangleEx.right, ((RectangleEx)object).right);
                rectangleEx.bottom = Math.max(rectangleEx.bottom, ((RectangleEx)object).bottom);
            }
            int n2 = rectangleEx.right - rectangleEx.left;
            int n3 = rectangleEx.bottom - rectangleEx.top;
            object = (Graphics2D)graphics;
            double d3 = Math.min(1.0, d / (double)n2);
            double d4 = Math.min(1.0, d2 / (double)n3);
            double d5 = Math.min(d3, d4);
            ((Graphics2D)object).translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            ((Graphics2D)object).scale(d5, d5);
            ((Graphics2D)object).translate(-rectangleEx.left, -rectangleEx.top);
            DiagramExtras.getWrapper(this.m_Diagram).drawShapes((Graphics2D)object);
        }
        return 0;
    }
}

