/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.canvas.action;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.ensemble.EnsembleAction;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.CanvasPrintable;
import com.elixirtech.ensemble.canvas.ICanvasPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.SwingUtilities;

public class CanvasPrintAction
extends EnsembleAction {
    private ICanvasPanel m_CanvasPanel;

    public CanvasPrintAction(ICanvasPanel iCanvasPanel) {
        super("CanvasPanel.Print");
        this.m_CanvasPanel = iCanvasPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(sERVICE_FORMATTED, null);
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        Component component = this.m_CanvasPanel.getComponent();
        Dimension dimension = component.getSize();
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, component);
        point.x += dimension.width / 2 - 200;
        point.y += dimension.height / 2 - 200;
        PrintService printService2 = ServiceUI.printDialog(null, point.x, point.y, printServiceArray, printService, sERVICE_FORMATTED, hashPrintRequestAttributeSet);
        if (printService2 != null) {
            DocPrintJob docPrintJob = printService2.createPrintJob();
            SimpleDoc simpleDoc = new SimpleDoc(new CanvasPrintable(this.m_CanvasPanel.getDiagram()), DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
            try {
                docPrintJob.print(simpleDoc, hashPrintRequestAttributeSet);
            }
            catch (PrintException printException) {
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18N.ENSEMBLE.getString("CanvasPrintAction.PRINT_ERROR"), (Throwable)printException);
            }
        }
    }
}

