/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.canvas.action;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IApplication;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.worker.AbortableSwingWorker;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DSLookup;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.ParameterUtil;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.data2.datasource.composite.CompositeScope;
import com.elixirtech.data2.olap.Cube;
import com.elixirtech.data2.olap.CubeDataSource;
import com.elixirtech.data2.olap.CubeHelper;
import com.elixirtech.data2.olap.Measure;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.CubeGO;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.cube.CubeViewer;
import com.elixirtech.ensemble.cube.DefaultCubePresentation;
import com.elixirtech.ensemble.ds.DSPanel;
import com.elixirtech.ensemble.ds.IDataAccess2;
import com.elixirtech.ensemble.ds.MutableDataSource;
import com.elixirtech.ensemble.ui.ThrobbingPushContext;
import com.elixirtech.ensemble.wizard.ParameterUI;
import com.elixirtech.js.JavaScriptEngine;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import org.mozilla.javascript.Scriptable;

public class ViewCubeListener
extends AbortableSwingWorker
implements ActionListener {
    private final CubeGO m_GO;
    private Map<String, String> m_Values;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ViewCubeListener.class);

    public ViewCubeListener(CubeGO cubeGO) {
        super("View Cube");
        this.m_GO = cubeGO;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.m_Values = new HashMap<String, String>();
        if (ViewCubeListener.getParams((InOutGO)this.m_GO, this.m_Values)) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object construct() {
        CubeViewer cubeViewer;
        IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
        DSPanel dSPanel = (DSPanel)iViewModel.getCurrentView();
        CompositeDataSource compositeDataSource = (CompositeDataSource)MutableDataSource.unwrap(dSPanel.getDataSource());
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        javaScriptEngine.pushScope((Scriptable)new CompositeScope(compositeDataSource));
        ThrobbingPushContext throbbingPushContext = ThrobbingPushContext.getPushContext(this.m_Values);
        compositeDataSource.initScript((PushContext)throbbingPushContext);
        final CubeDataSource cubeDataSource = (CubeDataSource)dSPanel.getDataSource((InOutGO)this.m_GO);
        InOutGO inOutGO = this.m_GO.getInput();
        IDataAccess2 iDataAccess2 = (IDataAccess2)Elixir.get(IDataAccess2.class);
        IDataSource iDataSource = iDataAccess2.loadData(compositeDataSource, inOutGO, this.m_Values);
        DataTable dataTable = DataTable.build((PushContext)throbbingPushContext, (IDataSource)iDataSource);
        final Cube cube = new Cube(dataTable);
        CubeHelper.MeasureInfoSet measureInfoSet = new CubeHelper.MeasureInfoSet(){

            public int getCount() {
                return cubeDataSource.getMeasures().length;
            }

            public String[] getFunctionInfo(int n) {
                Measure measure = cubeDataSource.getMeasures()[n];
                return new String[]{measure.getName(), measure.getFunction().getName(), measure.getColumnNamePattern()};
            }

            public Cube getCube() {
                return cube;
            }
        };
        Measure[] measureArray = CubeHelper.buildMeasures((CubeHelper.MeasureInfoSet)measureInfoSet);
        CubeDataSource cubeDataSource2 = new CubeDataSource("clone", cube, cubeDataSource.getRows(), cubeDataSource.getColumns(), measureArray);
        cubeDataSource2.setCollapseColumns(cubeDataSource.isCollapseColumns());
        cubeDataSource2.setCollapseRows(cubeDataSource.isCollapseRows());
        cubeDataSource2.setColumnTitle(cubeDataSource.getColumnTitle());
        cubeDataSource2.setKeepColumnTotals(cubeDataSource.isKeepColumnTotals());
        cubeDataSource2.setKeepRowTotals(cubeDataSource.isKeepRowTotals());
        cubeDataSource2.setRowTitle(cubeDataSource.getRowTitle());
        cubeDataSource2.setKeepRecords(true);
        try {
            compositeDataSource.initScript((PushContext)throbbingPushContext);
            this.register(throbbingPushContext);
            m_Log.debug((Object)"Creating cube viewer");
            DefaultCubePresentation defaultCubePresentation = new DefaultCubePresentation();
            defaultCubePresentation.setColumnTotalsAfter(this.m_GO.isShowColumnTotalsAfterDetails());
            defaultCubePresentation.setRowTotalsAfter(this.m_GO.isShowRowTotalsAfterDetails());
            CubeViewer cubeViewer2 = new CubeViewer((PushContext)throbbingPushContext, compositeDataSource, cubeDataSource2, defaultCubePresentation);
            throbbingPushContext.reset();
            cubeViewer = cubeViewer2;
        }
        catch (Throwable throwable) {
            try {
                javaScriptEngine.popScope();
                throw throwable;
            }
            catch (Exception exception) {
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18N.ENSEMBLE.getString("CubeGO.CANT_VIEW_CUBE"), (Throwable)exception);
                return null;
            }
        }
        javaScriptEngine.popScope();
        return cubeViewer;
    }

    @Override
    public void finished() {
        super.finished();
        CubeViewer cubeViewer = (CubeViewer)this.getValue();
        if (cubeViewer != null) {
            IApplication iApplication = (IApplication)Elixir.get(IApplication.class);
            JFrame jFrame = new JFrame(this.m_GO.getText());
            jFrame.setIconImage(iApplication.getFrameIcon());
            jFrame.setDefaultCloseOperation(2);
            jFrame.getContentPane().add(cubeViewer);
            cubeViewer.setFrame(jFrame);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            Dimension dimension = elixirFrame.getFrame().getSize();
            jFrame.setSize(dimension.width - 80, dimension.height - 80);
            jFrame.setLocationRelativeTo(elixirFrame.getFrame());
            m_Log.debug((Object)"Showing cube");
            jFrame.setVisible(true);
        }
    }

    protected static boolean getParams(InOutGO inOutGO, Map<String, String> map) {
        ArgumentMap argumentMap = new ArgumentMap();
        inOutGO.buildParameters(argumentMap);
        List list = argumentMap.getParameters();
        return ViewCubeListener.getParams(list, map, inOutGO);
    }

    protected static boolean getParams(List<Parameter> list, Map<String, String> map, InOutGO inOutGO) {
        if (ParameterUtil.getParamCount(list) > 0) {
            ParameterUI parameterUI = new ParameterUI(list, new DSL(inOutGO));
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(parameterUI);
            if (!parameterUI.isFinished()) {
                return false;
            }
            parameterUI.populateProperties(map);
        }
        return true;
    }

    private static class DSL
    implements DSLookup {
        InOutGO m_go;

        public DSL(InOutGO inOutGO) {
            this.m_go = inOutGO;
        }

        public IDataSource getDataSource(String string) throws DataException {
            IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
            DSPanel dSPanel = (DSPanel)iViewModel.getCurrentView();
            CompositeDataSource compositeDataSource = (CompositeDataSource)MutableDataSource.unwrap(dSPanel.getDataSource());
            compositeDataSource.rebuildFromDiagram(this.m_go);
            return compositeDataSource.getDataSource(string);
        }
    }
}

