/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.cube;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.olap.Cube;
import com.elixirtech.data2.olap.CubeDataSource;
import com.elixirtech.ensemble.cube.ColumnHeader2;
import com.elixirtech.ensemble.cube.DataRenderer;
import com.elixirtech.ensemble.cube.DataSheet;
import com.elixirtech.ensemble.cube.ICubePresentation;
import com.elixirtech.ensemble.cube.RowHeader2;
import com.elixirtech.ensemble.cube.SelectionMemento;
import com.elixirtech.ensemble.ui.ThrobbingPushContext;
import com.elixirtech.ui.NimbusScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BasicCubeCanvas
extends JPanel {
    protected ICubePresentation m_CubePresentation;
    protected CubeDataSource m_DataSource;
    protected Dimension m_Size;
    protected ColumnHeader2 m_ColumnHeader;
    protected RowHeader2 m_RowHeader;
    protected DataSheet m_Data;
    protected JScrollPane m_Pane;
    protected boolean m_TopExpanded;
    protected boolean m_ShowRowParents;
    protected boolean m_ShowColumnParents;
    protected List<ListSelectionListener> m_Listeners = new ArrayList<ListSelectionListener>();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(BasicCubeCanvas.class);

    public BasicCubeCanvas(PushContext pushContext, CubeDataSource cubeDataSource, ICubePresentation iCubePresentation) throws DataException {
        this.m_DataSource = cubeDataSource;
        this.m_CubePresentation = iCubePresentation;
        this.m_ShowRowParents = iCubePresentation.isShowRowParents();
        this.m_ShowColumnParents = iCubePresentation.isShowColumnParents();
        this.m_Data = new DataSheet(this, pushContext, cubeDataSource, this.m_CubePresentation);
        this.setLayout(new BorderLayout());
        this.m_ColumnHeader = this.m_Data.getColumnHeader();
        this.m_ColumnHeader.setShowParents(this.m_ShowColumnParents);
        this.m_ColumnHeader.setTotalsAfter(iCubePresentation.isColumnTotalsAfter());
        this.m_RowHeader = this.m_Data.getRowHeader();
        this.m_RowHeader.setShowParents(this.m_ShowRowParents);
        this.m_RowHeader.setTotalsAfter(iCubePresentation.isRowTotalsAfter());
        this.m_Pane = new NimbusScrollPane(this.m_Data);
        this.add((Component)this.m_Pane, "Center");
        this.setupPaneDecorations();
    }

    public void setDataSource(CubeDataSource cubeDataSource) {
        this.m_DataSource = cubeDataSource;
        this.refresh();
    }

    public void refresh() {
        try {
            if (this.m_Pane != null) {
                this.remove(this.m_Pane);
            }
            SelectionMemento selectionMemento = new SelectionMemento(this.m_Data);
            this.m_Data = new DataSheet(this, (PushContext)new ThrobbingPushContext(), this.m_DataSource, this.m_CubePresentation);
            this.adjustDataSheet();
            this.m_ColumnHeader = this.m_Data.getColumnHeader();
            this.m_ColumnHeader.setShowParents(this.m_ShowColumnParents);
            this.m_ColumnHeader.setTotalsAfter(this.m_CubePresentation.isColumnTotalsAfter());
            this.m_RowHeader = this.m_Data.getRowHeader();
            this.m_RowHeader.setShowParents(this.m_ShowRowParents);
            this.m_RowHeader.setTotalsAfter(this.m_CubePresentation.isRowTotalsAfter());
            this.m_Pane = new NimbusScrollPane(this.m_Data);
            this.add((Component)this.m_Pane, "Center");
            this.setupPaneDecorations();
            selectionMemento.apply(this.m_Data);
        }
        catch (DataException dataException) {
            m_Log.error((Object)("Data exception on refresh: " + String.valueOf((Object)dataException)), (Throwable)dataException);
        }
        this.validate();
    }

    public CubeDataSource getDataSource() {
        return this.m_DataSource;
    }

    public Cube getCube() {
        return this.m_DataSource.getCube();
    }

    public ColumnHeader2 getColumnHeader() {
        return this.m_ColumnHeader;
    }

    public RowHeader2 getRowHeader() {
        return this.m_RowHeader;
    }

    protected void adjustDataSheet() {
    }

    public DataSheet getDataSheet() {
        return this.m_Data;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.m_Listeners.add(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.m_Listeners.remove(listSelectionListener);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        for (ListSelectionListener listSelectionListener : this.m_Listeners) {
            listSelectionListener.valueChanged(listSelectionEvent);
        }
    }

    public void fireEvent(String string) {
    }

    public SelectionMemento getSelectionMemento() {
        return this.m_Data.getSelectionMemento();
    }

    public void setSelectionMemento(SelectionMemento selectionMemento) {
        this.m_Data.setSelectionMemento(selectionMemento);
    }

    @Override
    protected void validateTree() {
        super.validateTree();
        this.m_Data.createColumnModel();
    }

    public IDataSource getAllRecords() {
        return this.m_Data.getAllRecords();
    }

    public boolean hasSelection() {
        return this.m_Data.hasSelection();
    }

    public IDataSource getSelectedRecords() {
        return this.m_Data.getSelectedRecords();
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.m_Data != null) {
            this.m_Data.setOpaque(bl);
        }
        if (this.m_ColumnHeader != null) {
            this.m_ColumnHeader.setOpaque(bl);
        }
        if (this.m_RowHeader != null) {
            this.m_RowHeader.setOpaque(bl);
        }
    }

    public void setDataRenderer(DataRenderer dataRenderer) {
        this.m_Data.setDataRenderer(dataRenderer);
    }

    public boolean isTopExpanded() {
        return this.m_TopExpanded;
    }

    public boolean isRowShowParents() {
        return this.m_ShowRowParents;
    }

    public boolean isColumnShowParents() {
        return this.m_ShowColumnParents;
    }

    public void setRowShowParents(boolean bl) {
        this.m_ShowRowParents = bl;
        this.m_RowHeader.setShowParents(this.m_ShowRowParents);
        this.m_RowHeader.layoutUi();
        this.validate();
    }

    public void setColumnShowParents(boolean bl) {
        this.m_ShowColumnParents = bl;
        this.m_ColumnHeader.setShowParents(this.m_ShowColumnParents);
        this.m_ColumnHeader.layoutUi();
        this.validate();
    }

    protected void setupPaneDecorations() {
    }
}

