/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.cube;

import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.cube.ColumnHeader2;
import com.elixirtech.ensemble.cube.DataSheet;
import com.elixirtech.ensemble.cube.RowHeader2;
import com.elixirtech.i18n.I18NUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;

public class CubePrinter
implements Printable {
    private static final int FOOTER_HEIGHT = 15;
    private static final Font FOOTER_FONT = new Font("SansSerif", 0, 12);
    DataSheet m_Sheet;
    ColumnHeader2 m_ColHeader;
    RowHeader2 m_RowHeader;
    int m_ColCount;
    int m_RowCount;
    boolean m_Initialized;
    List<Page> m_Pages;

    public CubePrinter(DataSheet dataSheet) {
        this.m_Sheet = dataSheet;
        this.m_ColHeader = this.m_Sheet.getColumnHeader();
        this.m_RowHeader = this.m_Sheet.getRowHeader();
        this.m_ColCount = this.m_ColHeader.getColumnCount();
        this.m_RowCount = this.m_RowHeader.getRowCount();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (!this.m_Initialized) {
            this.init(pageFormat);
        }
        if (n < 0 || n >= this.m_Pages.size()) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Page page = this.m_Pages.get(n);
        this.printColHeader(pageFormat, graphics2D, page);
        this.printRowHeader(pageFormat, graphics2D, page);
        this.printSheet(pageFormat, graphics2D, page);
        this.printFooter(pageFormat, n, graphics2D);
        return 0;
    }

    private void printColHeader(PageFormat pageFormat, Graphics2D graphics2D, Page page) {
        if (page.hasColHeader()) {
            double d = pageFormat.getImageableX();
            double d2 = pageFormat.getImageableY();
            int n = this.getColOffset(page.getStartCol());
            int n2 = this.getColOffset(page.getEndCol());
            if (page.hasRowHeader()) {
                d += (double)this.m_RowHeader.getWidth();
            }
            graphics2D.translate(d, d2);
            graphics2D.translate(-n, 0);
            Shape shape = graphics2D.getClip();
            graphics2D.setClip(new Rectangle(n, 0, n2 - n - 1, this.m_ColHeader.getHeight() - 1));
            this.m_ColHeader.paint(graphics2D);
            graphics2D.setClip(shape);
            graphics2D.translate(n, 0);
            graphics2D.translate(-d, -d2);
        }
    }

    private void printRowHeader(PageFormat pageFormat, Graphics2D graphics2D, Page page) {
        if (page.hasRowHeader()) {
            double d = pageFormat.getImageableX();
            double d2 = pageFormat.getImageableY();
            int n = this.getRowOffset(page.getStartRow());
            int n2 = this.getRowOffset(page.getEndRow());
            if (page.hasColHeader()) {
                d2 += (double)this.m_ColHeader.getHeight();
            }
            graphics2D.translate(d, d2);
            graphics2D.translate(0, -n);
            Shape shape = graphics2D.getClip();
            graphics2D.setClip(new Rectangle(0, n, this.m_RowHeader.getWidth() - 1, n2 - n - 1));
            this.m_RowHeader.paint(graphics2D);
            graphics2D.setClip(shape);
            graphics2D.translate(0, n);
            graphics2D.translate(-d, -d2);
        }
    }

    private void printSheet(PageFormat pageFormat, Graphics2D graphics2D, Page page) {
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        int n = this.getColOffset(page.getStartCol());
        int n2 = this.getColOffset(page.getEndCol());
        int n3 = this.getRowOffset(page.getStartRow());
        int n4 = this.getRowOffset(page.getEndRow());
        if (page.hasRowHeader()) {
            d += (double)this.m_RowHeader.getWidth();
        }
        if (page.hasColHeader()) {
            d2 += (double)this.m_ColHeader.getHeight();
        }
        graphics2D.translate(d, d2);
        graphics2D.translate(-n, -n3);
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(new Rectangle(n, n3, n2 - n, n4 - n3));
        this.m_Sheet.paint(graphics2D);
        graphics2D.setClip(shape);
        graphics2D.translate(n, n3);
        graphics2D.translate(-d, -d2);
    }

    private void printFooter(PageFormat pageFormat, int n, Graphics2D graphics2D) {
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        String string = I18NUtil.getString(I18N.ENSEMBLE, "Printer.PageNumber", n + 1);
        graphics2D.setFont(FOOTER_FONT);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = (int)(d + (d3 - (double)fontMetrics.stringWidth(string)) / 2.0);
        int n3 = (int)(d2 + d4 - (double)fontMetrics.getDescent());
        graphics2D.drawString(string, n2, n3);
    }

    protected void init(PageFormat pageFormat) {
        this.m_Initialized = true;
        this.m_Pages = new ArrayList<Page>();
        int n = 0;
        int n2 = 0;
        while (true) {
            Page page = new Page(n, n2);
            page.calcEnds(pageFormat);
            this.m_Pages.add(page);
            n = page.getEndCol();
            if (n != this.m_ColCount) continue;
            n = 0;
            n2 = page.getEndRow();
            if (n2 == this.m_RowCount) break;
        }
    }

    protected int getColOffset(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.m_ColHeader.getColumnWidth(i);
        }
        return n2;
    }

    protected int getRowOffset(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.m_RowHeader.getRowHeight(i);
        }
        return n2;
    }

    private class Page {
        private boolean m_HasColHeader;
        private boolean m_HasRowHeader;
        private int m_StartCol;
        private int m_EndCol;
        private int m_StartRow;
        private int m_EndRow;

        public Page(int n, int n2) {
            this.m_HasColHeader = n2 == 0;
            this.m_HasRowHeader = n == 0;
            this.m_StartCol = n;
            this.m_StartRow = n2;
        }

        public int getEndCol() {
            return this.m_EndCol;
        }

        public int getEndRow() {
            return this.m_EndRow;
        }

        public int getStartCol() {
            return this.m_StartCol;
        }

        public int getStartRow() {
            return this.m_StartRow;
        }

        public boolean hasColHeader() {
            return this.m_HasColHeader;
        }

        public boolean hasRowHeader() {
            return this.m_HasRowHeader;
        }

        public void calcEnds(PageFormat pageFormat) {
            double d = pageFormat.getImageableWidth();
            if (this.m_HasRowHeader) {
                d -= (double)CubePrinter.this.m_RowHeader.getWidth();
            }
            this.m_EndCol = this.m_StartCol;
            d -= (double)CubePrinter.this.m_ColHeader.getColumnWidth(this.m_EndCol++);
            while (this.m_EndCol < CubePrinter.this.m_ColCount && !((d -= (double)CubePrinter.this.m_ColHeader.getColumnWidth(this.m_EndCol)) < 0.0)) {
                ++this.m_EndCol;
            }
            d = pageFormat.getImageableHeight();
            d -= 15.0;
            if (this.m_HasColHeader) {
                d -= (double)CubePrinter.this.m_ColHeader.getHeight();
            }
            this.m_EndRow = this.m_StartRow;
            d -= (double)CubePrinter.this.m_RowHeader.getRowHeight(this.m_EndRow++);
            while (this.m_EndRow < CubePrinter.this.m_RowCount && !((d -= (double)CubePrinter.this.m_RowHeader.getRowHeight(this.m_EndRow)) < 0.0)) {
                ++this.m_EndRow;
            }
        }
    }
}

