/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.cube;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.data2.datasource.composite.CompositeGOSource;
import com.elixirtech.data2.olap.CubeDataSource;
import com.elixirtech.ensemble.EnsembleAction;
import com.elixirtech.ensemble.cube.BasicCubeCanvas;
import com.elixirtech.ensemble.cube.CubePrinter;
import com.elixirtech.ensemble.cube.DataSheet;
import com.elixirtech.ensemble.cube.ICubePresentation;
import com.elixirtech.ensemble.ds.DataTable;
import com.elixirtech.ui.SwingFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class CubeViewer
extends JPanel {
    BasicCubeCanvas m_CubeCanvas;
    JToolBar m_CubeToolBar;
    CompositeDataSource m_Composite;
    CubeDataSource m_DataSource;
    JFrame m_Frame;

    public CubeViewer(PushContext pushContext, CompositeDataSource compositeDataSource, CubeDataSource cubeDataSource, ICubePresentation iCubePresentation) throws DataException {
        this.setLayout(new BorderLayout());
        this.m_Composite = compositeDataSource;
        this.m_DataSource = cubeDataSource;
        this.m_CubeToolBar = SwingFactory.newToolBar();
        this.m_CubeToolBar.add(new SaveAsAction());
        this.m_CubeToolBar.add(new PrintAction());
        this.m_CubeCanvas = new BasicCubeCanvas(pushContext, cubeDataSource, iCubePresentation);
        this.add((Component)this.m_CubeToolBar, "North");
        this.add((Component)this.m_CubeCanvas, "Center");
    }

    public void setFrame(JFrame jFrame) {
        this.m_Frame = jFrame;
    }

    private class SaveAsAction
    extends EnsembleAction {
        public SaveAsAction() {
            super("DataSource.Data.SaveAs");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataTable.saveAs((IDataSource)new CompositeGOSource(CubeViewer.this.m_Composite, (IDataSource)CubeViewer.this.m_DataSource), CubeViewer.this.m_Frame);
        }
    }

    private class PrintAction
    extends EnsembleAction {
        public PrintAction() {
            super("DataSource.Data.Print");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataSheet dataSheet = CubeViewer.this.m_CubeCanvas.getDataSheet();
            CubePrinter cubePrinter = new CubePrinter(dataSheet);
            DataTable.print(cubePrinter);
        }
    }
}

