/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.cube;

import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.olap.CubeDataSource;
import com.elixirtech.data2.olap.IDataSet;
import com.elixirtech.data2.olap.Index;
import com.elixirtech.data2.olap.Level;
import com.elixirtech.data2.olap.Measure;
import com.elixirtech.data2.olap.TreeNode;
import com.elixirtech.ensemble.cube.BasicCubeCanvas;
import com.elixirtech.ensemble.cube.ColumnHeader2;
import com.elixirtech.ensemble.cube.CubeSelection;
import com.elixirtech.ensemble.cube.DataRenderer;
import com.elixirtech.ensemble.cube.DataValues;
import com.elixirtech.ensemble.cube.DataValuesBuilder;
import com.elixirtech.ensemble.cube.ICubePresentation;
import com.elixirtech.ensemble.cube.RowHeader2;
import com.elixirtech.ensemble.cube.SelectionMemento;
import com.elixirtech.ui.TopLeftLayoutManager;
import com.elixirtech.ui.table.ElxTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DataSheet
extends ElxTable
implements ChangeListener,
DataValues.Listener {
    protected BasicCubeCanvas m_CubeCanvas;
    protected CubeDataSource m_DataSource;
    protected ICubePresentation m_CubePresentation;
    protected ColumnHeader2 m_ColumnHeader;
    protected RowHeader2 m_RowHeader;
    protected Dimension m_Size;
    protected DataValues m_DataValues;
    protected DataSheetModel m_TableModel;
    protected IDynamicRenderer m_DynamicRenderer;
    protected boolean m_DisableEvents;
    private CL m_CL = new CL();
    private DataSchema[] m_CellSchema;

    public DataSheet(BasicCubeCanvas basicCubeCanvas, PushContext pushContext, CubeDataSource cubeDataSource, ICubePresentation iCubePresentation) throws DataException {
        this.m_CubeCanvas = basicCubeCanvas;
        this.m_DataSource = cubeDataSource;
        assert (this.m_DataSource.isKeepRecords());
        ToolTipManager.sharedInstance().unregisterComponent(this);
        this.m_CubePresentation = iCubePresentation;
        this.rowHeight = this.m_CubePresentation.getLineHeight();
        this.setAutoCreateColumnsFromModel(false);
        this.setAutoResizeMode(0);
        this.m_ColumnHeader = new ColumnHeader2(this, iCubePresentation.getColumnStyle());
        this.m_ColumnHeader.setShowParents(this.m_CubeCanvas.isColumnShowParents());
        this.m_ColumnHeader.setTotalsAfter(this.m_CubePresentation.isColumnTotalsAfter());
        this.m_ColumnHeader.refresh(cubeDataSource.getColumnGrouping(pushContext), cubeDataSource.getMeasures());
        this.m_ColumnHeader.addChangeListener(this);
        this.m_ColumnHeader.addComponentListener(this.m_CL);
        this.m_RowHeader = new RowHeader2(this, iCubePresentation.getRowStyle());
        this.m_RowHeader.setShowParents(this.m_CubeCanvas.isRowShowParents());
        this.m_RowHeader.setTotalsAfter(this.m_CubePresentation.isRowTotalsAfter());
        this.m_RowHeader.refresh(cubeDataSource.getRowGrouping(pushContext));
        this.m_RowHeader.addChangeListener(this);
        this.m_RowHeader.addComponentListener(this.m_CL);
        this.buildSize();
        this.m_DataValues = new DataValues();
        this.m_DataValues.addListener(this);
        this.m_TableModel = new DataSheetModel();
        this.setModel(this.m_TableModel);
        this.buildAll();
        this.setCellSelectionEnabled(true);
        this.addMouseListener(new ML());
    }

    @Override
    public void setUI(TableUI tableUI) {
        super.setUI(new BasicTableUI());
    }

    public void updatePresentation() {
        this.m_ColumnHeader.updatePresentation();
        this.m_RowHeader.updatePresentation();
        this.rowHeight = this.m_CubePresentation.getLineHeight();
        this.sizeChanged();
    }

    public ICubePresentation getCubePresentation() {
        return this.m_CubePresentation;
    }

    public void refresh() {
        this.m_ColumnHeader.refresh(this.m_DataSource.getColumnGrouping(null), this.m_DataSource.getMeasures());
        this.m_RowHeader.refresh(this.m_DataSource.getRowGrouping(null));
        this.buildSize();
        this.m_DataValues = new DataValues();
        this.m_DataValues.addListener(this);
        this.m_TableModel = new DataSheetModel();
        this.setModel(this.m_TableModel);
        this.buildAll();
        this.invalidate();
    }

    public void setDisableEvents(boolean bl) {
        this.m_DisableEvents = bl;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.m_CubeCanvas != null) {
            if (!listSelectionEvent.getValueIsAdjusting() && !this.m_DisableEvents) {
                this.m_CubeCanvas.valueChanged(listSelectionEvent);
            }
            this.repaint();
        }
    }

    public void fireEvent(String string) {
        if (this.m_CubeCanvas != null) {
            this.m_CubeCanvas.fireEvent(string);
        }
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            JPanel jPanel = new JPanel(new TopLeftLayoutManager());
            jPanel.setOpaque(false);
            jPanel.add(this.m_ColumnHeader);
            jScrollPane.setColumnHeaderView(jPanel);
            jScrollPane.getColumnHeader().setOpaque(false);
            JPanel jPanel2 = new JPanel(new TopLeftLayoutManager());
            jPanel2.add(this.m_RowHeader);
            jPanel2.setOpaque(false);
            jScrollPane.setRowHeaderView(jPanel2);
            jScrollPane.getRowHeader().setOpaque(false);
            Border border = jScrollPane.getBorder();
            if (border == null || border instanceof UIResource) {
                jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
        }
    }

    public IDataSource getAllRecords() {
        return this.m_DataSource;
    }

    public boolean hasSelection() {
        int[] nArray = this.getSelectedColumns();
        int[] nArray2 = this.getSelectedRows();
        return nArray2.length != 0 && nArray.length != 0;
    }

    public SelectionMemento getSelectionMemento() {
        return new SelectionMemento(this);
    }

    public void setSelectionMemento(SelectionMemento selectionMemento) {
        selectionMemento.apply(this);
    }

    public IDataSource getSelectedRecords() {
        boolean bl;
        Index index = new Index();
        int[] nArray = this.getSelectedColumns();
        int[] nArray2 = this.getSelectedRows();
        boolean bl2 = nArray.length == this.getColumnCount();
        boolean bl3 = bl = nArray2.length == this.getRowCount();
        if (bl2 && bl) {
            return this.m_DataSource.getCube().getDataSource();
        }
        if (bl2) {
            for (int i = 0; i < nArray2.length; ++i) {
                TreeNode treeNode = this.getRow(nArray2[i]);
                Index index2 = this.buildIndex(treeNode);
                index = index.union(index2);
            }
            return new CubeSelection(this, index);
        }
        if (bl) {
            for (int i = 0; i < nArray.length; ++i) {
                TreeNode treeNode = this.getColumn(nArray[i]);
                Index index3 = this.buildIndex(treeNode);
                index = index.union(index3);
            }
            return new CubeSelection(this, index);
        }
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                TreeNode treeNode = this.getColumn(nArray[i]);
                TreeNode treeNode2 = this.getRow(nArray2[j]);
                Index index4 = this.buildIndex(treeNode);
                Index index5 = this.buildIndex(treeNode2);
                index = index.union(index4.intersection(index5));
            }
        }
        return new CubeSelection(this, index);
    }

    private Index buildIndex(TreeNode treeNode) {
        Index index = treeNode.getIndex();
        for (TreeNode treeNode2 = treeNode.getParent(); treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            index = index.intersection(treeNode2.getIndex());
        }
        return index;
    }

    public DataSchema getSchema() {
        return this.m_DataSource.getSchema();
    }

    public DataSchema getInputSchema() {
        return this.m_DataSource.getCube().getSchema();
    }

    public DataRecord[] getRecords() {
        return this.m_DataSource.getRecords();
    }

    public ColumnHeader2 getColumnHeader() {
        return this.m_ColumnHeader;
    }

    public RowHeader2 getRowHeader() {
        return this.m_RowHeader;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.m_Size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.m_Size;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.m_Size;
    }

    public void buildAll() {
        int n;
        int n2;
        DataValuesBuilder dataValuesBuilder = new DataValuesBuilder(this.m_DataValues, this.m_DataSource.getRecords());
        TreeNode[] treeNodeArray = this.m_RowHeader.getRows();
        TreeNode[] treeNodeArray2 = this.m_ColumnHeader.getColumns();
        Measure[] measureArray = this.m_ColumnHeader.getMeasures();
        dataValuesBuilder.addTask(new DataValuesBuilder.BlockTask(treeNodeArray, treeNodeArray2, measureArray));
        String[] stringArray = this.m_RowHeader.getLevels();
        String[] stringArray2 = this.m_ColumnHeader.getLevels();
        this.m_CellSchema = new DataSchema[measureArray.length];
        DataSchema dataSchema = this.m_CubeCanvas.getDataSource().getCube().getSchema();
        SchemaBuilder schemaBuilder = new SchemaBuilder(true);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            n = dataSchema.getColumnIndex(stringArray[n2]);
            schemaBuilder.add(stringArray[n2], dataSchema.getColumnType(n), new DataAttributes());
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            n = dataSchema.getColumnIndex(stringArray2[n2]);
            schemaBuilder.add(stringArray2[n2], dataSchema.getColumnType(n), new DataAttributes());
        }
        for (n2 = 0; n2 < measureArray.length; ++n2) {
            if (!schemaBuilder.contains("Value")) {
                DataType dataType = dataSchema.getColumnType(measureArray[n2].getIndex());
                dataType = measureArray[n2].getResultType(dataType);
                schemaBuilder.add("Value", dataType, new DataAttributes());
            }
            this.m_CellSchema[n2] = schemaBuilder.getSchema();
        }
        dataValuesBuilder.addTask(new DataValuesBuilder.TerminateTask(dataValuesBuilder));
    }

    @Override
    public void valueChanged(TreeNode treeNode, TreeNode treeNode2, Measure measure) {
        int n = this.getX(treeNode2, measure);
        int n2 = this.getY(treeNode);
        this.m_TableModel.fireTableCellUpdated(n2, n);
    }

    public void setDataRenderer(DataRenderer dataRenderer) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.sizeChanged();
    }

    public void sizeChanged() {
        this.buildSize();
        Container container = this.getParent().getParent().getParent();
        container.validate();
        this.resizeAndRepaint();
    }

    public void createColumnModel() {
        TableColumn tableColumn;
        int n;
        if (this.m_ColumnHeader == null) {
            return;
        }
        int n2 = this.m_ColumnHeader.getColumnCount();
        TableColumnModel tableColumnModel = null;
        TableColumnModel tableColumnModel2 = this.getColumnModel();
        if (tableColumnModel2 != null && n2 == tableColumnModel2.getColumnCount()) {
            tableColumnModel = tableColumnModel2;
        }
        if (tableColumnModel == null) {
            tableColumnModel = new DefaultTableColumnModel();
            for (n = 0; n < n2; ++n) {
                tableColumn = new TableColumn();
                tableColumn.setModelIndex(n);
                tableColumnModel.addColumn(tableColumn);
            }
            this.setColumnModel(tableColumnModel);
        }
        for (n = 0; n < n2; ++n) {
            tableColumn = tableColumnModel.getColumn(n);
            int n3 = this.m_ColumnHeader.getColumnWidth(n);
            n3 = Math.max(20, n3);
            int n4 = this.m_TableModel.getColumnWidth(n) + 5;
            if (n4 > n3) {
                this.m_ColumnHeader.setColumnWidth(n, n4);
                n3 = n4;
            }
            tableColumn.setWidth(n3);
            tableColumn.setMinWidth(n3);
            tableColumn.setMaxWidth(n3);
            tableColumn.setPreferredWidth(n3);
        }
        this.setCellSelectionEnabled(true);
        ListSelectionModel listSelectionModel = tableColumnModel.getSelectionModel();
        listSelectionModel.removeListSelectionListener(this);
        listSelectionModel.addListSelectionListener(this);
        this.m_ColumnHeader.invalidate();
        this.m_ColumnHeader.validate();
    }

    public void setDynamicRenderer(IDynamicRenderer iDynamicRenderer) {
        this.m_DynamicRenderer = iDynamicRenderer;
        this.m_DynamicRenderer.setSchema(this.m_CellSchema);
    }

    public IDynamicRenderer getDynamicRenderer() {
        return this.m_DynamicRenderer;
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer;
        DataRecord dataRecord = this.getRecord(n, n2);
        if (dataRecord != null && this.m_DynamicRenderer != null && (tableCellRenderer = this.m_DynamicRenderer.getCellRenderer(n, n2, dataRecord)) != null) {
            return tableCellRenderer;
        }
        return super.getCellRenderer(n, n2);
    }

    public DataRecord getRecord(int n, int n2) {
        if (this.m_CellSchema.length > 0) {
            int n3 = n2 % this.m_CellSchema.length;
            TreeNode treeNode = this.getRow(n);
            TreeNode treeNode2 = this.getColumn(n2);
            DataRecord dataRecord = new DataRecord(this.m_CellSchema[n3], new Object[this.m_CellSchema[n3].getColumnCount()]);
            if (treeNode != null) {
                this.buildRecord(dataRecord, treeNode);
            }
            if (treeNode2 != null) {
                this.buildRecord(dataRecord, treeNode2);
            }
            return dataRecord;
        }
        return null;
    }

    public boolean isTotalRow(int n) {
        TreeNode treeNode = this.getRow(n);
        return treeNode == null || treeNode.getChildren().size() > 0;
    }

    public boolean isTotalColumn(int n) {
        TreeNode treeNode = this.getColumn(n);
        return treeNode == null || treeNode.getChildren().size() > 0;
    }

    public boolean isTotal(int n, int n2) {
        TreeNode treeNode = this.getRow(n);
        if (treeNode == null || treeNode.getChildren().size() > 0) {
            return true;
        }
        TreeNode treeNode2 = this.getColumn(n2);
        return treeNode2 == null || treeNode2.getChildren().size() > 0;
    }

    private void buildRecord(DataRecord dataRecord, TreeNode treeNode) {
        Level level = null;
        IDataSet iDataSet = treeNode.getDataSet();
        if (iDataSet != null) {
            level = iDataSet.getLevel();
        }
        if (level != null) {
            TreeNode treeNode2;
            String string = level.getName();
            int n = dataRecord.getSchema().getColumnIndex(string);
            Object object = treeNode.getDataSet().getKey();
            if (n >= 0) {
                dataRecord.setData(n, object);
            }
            if ((treeNode2 = treeNode.getParent()) != null && treeNode2.getDepth() > 0) {
                this.buildRecord(dataRecord, treeNode2);
            }
        }
    }

    protected int getX(TreeNode treeNode, Measure measure) {
        return this.m_ColumnHeader.getX(treeNode, measure);
    }

    protected int getY(TreeNode treeNode) {
        return this.m_RowHeader.getY(treeNode);
    }

    protected TreeNode getRow(int n) {
        return this.m_RowHeader.getNodeAtRow(n);
    }

    protected TreeNode getColumn(int n) {
        int n2 = this.m_ColumnHeader.getMeasureCount();
        if (n2 == 0) {
            return null;
        }
        return this.m_ColumnHeader.getNodeAtColumn(n / n2);
    }

    protected Measure getMeasure(int n) {
        return this.m_ColumnHeader.getMeasure(n);
    }

    private void buildSize() {
        this.m_Size = new Dimension(this.m_ColumnHeader.getPreferredSize().width, this.m_RowHeader.getPreferredSize().height);
    }

    private class CL
    extends ComponentAdapter {
        private CL() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            DataSheet.this.sizeChanged();
        }
    }

    private class DataSheetModel
    extends AbstractTableModel {
        private DataSheetModel() {
        }

        @Override
        public int getColumnCount() {
            return DataSheet.this.m_ColumnHeader.getColumnCount();
        }

        @Override
        public int getRowCount() {
            return DataSheet.this.m_RowHeader.getRowCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TreeNode treeNode = DataSheet.this.getRow(n);
            if (treeNode == null) {
                return null;
            }
            TreeNode treeNode2 = DataSheet.this.getColumn(n2);
            if (treeNode2 == null) {
                return null;
            }
            Measure measure = DataSheet.this.getMeasure(n2);
            return DataSheet.this.m_DataValues.getValue(treeNode, treeNode2, measure);
        }

        public int getColumnWidth(int n) {
            int n2 = 0;
            int n3 = this.getRowCount();
            for (int i = 0; i < n3; ++i) {
                TableCellRenderer tableCellRenderer = DataSheet.this.getCellRenderer(i, n);
                Object object = this.getValueAt(i, n);
                Component component = tableCellRenderer.getTableCellRendererComponent(DataSheet.this, object, false, false, i, n);
                n2 = Math.max(n2, component.getPreferredSize().width);
            }
            return n2;
        }
    }

    private class ML
    extends MouseAdapter {
        private ML() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (mouseEvent.getClickCount() == 2) {
                DataSheet.this.fireEvent("doubleClick");
            } else {
                DataSheet.this.fireEvent("click");
            }
        }
    }

    public static interface IDynamicRenderer {
        public void setSchema(DataSchema[] var1);

        public TableCellRenderer getCellRenderer(int var1, int var2, DataRecord var3);
    }
}

