/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.cube;

import com.elixirtech.data2.olap.Measure;
import com.elixirtech.data2.olap.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataValues {
    private Map<Measure, Map<ValueKey, Object>> m_MeasureHolders = new HashMap<Measure, Map<ValueKey, Object>>();
    private List<Listener> m_Listeners = new ArrayList<Listener>();

    public Object getValue(TreeNode treeNode, TreeNode treeNode2, Measure measure) {
        Object object = null;
        Map<ValueKey, Object> map = this.m_MeasureHolders.get(measure);
        if (map != null) {
            object = map.get(new ValueKey(treeNode, treeNode2));
        }
        return object;
    }

    public void putValue(TreeNode treeNode, TreeNode treeNode2, Measure measure, Object object) {
        Map<ValueKey, Object> map = this.m_MeasureHolders.get(measure);
        if (map == null) {
            map = new HashMap<ValueKey, Object>();
            this.m_MeasureHolders.put(measure, map);
        }
        ValueKey valueKey = new ValueKey(treeNode, treeNode2);
        map.put(valueKey, object);
        this.fireChanged(treeNode, treeNode2, measure);
    }

    public void removeRows(TreeNode treeNode) {
    }

    public void removeColumns(TreeNode treeNode) {
    }

    public void removeMeasure(Measure measure) {
        this.m_MeasureHolders.remove(measure);
    }

    public void addListener(Listener listener) {
        this.m_Listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.m_Listeners.remove(listener);
    }

    protected void fireChanged(TreeNode treeNode, TreeNode treeNode2, Measure measure) {
        Iterator<Listener> iterator = this.m_Listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().valueChanged(treeNode, treeNode2, measure);
        }
    }

    public static class ValueKey {
        private TreeNode m_Row;
        private TreeNode m_Column;

        public ValueKey(TreeNode treeNode, TreeNode treeNode2) {
            this.m_Row = treeNode;
            this.m_Column = treeNode2;
        }

        public int hashCode() {
            return this.m_Row.hashCode() ^ this.m_Column.hashCode();
        }

        public boolean equals(Object object) {
            ValueKey valueKey = (ValueKey)object;
            return this.m_Row == valueKey.m_Row && this.m_Column == valueKey.m_Column;
        }
    }

    public static interface Listener {
        public void valueChanged(TreeNode var1, TreeNode var2, Measure var3);
    }
}

