/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.cube;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.NestedFunction;
import com.elixirtech.data2.olap.AllDataSet;
import com.elixirtech.data2.olap.Index;
import com.elixirtech.data2.olap.Measure;
import com.elixirtech.data2.olap.TreeNode;
import com.elixirtech.ensemble.cube.DataValues;
import java.util.LinkedList;

public final class DataValuesBuilder
extends Thread {
    private DataValues m_DataValues;
    private DataRecord[] m_Records;
    private boolean m_Stop;
    private LinkedList<Task> m_Queue = new LinkedList();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DataValuesBuilder.class);

    public DataValuesBuilder(DataValues dataValues, DataRecord[] dataRecordArray) {
        this.m_DataValues = dataValues;
        this.m_Records = dataRecordArray;
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        try {
            while (!this.m_Stop) {
                Task task = this.getTask();
                task.calculate(this.m_DataValues, this.m_Records);
            }
        }
        catch (InterruptedException interruptedException) {
            m_Log.warn((Object)"DataValuesBuilder interrupted exception");
            Thread.currentThread().interrupt();
        }
    }

    public void stopTasks() {
        this.m_Stop = true;
    }

    public synchronized void addTask(Task task) {
        this.m_Queue.addLast(task);
        this.notify();
    }

    public synchronized Task getTask() throws InterruptedException {
        while (this.m_Queue.isEmpty()) {
            this.wait();
        }
        return this.m_Queue.removeFirst();
    }

    public static interface Task {
        public void calculate(DataValues var1, DataRecord[] var2);
    }

    public static class TerminateTask
    implements Task {
        private DataValuesBuilder m_DataValuesBuilder;

        public TerminateTask(DataValuesBuilder dataValuesBuilder) {
            this.m_DataValuesBuilder = dataValuesBuilder;
        }

        @Override
        public void calculate(DataValues dataValues, DataRecord[] dataRecordArray) {
            this.m_DataValuesBuilder.stopTasks();
        }
    }

    public static class BlockTask
    implements Task {
        private TreeNode[] m_Rows;
        private TreeNode[] m_Columns;
        private Measure[] m_Measures;

        public BlockTask(TreeNode[] treeNodeArray, TreeNode[] treeNodeArray2, Measure[] measureArray) {
            this.m_Rows = treeNodeArray;
            this.m_Columns = treeNodeArray2;
            this.m_Measures = measureArray;
        }

        @Override
        public void calculate(DataValues dataValues, DataRecord[] dataRecordArray) {
            for (int i = 0; i < this.m_Rows.length; ++i) {
                for (int j = 0; j < this.m_Columns.length; ++j) {
                    for (int k = 0; k < this.m_Measures.length; ++k) {
                        Function function = this.m_Measures[k].getFunction();
                        Index index = this.m_Rows[i].getTreeIndex();
                        Index index2 = this.m_Columns[j].getTreeIndex();
                        Index index3 = index.intersection(index2);
                        if (function instanceof NestedFunction) {
                            AllDataSet allDataSet;
                            Object[] objectArray;
                            TreeNode treeNode = this.m_Rows[i].getParent();
                            if (treeNode != null) {
                                objectArray = treeNode.getTreeIndex();
                                allDataSet = objectArray.intersection(index2);
                            } else {
                                allDataSet = new AllDataSet(dataRecordArray.length);
                            }
                            objectArray = allDataSet.collect(dataRecordArray, this.m_Measures[k].getIndex());
                            ((NestedFunction)function).setRange(objectArray);
                        }
                        index3.apply(function, dataRecordArray, this.m_Measures[k].getIndex());
                        dataValues.putValue(this.m_Rows[i], this.m_Columns[j], this.m_Measures[k], function.getResult());
                        function.reset();
                    }
                }
            }
        }
    }

    public static class SimpleTask
    implements Task {
        private TreeNode m_Row;
        private TreeNode m_Column;
        private Measure m_Measure;

        public SimpleTask(TreeNode treeNode, TreeNode treeNode2, Measure measure) {
            this.m_Row = treeNode;
            this.m_Column = treeNode2;
            this.m_Measure = measure;
        }

        @Override
        public void calculate(DataValues dataValues, DataRecord[] dataRecordArray) {
            Index index;
            TreeNode treeNode;
            Index index2 = this.m_Column.getTreeIndex();
            Function function = this.m_Measure.getFunction();
            if (function instanceof NestedFunction) {
                Object[] objectArray;
                treeNode = this.m_Row.getParent();
                if (treeNode != null) {
                    objectArray = treeNode.getTreeIndex();
                    index = objectArray.intersection(index2);
                } else {
                    index = new AllDataSet(dataRecordArray.length);
                }
                objectArray = index.collect(dataRecordArray, this.m_Measure.getIndex());
                ((NestedFunction)function).setRange(objectArray);
            }
            index = this.m_Row.getTreeIndex();
            treeNode = index.intersection(index2);
            treeNode.apply(function, dataRecordArray, this.m_Measure.getIndex());
            dataValues.putValue(this.m_Row, this.m_Column, this.m_Measure, function.getResult());
            function.reset();
        }
    }
}

