/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.cube;

import com.elixirtech.data2.olap.CubeGrouping;
import com.elixirtech.data2.olap.RootTreeNode;
import com.elixirtech.data2.olap.TreeNode;
import com.elixirtech.ensemble.EnsembleAction;
import com.elixirtech.ensemble.cube.ExpandableLabel;
import com.elixirtech.ensemble.cube.HeaderTreeModel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class ExpandLevelAction
extends EnsembleAction {
    private HeaderTreeModel m_Model;
    private CubeGrouping m_Grouping;
    private ExpandableLabel m_Label;

    public ExpandLevelAction(HeaderTreeModel headerTreeModel, CubeGrouping cubeGrouping, ExpandableLabel expandableLabel) {
        super("Cube.ExpandLevel");
        this.m_Model = headerTreeModel;
        this.m_Grouping = cubeGrouping;
        this.m_Label = expandableLabel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TreeNode treeNode = (TreeNode)this.m_Label.getUserObject();
        int n = treeNode.getDepth();
        RootTreeNode rootTreeNode = this.m_Grouping.getRoot();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        this.buildLayer((TreeNode)rootTreeNode, n, arrayList);
        for (TreeNode treeNode2 : arrayList) {
            JComponent jComponent = this.m_Model.getComponent((Object)treeNode2);
            if (!(jComponent instanceof ExpandableLabel)) continue;
            ((ExpandableLabel)jComponent).setExpanded(true);
        }
    }

    private void buildLayer(TreeNode treeNode, int n, List<TreeNode> list) {
        if (treeNode.getDepth() == n) {
            list.add(treeNode);
        } else {
            for (TreeNode treeNode2 : treeNode.getChildren()) {
                this.buildLayer(treeNode2, n, list);
            }
        }
    }
}

