/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.cube;

import com.elixirtech.ensemble.cube.ChangeSupport;
import com.elixirtech.ensemble.cube.TreeButton;
import com.elixirtech.i18n.I18NBypass;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;

public class ExpandableLabel
extends JPanel {
    public static int HORIZONTAL = 1;
    public static int VERTICAL = 2;
    JToggleButton m_Button;
    JLabel m_Label;
    JLabel m_Label2;
    private Object m_UserObject;
    private int m_LabelHeight = DEFAULT_LABEL_HEIGHT;
    private boolean m_After;
    private int m_ExpandDirection;
    protected ChangeSupport m_ChangeSupport = new ChangeSupport(this);
    static final Dimension EMPTY = new Dimension(0, 0);
    private static final int GAP = 2;
    private static final int DEFAULT_LABEL_HEIGHT;

    public ExpandableLabel(Font font, Color color, boolean bl, String string) {
        this.setLayout(new VCenterLayout());
        this.setOpaque(true);
        this.m_Label = I18NBypass.newLabel(string);
        this.m_Label.setFont(font);
        this.m_Label.setForeground(color);
        if (bl) {
            this.m_Button = new TreeButton();
            this.add(this.m_Button);
            this.m_Button.setSelected(true);
            this.m_Button.addActionListener(this.m_ChangeSupport);
        }
        this.add(this.m_Label);
    }

    public ExpandableLabel(Font font, Color color, boolean bl, String string, String string2, int n, int n2, boolean bl2) {
        this(font, color, bl, string);
        this.m_ExpandDirection = n;
        this.m_Label2 = I18NBypass.newLabel(string2);
        this.m_Label2.setFont(font);
        this.m_Label2.setForeground(color);
        this.m_Label2.setVerticalAlignment(0);
        this.m_Label2.setHorizontalAlignment(n2);
        this.m_After = bl2;
        this.add(this.m_Label2);
    }

    public void updatePresentation(Font font, Color color, int n) {
        this.m_Label.setFont(font);
        this.m_Label.setForeground(color);
        this.m_LabelHeight = n;
        if (this.m_Label2 != null) {
            this.m_Label2.setFont(font);
            this.m_Label2.setForeground(color);
        }
    }

    public boolean isExpanded() {
        if (this.m_Button != null) {
            return this.m_Button.isSelected();
        }
        return false;
    }

    public void setExpanded(boolean bl) {
        if (this.m_Button != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "expand");
            this.m_ChangeSupport.actionPerformed(actionEvent);
        }
    }

    public boolean isExpandable() {
        return this.m_Button != null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.m_ChangeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.m_ChangeSupport.removeChangeListener(changeListener);
    }

    public String getText() {
        return this.m_Label.getText();
    }

    public void setUserObject(Object object) {
        this.m_UserObject = object;
    }

    public Object getUserObject() {
        return this.m_UserObject;
    }

    static {
        JToggleButton jToggleButton = new JToggleButton("Hello World", UIManager.getIcon("Tree.expandedIcon"));
        jToggleButton.setBorder(null);
        jToggleButton.setFont(UIManager.getFont("Table.font"));
        DEFAULT_LABEL_HEIGHT = jToggleButton.getPreferredSize().height + 2;
    }

    private class VCenterLayout
    implements LayoutManager {
        private VCenterLayout() {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            Dimension dimension2 = ExpandableLabel.this.m_Button != null ? ExpandableLabel.this.m_Button.getPreferredSize() : EMPTY;
            Dimension dimension3 = ExpandableLabel.this.m_Label.getPreferredSize();
            int n = ExpandableLabel.this.m_LabelHeight - insets.top - insets.bottom;
            Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension2.width, n);
            Rectangle rectangle2 = new Rectangle(insets.left + dimension2.width + 2, insets.top, dimension3.width, n);
            if (ExpandableLabel.this.m_Button != null) {
                ExpandableLabel.this.m_Button.setBounds(rectangle);
            }
            ExpandableLabel.this.m_Label.setBounds(rectangle2);
            if (ExpandableLabel.this.m_Label2 != null) {
                boolean bl;
                boolean bl2 = bl = ExpandableLabel.this.m_Button != null ? ExpandableLabel.this.m_Button.isSelected() : false;
                if (bl) {
                    ExpandableLabel.this.m_Label.setToolTipText(null);
                    ExpandableLabel.this.m_Label2.setVisible(true);
                    Dimension dimension4 = ExpandableLabel.this.m_Label2.getPreferredSize();
                    Rectangle rectangle3 = new Rectangle(insets.left, dimension.height - dimension4.height, dimension.width, n);
                    if (ExpandableLabel.this.m_ExpandDirection == HORIZONTAL) {
                        rectangle3.y = insets.top + ExpandableLabel.this.m_LabelHeight + 2;
                    } else if (!ExpandableLabel.this.m_After) {
                        rectangle3.y = insets.top;
                    }
                    ExpandableLabel.this.m_Label2.setBounds(rectangle3);
                } else {
                    ExpandableLabel.this.m_Label2.setVisible(false);
                    ExpandableLabel.this.m_Label.setToolTipText(ExpandableLabel.this.m_Label2.getText());
                }
            }
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            boolean bl = ExpandableLabel.this.m_Button != null ? ExpandableLabel.this.m_Button.isSelected() : false;
            Insets insets = container.getInsets();
            Dimension dimension = ExpandableLabel.this.m_Button != null ? ExpandableLabel.this.m_Button.getPreferredSize() : EMPTY;
            Dimension dimension2 = ExpandableLabel.this.m_Label.getPreferredSize();
            int n = insets.left + dimension.width + 2 + dimension2.width + insets.right + 2;
            if (bl && ExpandableLabel.this.m_Label2 != null) {
                Dimension dimension3 = ExpandableLabel.this.m_Label2.getPreferredSize();
                if (!ExpandableLabel.this.m_After) {
                    n += dimension3.width / 4;
                }
            }
            return new Dimension(n, ExpandableLabel.this.m_LabelHeight);
        }
    }
}

