/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.cube;

import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.olap.Measure;
import com.elixirtech.data2.olap.RootTreeNode;
import com.elixirtech.data2.olap.TreeNode;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.cube.ExpandableLabel;
import com.elixirtech.ensemble.cube.FixedExpandedLabel;
import com.elixirtech.ensemble.cube.IStyleCallback;
import com.elixirtech.ensemble.cube.MeasureLabel;
import com.elixirtech.ensemble.cube.TableStyle;
import com.elixirtech.tree.TreeModel;
import com.elixirtech.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;

public class HeaderTreeModel
implements TreeModel {
    public static int COLUMN = ExpandableLabel.HORIZONTAL;
    public static int ROW = ExpandableLabel.VERTICAL;
    private RootTreeNode m_Root;
    private Measure[] m_Measures;
    private Map<TreeNode, ExpandableLabel> m_Components = new HashMap<TreeNode, ExpandableLabel>();
    private ChangeListener m_ChangeListener;
    private MouseListener m_MouseListener;
    private TableStyle m_TableStyle;
    private Map<TreeNode, MeasureNode[]> m_MeasureMap = new HashMap<TreeNode, MeasureNode[]>();
    private Font m_Font;
    private Color m_FontColor;
    private Color m_MeasureBackground = Color.WHITE;
    private int m_LineHeight;
    private HeaderInfo m_HeaderInfo;

    private HeaderTreeModel(RootTreeNode rootTreeNode, IStyleCallback iStyleCallback, ChangeListener changeListener, MouseListener mouseListener, TableStyle tableStyle) {
        this.m_Root = rootTreeNode;
        this.m_Font = iStyleCallback.getFont();
        this.m_FontColor = iStyleCallback.getFontColor();
        this.m_LineHeight = iStyleCallback.getLineHeight();
        this.m_ChangeListener = changeListener;
        this.m_MouseListener = mouseListener;
        this.m_TableStyle = tableStyle;
    }

    public HeaderTreeModel(RootTreeNode rootTreeNode, IStyleCallback iStyleCallback, ChangeListener changeListener, MouseListener mouseListener, TableStyle tableStyle, HeaderInfo headerInfo) {
        this(rootTreeNode, iStyleCallback, changeListener, mouseListener, tableStyle);
        this.m_HeaderInfo = headerInfo;
    }

    public void setMeasureBackground(Color color) {
        this.m_MeasureBackground = color;
    }

    public void setTableStyle(TableStyle tableStyle) {
        this.m_TableStyle = tableStyle;
    }

    public void setFont(Font font, Color color, int n) {
        this.m_Font = font;
        this.m_FontColor = color;
        this.m_LineHeight = n;
    }

    public void updatePresentation() {
        this.updateRootPresentation(this.m_Root);
        for (MeasureNode[] measureNodeArray : this.m_MeasureMap.values()) {
            for (int i = 0; i < measureNodeArray.length; ++i) {
                measureNodeArray[i].label.setBackground(this.m_MeasureBackground);
                measureNodeArray[i].label.updatePresentation(this.m_Font, this.m_FontColor, this.m_LineHeight);
            }
        }
    }

    private void updateRootPresentation(RootTreeNode rootTreeNode) {
        JComponent jComponent = this.getComponent((TreeNode)rootTreeNode);
        if (jComponent instanceof ExpandableLabel) {
            int n = this.m_LineHeight;
            if (!rootTreeNode.isShowTotals() && StringUtil.isEmpty(rootTreeNode.getName())) {
                n = 8;
            }
            ExpandableLabel expandableLabel = (ExpandableLabel)jComponent;
            expandableLabel.updatePresentation(this.m_Font, this.m_FontColor, n);
            expandableLabel.setBackground(this.m_TableStyle.getTreeColor(rootTreeNode.getDepth()));
        }
        for (ExpandableLabel expandableLabel : rootTreeNode.getChildren()) {
            this.updatePresentation((TreeNode)expandableLabel);
        }
    }

    private void updatePresentation(TreeNode treeNode) {
        JComponent jComponent = this.getComponent(treeNode);
        if (jComponent instanceof ExpandableLabel) {
            ExpandableLabel expandableLabel = (ExpandableLabel)jComponent;
            expandableLabel.updatePresentation(this.m_Font, this.m_FontColor, this.m_LineHeight);
            expandableLabel.setBackground(this.m_TableStyle.getTreeColor(treeNode.getDepth()));
        }
        for (TreeNode treeNode2 : treeNode.getChildren()) {
            this.updatePresentation(treeNode2);
        }
    }

    public void setMeasures(Measure[] measureArray) {
        if (measureArray.length == 0) {
            throw new IllegalArgumentException("measures.length==null");
        }
        this.m_Measures = measureArray;
        this.m_MeasureMap.clear();
        this.buildMeasures((TreeNode)this.m_Root);
    }

    public List<TreeNode> getChildren(Object object) {
        if (object instanceof MeasureNode) {
            return Collections.emptyList();
        }
        return ((TreeNode)object).getChildren();
    }

    @Override
    public JComponent getComponent(Object object) {
        if (object instanceof MeasureNode) {
            return ((MeasureNode)object).label;
        }
        return this.getComponent((TreeNode)object);
    }

    @Override
    public Object getParent(Object object) {
        if (object instanceof MeasureNode) {
            return ((MeasureNode)object).parent;
        }
        return ((TreeNode)object).getParent();
    }

    @Override
    public Object getRoot() {
        return this.m_Root;
    }

    @Override
    public boolean hasChildren(Object object) {
        if (object instanceof MeasureNode) {
            return false;
        }
        return !((TreeNode)object).isLeaf();
    }

    @Override
    public boolean isExpanded(Object object) {
        if (object instanceof MeasureNode) {
            return false;
        }
        ExpandableLabel expandableLabel = (ExpandableLabel)this.getComponent((TreeNode)object);
        return expandableLabel.isExpanded();
    }

    public void expandAll() {
        this.expandAll((TreeNode)this.m_Root);
    }

    public void expandAll(TreeNode treeNode) {
        ExpandableLabel expandableLabel = (ExpandableLabel)this.getComponent(treeNode);
        expandableLabel.setExpanded(true);
    }

    @Override
    public int getMeasureCount() {
        if (this.m_Measures == null) {
            return 0;
        }
        return this.m_Measures.length;
    }

    @Override
    public int getDepth(Object object) {
        return ((TreeNode)object).getDepth();
    }

    @Override
    public boolean hasMeasures(Object object) {
        if (this.m_Measures == null) {
            return false;
        }
        if (object instanceof TreeNode) {
            return ((TreeNode)object).isShowTotals();
        }
        return false;
    }

    public List<MeasureNode> getMeasures(Object object) {
        if (this.m_Measures == null) {
            return Collections.emptyList();
        }
        MeasureNode[] measureNodeArray = this.m_MeasureMap.get(object);
        ArrayList<MeasureNode> arrayList = new ArrayList<MeasureNode>();
        for (int i = 0; i < measureNodeArray.length; ++i) {
            arrayList.add(measureNodeArray[i]);
        }
        return arrayList;
    }

    @Override
    public boolean isShowTotals(Object object) {
        if (object instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)object;
            return treeNode.isLeaf() || treeNode.isShowTotals();
        }
        return false;
    }

    private JComponent getComponent(TreeNode treeNode) {
        ExpandableLabel expandableLabel = this.m_Components.get(treeNode);
        if (expandableLabel == null) {
            if (treeNode.isLeaf()) {
                expandableLabel = new ExpandableLabel(this.m_Font, this.m_FontColor, false, treeNode.getName());
            } else if (!treeNode.isShowTotals()) {
                expandableLabel = new FixedExpandedLabel(this.m_Font, this.m_FontColor, treeNode.getName());
            } else {
                String string = this.m_HeaderInfo.titles[treeNode.getDepth()];
                int n = 2;
                if (this.m_HeaderInfo.headerType == ROW) {
                    n = 4;
                } else if (this.m_HeaderInfo.headerType == COLUMN && this.m_HeaderInfo.totalAfter) {
                    n = 4;
                }
                expandableLabel = new ExpandableLabel(this.m_Font, this.m_FontColor, true, treeNode.getName(), string, this.m_HeaderInfo.headerType, n, this.m_HeaderInfo.totalAfter);
                expandableLabel.addChangeListener(this.m_ChangeListener);
            }
            expandableLabel.setUserObject(treeNode);
            expandableLabel.addMouseListener(this.m_MouseListener);
            expandableLabel.setBorder(BorderFactory.createEtchedBorder());
            expandableLabel.setBackground(this.m_TableStyle.getTreeColor(treeNode.getDepth()));
            this.m_Components.put(treeNode, expandableLabel);
        }
        return expandableLabel;
    }

    private void buildMeasures(TreeNode treeNode) {
        MeasureNode[] measureNodeArray = new MeasureNode[this.m_Measures.length];
        for (int i = 0; i < measureNodeArray.length; ++i) {
            measureNodeArray[i] = this.buildMeasureNode(treeNode, this.m_Measures[i]);
        }
        this.m_MeasureMap.put(treeNode, measureNodeArray);
        for (TreeNode treeNode2 : treeNode.getChildren()) {
            this.buildMeasures(treeNode2);
        }
    }

    private MeasureNode buildMeasureNode(TreeNode treeNode, Measure measure) {
        MeasureNode measureNode = new MeasureNode();
        measureNode.measure = measure;
        measureNode.parent = treeNode;
        measureNode.label = new MeasureLabel(this.m_Font, this.m_FontColor, false, HeaderTreeModel.getMeasureName(treeNode, measure), treeNode, measure);
        measureNode.label.setBackground(this.m_MeasureBackground);
        measureNode.label.addChangeListener(this.m_ChangeListener);
        measureNode.label.addMouseListener(this.m_MouseListener);
        return measureNode;
    }

    public static String getMeasureName(TreeNode treeNode, Measure measure) {
        TreeNode[] treeNodeArray = treeNode.getPath();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < treeNodeArray.length; ++i) {
            stringBuffer.append(treeNodeArray[i].getName());
            if (i >= treeNodeArray.length - 1) continue;
            stringBuffer.append('/');
        }
        String string = stringBuffer.toString();
        String string2 = measure.getColumnNamePattern();
        if (StringUtil.isEmpty(string2)) {
            return measure.getResultName();
        }
        if (StringUtil.isEmpty(string)) {
            string = I18N.ENSEMBLE.getString("CubeHeader.All");
        }
        String[] stringArray = string.split("/");
        ArgumentMap.CallbackMap callbackMap = new ArgumentMap.CallbackMap();
        for (int i = 0; i < stringArray.length; ++i) {
            callbackMap.put((Object)String.valueOf(i), (Object)stringArray[i]);
        }
        String string3 = measure.getResultName();
        callbackMap.put((Object)"hierarchy", (Object)string);
        callbackMap.put((Object)"field", (Object)measure.getName());
        callbackMap.put((Object)"measure", (Object)string3);
        callbackMap.put((Object)"fn", (Object)measure.getFunction().getName());
        callbackMap.put((Object)"*", (Object)(string + "/" + string3));
        return ArgumentMap.substitute((String)string2, (ArgumentMap.ICallback)callbackMap);
    }

    public static class HeaderInfo {
        public int headerType;
        public String[] titles = new String[0];
        public boolean totalAfter = false;
    }

    public static class MeasureNode {
        public TreeNode parent;
        public Measure measure;
        public MeasureLabel label;
    }
}

