/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.cube;

import com.elixirtech.data2.olap.Measure;
import com.elixirtech.data2.olap.TreeNode;
import com.elixirtech.ensemble.cube.ExpandableLabel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class MeasureLabel
extends ExpandableLabel {
    private TreeNode m_Node;
    private Measure m_Measure;
    private boolean m_Dragging;
    private static final Cursor SIZE_CURSOR = Cursor.getPredefinedCursor(11);

    public MeasureLabel(Font font, Color color, boolean bl, String string, TreeNode treeNode, Measure measure) {
        super(font, color, bl, string);
        this.enableEvents(48L);
        this.m_Node = treeNode;
        this.m_Measure = measure;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setBackground(Color.white);
    }

    public void setColumnWidth(int n) {
        Dimension dimension = this.getPreferredSize();
        dimension.width = Math.max(20, n);
        this.setPreferredSize(dimension);
    }

    public TreeNode getNode() {
        return this.m_Node;
    }

    public Measure getMeasure() {
        return this.m_Measure;
    }

    @Override
    public String getText() {
        return this.m_Node.getName() + "/" + super.getText();
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        if (n == 501) {
            if (this.isDragSpot(mouseEvent)) {
                this.m_Dragging = true;
            } else {
                super.processMouseEvent(mouseEvent);
            }
        } else if (n == 502 && this.m_Dragging) {
            this.m_Dragging = false;
            this.setColumnWidth(mouseEvent.getPoint().x);
            this.refresh();
            this.m_ChangeSupport.fireChanged();
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.isDragSpot(mouseEvent) || this.m_Dragging) {
            this.setCursor(SIZE_CURSOR);
            if (this.m_Dragging) {
                this.setColumnWidth(mouseEvent.getPoint().x);
                this.refresh();
            }
        } else {
            this.setCursor(null);
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    private boolean isDragSpot(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Dimension dimension = this.getSize();
        return point.x > dimension.width - 5;
    }

    private void refresh() {
        this.invalidate();
        JComponent jComponent = (JComponent)this.getParent();
        jComponent.invalidate();
        jComponent = (JComponent)jComponent.getParent();
        jComponent.invalidate();
        jComponent.validate();
    }
}

