/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.cube;

import com.elixirtech.data2.olap.CubeGrouping;
import com.elixirtech.data2.olap.RootTreeNode;
import com.elixirtech.data2.olap.TreeNode;
import com.elixirtech.ensemble.cube.ChangeSupport;
import com.elixirtech.ensemble.cube.CollapseLevelAction;
import com.elixirtech.ensemble.cube.DataSheet;
import com.elixirtech.ensemble.cube.ExpandLevelAction;
import com.elixirtech.ensemble.cube.ExpandableLabel;
import com.elixirtech.ensemble.cube.HeaderTreeModel;
import com.elixirtech.ensemble.cube.ICubePresentation;
import com.elixirtech.ensemble.cube.IStyleCallback;
import com.elixirtech.ensemble.cube.TableStyle;
import com.elixirtech.tree.TreeLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RowHeader2
extends JPanel
implements ChangeListener {
    DataSheet m_Sheet;
    private CubeGrouping m_Grouping;
    private boolean m_TotalsAfter;
    private IStyleCallback m_StyleCallback;
    private TableStyle m_TableStyle;
    private TreeLayoutManager m_TreeLayout;
    private List<TreeNode> m_GroupList = new ArrayList<TreeNode>();
    private List<TreeNode> m_VisibleList = new ArrayList<TreeNode>();
    private final List<TreeNode> m_RowList = new ArrayList<TreeNode>();
    private ChangeSupport m_ChangeSupport = new ChangeSupport(this);
    private ML m_ML = new ML();
    private HeaderTreeModel m_Model;
    private boolean m_ShowParents;

    public RowHeader2(DataSheet dataSheet, IStyleCallback iStyleCallback) {
        this.m_Sheet = dataSheet;
        this.m_StyleCallback = iStyleCallback;
    }

    public void updatePresentation() {
        this.m_TableStyle = new TableStyle(this.m_StyleCallback.getColor1(), this.m_StyleCallback.getColor2(), this.m_Grouping.getDepth());
        this.m_Model.setFont(this.m_StyleCallback.getFont(), this.m_StyleCallback.getFontColor(), this.m_StyleCallback.getLineHeight());
        this.m_Model.setMeasureBackground(this.m_StyleCallback.getMeasureBackground());
        this.m_Model.setTableStyle(this.m_TableStyle);
        this.m_Model.updatePresentation();
        this.layoutUi();
    }

    public void refresh(CubeGrouping cubeGrouping) {
        this.m_Grouping = cubeGrouping;
        this.m_TableStyle = new TableStyle(this.m_StyleCallback.getColor1(), this.m_StyleCallback.getColor2(), this.m_Grouping.getDepth());
        RootTreeNode rootTreeNode = this.m_Grouping.getRoot();
        this.buildGroupList((TreeNode)rootTreeNode);
        HeaderTreeModel.HeaderInfo headerInfo = new HeaderTreeModel.HeaderInfo();
        headerInfo.headerType = HeaderTreeModel.ROW;
        headerInfo.totalAfter = this.m_TotalsAfter;
        headerInfo.titles = this.getTitles();
        this.m_Model = new HeaderTreeModel(rootTreeNode, this.m_StyleCallback, this, this.m_ML, this.m_TableStyle, headerInfo);
        this.buildVisibleList((TreeNode)rootTreeNode);
        this.buildRowList((TreeNode)rootTreeNode);
        this.updatePresentation();
    }

    public boolean isExpanded(TreeNode treeNode) {
        return this.m_Model.isExpanded(treeNode);
    }

    public CubeGrouping getGrouping() {
        return this.m_Grouping;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.m_TreeLayout != null) {
            this.m_TreeLayout.setDirty(true);
        }
        this.layoutUi();
        this.m_ChangeSupport.fireChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.m_ChangeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.m_ChangeSupport.removeChangeListener(changeListener);
    }

    public void setShowParents(boolean bl) {
        this.m_ShowParents = bl;
    }

    public boolean isShowParents() {
        return this.m_ShowParents;
    }

    public void setTotalsAfter(boolean bl) {
        this.m_TotalsAfter = bl;
    }

    public boolean isTotalsAfter() {
        return this.m_TotalsAfter;
    }

    public int getRowCount() {
        return this.m_TreeLayout.getRowCount();
    }

    public int getVisibleRowCount() {
        return this.m_VisibleList.size();
    }

    public int getRowHeight(int n) {
        return this.m_StyleCallback.getLineHeight();
    }

    public int getLevelCount() {
        return this.m_Grouping.getLevelCount();
    }

    public String[] getLevels() {
        int n = this.m_Grouping.getLevelCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.m_Grouping.getLevel(i).getName();
        }
        return stringArray;
    }

    public String[] getTitles() {
        int n = this.m_Grouping.getLevelCount() + 1;
        String[] stringArray = new String[n];
        ICubePresentation iCubePresentation = this.m_Sheet.getCubePresentation();
        stringArray[0] = iCubePresentation.getRowTotalsTitle();
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray[i] = this.m_Grouping.getLevel(i - 1).getTotalTitle();
        }
        return stringArray;
    }

    public int getY(TreeNode treeNode) {
        return this.m_GroupList.indexOf(treeNode);
    }

    public TreeNode getNode(int n) {
        if (n >= this.m_VisibleList.size()) {
            return null;
        }
        return this.m_VisibleList.get(n);
    }

    public TreeNode getNodeAtRow(int n) {
        if (n >= this.m_RowList.size()) {
            return null;
        }
        return this.m_RowList.get(n);
    }

    public TreeNode[] getRows() {
        TreeNode[] treeNodeArray = new TreeNode[this.m_GroupList.size()];
        this.m_GroupList.toArray(treeNodeArray);
        return treeNodeArray;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width < 32) {
            dimension.width = 32;
        }
        return dimension;
    }

    public int getColumnCount() {
        return this.m_TreeLayout.getColumnCount();
    }

    public int getColumnWidth(int n) {
        return this.m_TreeLayout.getColumnWidth(n);
    }

    protected void applyLayoutManager() {
        this.m_TreeLayout = TreeLayoutManager.newInstance(this.m_Model, 2, this.m_ShowParents, this.m_TotalsAfter);
        this.m_TreeLayout.setMinimumHeight(this.m_StyleCallback.getLineHeight());
        this.setLayout(this.m_TreeLayout);
        this.invalidate();
        this.validate();
    }

    protected void layoutUi() {
        this.m_VisibleList.clear();
        this.m_RowList.clear();
        RootTreeNode rootTreeNode = this.m_Grouping.getRoot();
        this.buildVisibleList((TreeNode)rootTreeNode);
        this.buildRowList((TreeNode)rootTreeNode);
        this.applyLayoutManager();
    }

    private void buildGroupList(TreeNode treeNode) {
        if (treeNode.isLeaf()) {
            this.m_GroupList.add(treeNode);
        } else if (this.m_TotalsAfter) {
            for (TreeNode treeNode2 : treeNode.getChildren()) {
                this.buildGroupList(treeNode2);
            }
            if (treeNode.isShowTotals()) {
                this.m_GroupList.add(treeNode);
            }
        } else {
            if (treeNode.isShowTotals()) {
                this.m_GroupList.add(treeNode);
            }
            for (TreeNode treeNode3 : treeNode.getChildren()) {
                this.buildGroupList(treeNode3);
            }
        }
    }

    private void buildVisibleList(TreeNode treeNode) {
        if (this.m_TotalsAfter) {
            if (this.m_Model.isExpanded(treeNode)) {
                for (TreeNode treeNode2 : treeNode.getChildren()) {
                    this.buildVisibleList(treeNode2);
                }
            }
            this.m_VisibleList.add(treeNode);
        } else {
            this.m_VisibleList.add(treeNode);
            if (this.m_Model.isExpanded(treeNode)) {
                for (TreeNode treeNode3 : treeNode.getChildren()) {
                    this.buildVisibleList(treeNode3);
                }
            }
        }
    }

    private void buildRowList(TreeNode treeNode) {
        if (this.m_TotalsAfter) {
            if (this.m_Model.isExpanded(treeNode)) {
                for (TreeNode treeNode2 : treeNode.getChildren()) {
                    this.buildRowList(treeNode2);
                }
            }
            if (treeNode.isLeaf() || treeNode.isShowTotals()) {
                this.m_RowList.add(treeNode);
            }
        } else {
            if (treeNode.isLeaf() || treeNode.isShowTotals()) {
                this.m_RowList.add(treeNode);
            }
            if (this.m_Model.isExpanded(treeNode)) {
                for (TreeNode treeNode3 : treeNode.getChildren()) {
                    this.buildRowList(treeNode3);
                }
            }
        }
    }

    private class ML
    extends MouseAdapter {
        private int[] m_DownColumns;

        private ML() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.doPopup(mouseEvent);
            } else {
                Component component = mouseEvent.getComponent();
                this.m_DownColumns = this.getRows(component);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.doPopup(mouseEvent);
            } else if (this.m_DownColumns != null) {
                Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), RowHeader2.this);
                Component component = RowHeader2.this.getComponentAt(point);
                int[] nArray = this.getRows(component);
                if (nArray != null) {
                    int n;
                    int n2 = this.m_DownColumns[0];
                    int n3 = this.m_DownColumns[0];
                    for (n = 1; n < this.m_DownColumns.length; ++n) {
                        n2 = Math.min(n2, this.m_DownColumns[n]);
                        n3 = Math.max(n3, this.m_DownColumns[n]);
                    }
                    for (n = 0; n < nArray.length; ++n) {
                        n2 = Math.min(n2, nArray[n]);
                        n3 = Math.max(n3, nArray[n]);
                    }
                    RowHeader2.this.m_Sheet.setDisableEvents(true);
                    if (!mouseEvent.isControlDown()) {
                        RowHeader2.this.m_Sheet.clearSelection();
                    }
                    RowHeader2.this.m_Sheet.addRowSelectionInterval(n2, n3);
                    n = RowHeader2.this.m_Sheet.getColumnCount();
                    if (n > 0) {
                        RowHeader2.this.m_Sheet.addColumnSelectionInterval(0, n - 1);
                    }
                    RowHeader2.this.m_Sheet.setDisableEvents(false);
                    this.fireEvent("select");
                }
                this.m_DownColumns = null;
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (mouseEvent.getClickCount() == 2) {
                this.fireEvent("doubleClick");
            } else {
                this.fireEvent("click");
            }
        }

        private void doPopup(MouseEvent mouseEvent) {
            ExpandableLabel expandableLabel;
            Component component = mouseEvent.getComponent();
            if (component instanceof ExpandableLabel && (expandableLabel = (ExpandableLabel)component).isExpandable()) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(new ExpandLevelAction(RowHeader2.this.m_Model, RowHeader2.this.m_Grouping, expandableLabel));
                jPopupMenu.add(new CollapseLevelAction(RowHeader2.this.m_Model, RowHeader2.this.m_Grouping, expandableLabel));
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void fireEvent(String string) {
            RowHeader2.this.m_Sheet.fireEvent(string);
        }

        private int[] getRows(Component component) {
            TreeNode treeNode;
            if (component instanceof ExpandableLabel && (treeNode = (TreeNode)((ExpandableLabel)component).getUserObject()) != null) {
                return this.getTreeNodeRows(treeNode);
            }
            return null;
        }

        private int[] getTreeNodeRows(TreeNode treeNode) {
            int n = RowHeader2.this.m_RowList.indexOf(treeNode);
            if (n >= 0) {
                return new int[]{n};
            }
            return null;
        }
    }
}

