/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.cube;

import com.elixirtech.ui.SwingUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import javax.swing.JTable;

public class SelectionMemento {
    private final int m_ColCount;
    private final int m_RowCount;
    private final List<Point> m_Cells;

    public SelectionMemento(JTable jTable) {
        this.m_ColCount = jTable.getColumnCount();
        this.m_RowCount = jTable.getRowCount();
        this.m_Cells = new ArrayList<Point>();
        int n = jTable.getSelectedRow();
        int n2 = jTable.getSelectionModel().getMaxSelectionIndex();
        int n3 = jTable.getSelectedColumn();
        int n4 = jTable.getColumnModel().getSelectionModel().getMaxSelectionIndex();
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                if (!jTable.isCellSelected(i, j)) continue;
                this.m_Cells.add(new Point(j, i));
            }
        }
    }

    public SelectionMemento(int n, int n2, List<Point> list) {
        this.m_ColCount = n;
        this.m_RowCount = n2;
        this.m_Cells = new ArrayList<Point>();
        this.m_Cells.addAll(list);
    }

    public void apply(final JTable jTable) {
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                int n = jTable.getColumnCount();
                int n2 = jTable.getRowCount();
                if (SelectionMemento.this.m_ColCount == n && SelectionMemento.this.m_RowCount == n2) {
                    jTable.clearSelection();
                    for (Point point : SelectionMemento.this.m_Cells) {
                        jTable.changeSelection(point.y, point.x, true, false);
                    }
                }
            }
        });
    }

    public List<Point> getCellPoints() {
        return Collections.unmodifiableList(this.m_Cells);
    }

    public BitSet getSelection() {
        BitSet bitSet = new BitSet();
        for (Point point : this.m_Cells) {
            bitSet.set(point.x + point.y * this.m_ColCount);
        }
        return bitSet;
    }
}

