/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.ds;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.DataSourceDSL;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.ds.DSPanel;
import com.elixirtech.ensemble.ds.DSUtil;
import com.elixirtech.ensemble.ds.DSUtil2;
import com.elixirtech.ensemble.ds.DataTable;
import com.elixirtech.ensemble.ds.MutableDataSource;
import com.elixirtech.ensemble.ui.ThrobbingPushContext;
import com.elixirtech.ensemble.wizard.ParameterPanel;
import com.elixirtech.ui.ExceptionDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.v2.repository.FileObject;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class DSGenerateWizard
extends Wizard {
    FileObject m_FileObject;
    IDataSource m_DataSource;
    private MainPage m_MainPage;

    public DSGenerateWizard(FileObject fileObject) throws IOException {
        super(I18N.ENSEMBLE.getString("DSGenerateWizard.TITLE"));
        this.m_FileObject = fileObject;
        this.m_DataSource = DSUtil2.load(this.m_FileObject);
        this.buildPages();
    }

    public boolean needsWizard() {
        if (this.m_DataSource.getParameters().size() > 0) {
            return true;
        }
        return this.m_MainPage.m_DataStore.getModel().getSize() > 1;
    }

    public void generate() throws IOException {
        this.m_MainPage.generate();
    }

    @Override
    public boolean performFinish() {
        super.performFinish();
        this.m_MainPage.performFinish();
        return true;
    }

    protected void buildPages() {
        this.m_MainPage = new MainPage();
        this.m_MainPage.setWizard(this);
        this.m_Pages.add(this.m_MainPage);
    }

    private class MainPage
    extends RelativeLayoutWizardPage
    implements ItemListener {
        private JComboBox m_DataStore;
        private ParameterPanel m_Properties;

        public MainPage() {
            super("Generate", "Target");
            I18N.ENSEMBLE_MAP.injectObject(null, this, "DSGenerateWizard.MainPage");
        }

        @Override
        public void setWizard(IWizard iWizard) {
            super.setWizard(iWizard);
            this.m_DataStore = SwingFactory.newComboBox("datastore", DataTable.getDataStores(DSGenerateWizard.this.m_DataSource));
            this.m_DataStore.setRenderer(new ComboBoxRenderer());
            this.m_DataStore.addItemListener(this);
            this.m_Properties = new ParameterPanel(new DataSourceDSL(DSGenerateWizard.this.m_DataSource));
            this.m_Component.add(SwingFactory.newLabel("datastore-name"));
            this.m_Component.add(this.m_DataStore);
            JScrollPane jScrollPane = SwingFactory.newScrollPane("properties", this.m_Properties, 20, 31);
            this.m_Component.add(jScrollPane);
            this.stickLeft("datastore-name");
            this.vCenter("datastore-name", "datastore");
            this.stickTop("datastore");
            this.stickRight("datastore");
            this.putRight("datastore", "datastore-name", 10);
            this.putBelow("properties", "datastore", 10);
            this.stickLeft("properties");
            this.stickRight("properties");
            this.stickBottom("properties");
            I18N.ENSEMBLE_MAP.injectComponents("DSGenerateWizard.MainPage.", this.m_Component);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.buildProperties();
        }

        @Override
        public void setVisible(boolean bl) {
            if (bl) {
                this.buildProperties();
            }
        }

        public void performFinish() {
            try {
                this.generate();
            }
            catch (IOException iOException) {
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18N.ENSEMBLE.getString("DSGenerateWizard.GENERATION_ERROR"), (Throwable)iOException);
            }
        }

        @Override
        public boolean canFlipToNextPage() {
            return false;
        }

        @Override
        public boolean isPageComplete() {
            return true;
        }

        private void buildProperties() {
            DataStore dataStore = (DataStore)this.m_DataStore.getSelectedItem();
            if (dataStore.isResult()) {
                this.m_Properties.setParameters(DSGenerateWizard.this.m_DataSource.getParameters());
            } else {
                this.m_Properties.setParameters(dataStore.getParameters());
            }
            this.m_Properties.repaint();
        }

        public void generate() throws IOException {
            final DataStore dataStore = (DataStore)this.m_DataStore.getSelectedItem();
            final ThrobbingPushContext throbbingPushContext = new ThrobbingPushContext();
            this.m_Properties.populateContext(throbbingPushContext);
            boolean bl = true;
            if (dataStore.isResult()) {
                final IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
                iViewModel.openFile(DSGenerateWizard.this.m_FileObject, new Runnable(){

                    @Override
                    public void run() {
                        DSPanel dSPanel = (DSPanel)iViewModel.getView(DSGenerateWizard.this.m_FileObject);
                        if (dSPanel != null) {
                            DataTable dataTable = dSPanel.getDataTable();
                            dataTable.setCurrentDataStore(dataStore);
                            dataTable.load((PushContext)throbbingPushContext);
                            dataTable.updateDecorations();
                            dSPanel.setSelectedComponent(dataTable);
                        }
                    }
                });
            } else {
                CompositeDataSource compositeDataSource = (CompositeDataSource)MutableDataSource.unwrap(DSGenerateWizard.this.m_DataSource);
                try {
                    if (bl) {
                        DSUtil.generate((CompositeDataSource)compositeDataSource, (PushContext)throbbingPushContext, (DataStore)dataStore);
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.show(I18N.ENSEMBLE.getString("DSGenerateWizard.GENERATION_ERROR"), exception);
                }
            }
        }
    }

    static class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            String string = object.toString();
            this.setText(string);
            this.setFont(jList.getFont());
            this.setToolTipText(string);
            return this;
        }
    }
}

