/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.ds;

import com.elixirtech.arch.CompositeDirtyState;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.IDirtyState;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.ISecurity;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.MimeInfo2$;
import com.elixirtech.arch.MimeTypes$;
import com.elixirtech.arch.licence.LicenceUtil;
import com.elixirtech.data2.DataSourceDSL;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.CanvasPanel;
import com.elixirtech.ensemble.canvas.DataSourceGO;
import com.elixirtech.ensemble.canvas.DataStoreGO;
import com.elixirtech.ensemble.canvas.ICanvasPanel;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.canvas.ResultGO;
import com.elixirtech.ensemble.ds.CanvasHolder;
import com.elixirtech.ensemble.ds.DSUtil2;
import com.elixirtech.ensemble.ds.DataTable;
import com.elixirtech.ensemble.ds.MutableDataSource;
import com.elixirtech.ensemble.ds.MutableDataSource$;
import com.elixirtech.ensemble.ds.NameSetter$;
import com.elixirtech.ensemble.ds.ScriptPanel;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.ui.ElxTabbedPane;
import com.elixirtech.util.FileUtil;
import com.elixirtech.v2.repository.FileObject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public class DSPanel
implements IPanelView,
ChangeListener,
IDirtyState.Listener,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DSPanel.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DSPanel.class.getDeclaredField("licenceUtil$lzy1"));
    private volatile Object log$lzy1;
    private volatile Object licenceUtil$lzy1;
    private FileObject file;
    private final CompositeDirtyState dirtyState;
    private final MutableDataSource dataSource;
    private final ElxTabbedPane pane;
    private final DataTable dataTable;
    private final ListBuffer listeners;
    private Option scriptPanel;
    private final CanvasHolder m_CanvasHolder;

    public DSPanel(FileObject fo) {
        this.file = fo;
        this.dirtyState = new CompositeDirtyState();
        this.dirtyState().addDirtyListener(this);
        this.dataSource = MutableDataSource$.MODULE$.apply(DSUtil2.load(fo));
        this.dirtyState().add(this.dataSource());
        this.pane = new ElxTabbedPane();
        this.dataTable = new DataTable(this, this.dataSource());
        this.listeners = new ListBuffer();
        this.scriptPanel = None$.MODULE$;
        this.m_CanvasHolder = new CanvasHolder();
        this.buildTabs();
        this.dirtyState().setDirty(false);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private LicenceUtil licenceUtil() {
        Object object = this.licenceUtil$lzy1;
        if (object instanceof LicenceUtil) {
            return (LicenceUtil)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LicenceUtil)this.licenceUtil$lzyINIT1();
    }

    private Object licenceUtil$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.licenceUtil$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LicenceUtil licenceUtil = null;
                    try {
                        licenceUtil = new LicenceUtil();
                        object2 = licenceUtil == null ? LazyVals.NullValue$.MODULE$ : licenceUtil;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.licenceUtil$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return licenceUtil;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public FileObject file() {
        return this.file;
    }

    public void file_$eq(FileObject x$1) {
        this.file = x$1;
    }

    public CompositeDirtyState dirtyState() {
        return this.dirtyState;
    }

    public MutableDataSource dataSource() {
        return this.dataSource;
    }

    public ElxTabbedPane pane() {
        return this.pane;
    }

    public DataTable dataTable() {
        return this.dataTable;
    }

    public ListBuffer<PropertyChangeListener> listeners() {
        return this.listeners;
    }

    public Option<ScriptPanel> scriptPanel() {
        return this.scriptPanel;
    }

    public void scriptPanel_$eq(Option<ScriptPanel> x$1) {
        this.scriptPanel = x$1;
    }

    public CanvasHolder m_CanvasHolder() {
        return this.m_CanvasHolder;
    }

    public boolean isEditable() {
        return this.licenceUtil().isEditable("Ensemble");
    }

    public void buildTabs() {
        this.pane().removeAll();
        ISecurity sec = this.dataSource().getAdapter(ISecurity.class);
        IDataSource iDataSource = MutableDataSource$.MODULE$.unwrap(this.dataSource());
        if (iDataSource instanceof CompositeDataSource) {
            CompositeDataSource cds = (CompositeDataSource)iDataSource;
            if (!sec.isHideInternals() && this.isEditable()) {
                CanvasPanel cp = new CanvasPanel(cds);
                this.m_CanvasHolder().pushCanvas(cp);
                this.pane().addTab(I18N.ENSEMBLE.getString("DSPanel.Designer"), this.m_CanvasHolder());
                ScriptPanel tempSP = new ScriptPanel(cds);
                this.scriptPanel_$eq((Option<ScriptPanel>)Some$.MODULE$.apply((Object)tempSP));
                this.dirtyState().add(tempSP.getAdapter(IDirtyState.class));
                this.pane().addTab(I18N.ENSEMBLE.getString("DSPanel.Script"), tempSP.getComponent());
            }
        }
        this.pane().addTab(I18N.ENSEMBLE.getString("DSPanel.Data"), this.dataTable());
    }

    public void view(InOutGO go) {
        IDataSource src = this.getDataSource(go);
        if (src == null && go instanceof DataSourceGO) {
            src = ((DataSourceGO)go).getDataSource();
        }
        if (src != null) {
            this.dataTable().view(go, src, new DataSourceDSL(this.dataSource()));
            return;
        }
        ((IErrorHandler)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IErrorHandler.class))).error(I18NUtil.getString(I18N.ENSEMBLE, "DSPanel.CANT_LOCATE_DATASOURCE", go.getText()));
    }

    public void viewDataStore(DataStoreGO go) {
        CompositeDataSource csrc = (CompositeDataSource)MutableDataSource$.MODULE$.unwrap(this.dataSource());
        csrc.rebuildFromDiagram((InOutGO)go);
        this.scriptPanel().foreach((Function1)(JProcedure1 & Serializable)sp2 -> csrc.setJavaScript(sp2.getScript()));
        this.dataTable().viewDataStore(go);
    }

    public void viewResult(ResultGO go) {
        CompositeDataSource csrc = (CompositeDataSource)MutableDataSource$.MODULE$.unwrap(this.dataSource());
        csrc.rebuildFromDiagram((InOutGO)go);
        this.scriptPanel().foreach((Function1)(JProcedure1 & Serializable)sp2 -> csrc.setJavaScript(sp2.getScript()));
        this.dataTable().viewResult(go);
    }

    public IDataSource getDataSource(InOutGO go) {
        CompositeDataSource csrc = (CompositeDataSource)MutableDataSource$.MODULE$.unwrap(this.dataSource());
        csrc.rebuildFromDiagram(go);
        this.scriptPanel().foreach((Function1)(JProcedure1 & Serializable)sp2 -> csrc.setJavaScript(sp2.getScript()));
        return csrc.getDataSource(go);
    }

    public IDataSource getDataSource() {
        return this.dataSource();
    }

    @Override
    public JComponent getComponent() {
        return this.pane();
    }

    @Override
    public FileObject getFileObject() {
        return this.file();
    }

    public MutableDataSource getMutableDataSource() {
        return this.dataSource();
    }

    public DataTable getDataTable() {
        return this.dataTable();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners().$plus$eq((Object)pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners().$minus$eq((Object)pcl);
    }

    @Override
    public void dirtyStateChanged(IDirtyState s) {
        IViewModel model = (IViewModel)Elixir$.MODULE$.get(IViewModel.class);
        model.refreshView();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        IViewModel model = (IViewModel)Elixir$.MODULE$.get(IViewModel.class);
        model.refreshView();
    }

    public void setDirty(boolean b) {
        this.dirtyState().setDirty(b);
        this.dirtyStateChanged(this.dirtyState());
    }

    @Override
    public boolean canSave() {
        return this.dirtyState().isDirty();
    }

    @Override
    public boolean canSaveAs() {
        return true;
    }

    @Override
    public void save() {
        this.scriptPanel().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.setCurrent(false));
        this.file_$eq(DSUtil2.save(this.file(), this.dataSource().unwrapDataSource()));
        this.dirtyState().setDirty(false);
    }

    @Override
    public void saveAs(FileObject fo) {
        this.scriptPanel().foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.setCurrent(false));
        DSUtil2.close(this.file());
        this.file_$eq(fo);
        this.dataSource().wrapDataSource(NameSetter$.MODULE$.apply(this.dataSource(), FileUtil.getNameWithoutExtension(this.file().getName())));
        this.file_$eq(DSUtil2.save(this.file(), (IDataSource)this.dataSource()));
        this.dirtyState().setDirty(false);
    }

    public void setSelectedComponent(JComponent c) {
        this.pane().setSelectedComponent(c);
    }

    @Override
    public void setCurrent(boolean b) {
        this.pane().setCurrent(b);
    }

    public void generate(DataStoreGO go) {
        try {
            IDataSource iDataSource = MutableDataSource$.MODULE$.unwrap(this.dataSource());
            if (iDataSource instanceof CompositeDataSource) {
                CompositeDataSource csrc = (CompositeDataSource)iDataSource;
                this.scriptPanel().foreach((Function1)(JProcedure1 & Serializable)sp2 -> csrc.setJavaScript(sp2.getScript()));
                csrc.rebuildFromDiagram((InOutGO)go);
                this.dataTable().generate(go);
            }
        }
        catch (Exception ex) {
            ((IErrorHandler)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IErrorHandler.class))).error(I18N.ENSEMBLE.getString("DSPanel.ERROR_SAVING_DATASTORE"), (Throwable)ex);
        }
    }

    @Override
    public String getName() {
        return this.file().getPathString();
    }

    @Override
    public Icon getIcon() {
        return MimeInfo2$.MODULE$.local().icon(MimeTypes$.MODULE$.DS());
    }

    @Override
    public void dispose() {
        DSUtil2.close(this.file());
    }

    public void pushCanvas(ICanvasPanel cp) {
        this.m_CanvasHolder().pushCanvas(cp);
    }

    public void popCanvas() {
        this.m_CanvasHolder().popCanvas();
    }

    public void firePropertyChanged(String name, Object oldValue, Object newValue) {
        LazyRef lazyRef = new LazyRef();
        this.listeners().foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.propertyChange(this.ev$1(lazyRef, name, oldValue, newValue)));
    }

    private final PropertyChangeEvent ev$lzyINIT1$1(LazyRef ev$lzy1$1, String name$1, Object oldValue$1, Object newValue$1) {
        PropertyChangeEvent propertyChangeEvent;
        LazyRef lazyRef = ev$lzy1$1;
        synchronized (lazyRef) {
            propertyChangeEvent = (PropertyChangeEvent)(ev$lzy1$1.initialized() ? ev$lzy1$1.value() : ev$lzy1$1.initialize((Object)new PropertyChangeEvent(this, name$1, oldValue$1, newValue$1)));
        }
        return propertyChangeEvent;
    }

    private final PropertyChangeEvent ev$1(LazyRef ev$lzy1$2, String name$2, Object oldValue$2, Object newValue$2) {
        return (PropertyChangeEvent)(ev$lzy1$2.initialized() ? ev$lzy1$2.value() : this.ev$lzyINIT1$1(ev$lzy1$2, name$2, oldValue$2, newValue$2));
    }
}

