/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.ds;

import com.elixirtech.arch.ByteUtil;
import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.ICachedFile;
import com.elixirtech.arch.IDirtyState;
import com.elixirtech.arch.ISecurity;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.repository.RepositoryConverter;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.RawDataSource;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.data2.datasource.composite.CompositeScope;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.datasource.composite.DataStoreRegistry;
import com.elixirtech.data2.output.IDataStore;
import com.elixirtech.ds.DSBuilder;
import com.elixirtech.ensemble.ds.IDataAccess2;
import com.elixirtech.ensemble.ds.MutableDataSource;
import com.elixirtech.ensemble.ds.NameSetter;
import com.elixirtech.ensemble.ds.ParameterCacher;
import com.elixirtech.ensemble.ds.RecordCounter;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.jdom.output.Format;
import com.elixirtech.jdom.output.XMLOutputter;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.util.FileUtil;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.wizard.datasource.DataSourceWizard;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.mozilla.javascript.Scriptable;

public class DSUtil2 {
    private static final ThreadLocal<Set<String>> CURRENTLY_LOADING = new ThreadLocal();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DSUtil2.class);

    public static FileObject save(FileObject fileObject, IDataSource iDataSource) throws IOException {
        IDataSource iDataSource2 = MutableDataSource.unwrap(iDataSource);
        FileObject fileObject2 = DSUtil2.renameFOIfNecessary(fileObject, iDataSource2);
        ISecurity iSecurity = (ISecurity)iDataSource2.getAdapter(ISecurity.class);
        if (iSecurity != null && iSecurity.isEncrypted()) {
            DSUtil2.saveEncrypted(fileObject2, iDataSource2);
        } else {
            DSUtil2.saveUnencrypted(fileObject2, iDataSource2);
        }
        DSUtil2.setFileObject(iDataSource2, fileObject2);
        return fileObject2;
    }

    public static boolean isRemote() {
        return ((IDataAccess2)Elixir.get(IDataAccess2.class)).isRemote();
    }

    private static void saveUnencrypted(FileObject fileObject, IDataSource iDataSource) throws IOException {
        m_Log.info((Object)("save " + fileObject.getName()));
        try {
            OutputStream outputStream = fileObject.getOutputStream();
            Element element = DataSourceDefinition.save((IDataSource)iDataSource);
            DSUtil2.updateSecurityPath(element, "");
            XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
            xMLOutputter.output(new Document(element), outputStream);
            outputStream.close();
            IDirtyState iDirtyState = (IDirtyState)iDataSource.getAdapter(IDirtyState.class);
            iDirtyState.setDirty(false);
        }
        catch (IOException iOException) {
            m_Log.error((Object)("Can't save " + String.valueOf(fileObject.getPath()) + " : " + String.valueOf(iOException)), (Throwable)iOException);
            throw iOException;
        }
    }

    public static void updateSecurityPath(Element element, String string) {
        Element element2 = element.getChild("security", DataSourceDefinition.NS_DATASOURCE);
        if (element2 != null) {
            assert (string != null);
            String string2 = element2.getAttributeValue("encrypted");
            if ("Yes".equals(string2)) {
                String string3 = element2.getAttributeValue("name");
                if (StringUtil.isEmpty((String)string3)) {
                    element2.setAttribute("name", string);
                }
            } else {
                element2.setAttribute("name", "");
            }
        }
    }

    private static void saveEncrypted(FileObject fileObject, IDataSource iDataSource) throws IOException {
        m_Log.info((Object)("save encrypted " + fileObject.getName()));
        Element element = DataSourceDefinition.save((IDataSource)iDataSource);
        DSUtil2.updateSecurityPath(element, fileObject.getPathString());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        XMLOutputter xMLOutputter = new XMLOutputter();
        xMLOutputter.output(new Document(element), (OutputStream)gZIPOutputStream);
        gZIPOutputStream.close();
        Element element2 = new Element("encrypted-datasource", Data2Constants.NS_DATASOURCE);
        element2.setAttribute("version", "1");
        element2.setText(ByteUtil.encodeBase64((byte[])byteArrayOutputStream.toByteArray()));
        try {
            OutputStream outputStream = fileObject.getOutputStream();
            xMLOutputter.output(new Document(element2), outputStream);
            outputStream.close();
            IDirtyState iDirtyState = (IDirtyState)iDataSource.getAdapter(IDirtyState.class);
            iDirtyState.setDirty(false);
        }
        catch (IOException iOException) {
            m_Log.error((Object)("Can't save " + fileObject.getName() + " : " + String.valueOf(iOException)), (Throwable)iOException);
            throw iOException;
        }
    }

    private static FileObject renameFOIfNecessary(FileObject fileObject, IDataSource iDataSource) throws IOException {
        String string = FileUtil.getNameWithoutExtension(fileObject.getName());
        if (!string.equals(iDataSource.getName())) {
            m_Log.info((Object)("renaming " + fileObject.getName() + " to " + iDataSource.getName() + ".ds"));
            return fileObject.rename(iDataSource.getName() + ".ds");
        }
        return fileObject;
    }

    public static void save(OutputStream outputStream, IDataSource iDataSource) throws IOException {
        try {
            Element element = DataSourceDefinition.save((IDataSource)iDataSource);
            XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
            xMLOutputter.output(new Document(element), outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            m_Log.error((Object)("Can't save: " + String.valueOf(iOException)), (Throwable)iOException);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDataSource load(FileObject fileObject) throws IOException {
        String string = fileObject.getPathString();
        Set<String> set = CURRENTLY_LOADING.get();
        if (set == null) {
            set = new HashSet<String>();
            CURRENTLY_LOADING.set(set);
        } else if (set.contains(string)) {
            throw new IOException("Recursive load error in: " + string);
        }
        set.add(string);
        try {
            IDataSource iDataSource = DSUtil2.doLoad(fileObject);
            return iDataSource;
        }
        finally {
            set.remove(string);
        }
    }

    public static List<String> getDataStores(FileObject fileObject) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        IDataSource iDataSource = MutableDataSource.unwrap(DSUtil2.load(fileObject));
        if (iDataSource instanceof CompositeDataSource) {
            Collection collection = ((CompositeDataSource)iDataSource).getDataStores();
            for (DataStore dataStore : collection) {
                arrayList.add(dataStore.getName());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDatasourceType(FileObject fileObject) throws IOException {
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            InputStream inputStream = fileObject.getInputStream();
            Document document = null;
            try {
                document = sAXBuilder.build(inputStream);
            }
            finally {
                FileUtil.close(inputStream);
            }
            assert (document != null);
            document = DSUtil2.decryptIfNecessary(sAXBuilder, document);
            Element element = document.getRootElement();
            return element.getAttributeValue("type");
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't load " + String.valueOf(fileObject.getPath()) + " : " + String.valueOf(exception)), (Throwable)exception);
            throw new IOException("Unable to load " + String.valueOf(fileObject.getPath()) + " : " + String.valueOf(exception));
        }
    }

    public static List<Parameter> getParameters(FileObject fileObject) throws IOException {
        return DSUtil2.getParameters(fileObject, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Parameter> getParameters(FileObject fileObject, boolean bl) throws IOException {
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            InputStream inputStream = fileObject.getInputStream();
            Document document = null;
            try {
                document = sAXBuilder.build(inputStream);
            }
            finally {
                FileUtil.close(inputStream);
            }
            assert (document != null);
            Element element = (document = DSUtil2.decryptIfNecessary(sAXBuilder, document)).getRootElement();
            Element element2 = element.getChild("parameter-cache", Data2Constants.NS_DATASOURCE);
            if (element2 == null && fileObject.canWrite() && !bl) {
                try {
                    ParameterCacher.update(fileObject);
                    return DSUtil2.getParameters(fileObject, true);
                }
                catch (Exception exception) {
                    m_Log.error((Object)("Unable to cache parameters for " + String.valueOf(fileObject.getPath()) + ": " + String.valueOf(exception)));
                }
            }
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            if (element2 != null) {
                List list = element2.getChildren("parameter", Data2Constants.NS_DATASOURCE);
                for (Element element3 : list) {
                    arrayList.add(DSUtil2.buildParameter(element3));
                }
            } else {
                m_Log.warn((Object)("Unable to cache parameters for " + String.valueOf(fileObject.getPath())));
            }
            return arrayList;
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't load " + fileObject.getName() + " : " + String.valueOf(exception)), (Throwable)exception);
            throw new IOException("Unable to load " + fileObject.getName() + " : " + String.valueOf(exception));
        }
    }

    private static Parameter buildParameter(Element element) {
        String string = element.getAttributeValue("name");
        String string2 = element.getAttributeValue("type");
        String string3 = element.getAttributeValue("default-value");
        List list = element.getChildren("dependency", Data2Constants.NS_DATASOURCE);
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((Element)list.get(i)).getAttributeValue("on");
        }
        return new Parameter(string, string2, string3, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IDataSource doLoad(FileObject fileObject) throws IOException {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        m_Log.debug((Object)("Reading DataSource from file: " + fileObject.getName()));
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            InputStream inputStream = fileObject.getInputStream();
            Document document = null;
            try {
                document = sAXBuilder.build(inputStream);
            }
            finally {
                FileUtil.close(inputStream);
            }
            assert (document != null);
            IDataSource iDataSource = DataSourceDefinition.load((DataSourceManager)dataSourceManager, (Element)(document = DSUtil2.decryptIfNecessary(sAXBuilder, document)).getRootElement());
            if (iDataSource == null) {
                m_Log.error((Object)("Can't load " + fileObject.getName()));
                throw new IOException("Unable to load " + fileObject.getName());
            }
            iDataSource = DSUtil2.postprocessLoad(fileObject, iDataSource);
            if (DSUtil2.needsClone(iDataSource)) {
                iDataSource = DataSourceDefinition.clone((DataSourceManager)dataSourceManager, (IDataSource)iDataSource);
            }
            return iDataSource;
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't load " + fileObject.getName() + " : " + String.valueOf(exception)), (Throwable)exception);
            throw new IOException("Unable to load " + fileObject.getName() + " : " + String.valueOf(exception));
        }
    }

    private static IDataSource postprocessLoad(FileObject fileObject, IDataSource iDataSource) {
        String string = fileObject.getName();
        if (string.endsWith(".ds")) {
            string = string.substring(0, string.length() - 3);
        }
        IDataSource iDataSource2 = NameSetter.apply(iDataSource, string);
        DSUtil2.setFileObject(iDataSource2, fileObject);
        if (!fileObject.canWrite()) {
            DSBuilder dSBuilder = DataSourceWizard.getBuilderForDS(iDataSource2);
            dSBuilder.setReadOnly(true);
            iDataSource2 = dSBuilder.build();
        }
        return iDataSource2;
    }

    private static boolean needsClone(IDataSource iDataSource) {
        return !(iDataSource instanceof RawDataSource);
    }

    private static Document decryptIfNecessary(SAXBuilder sAXBuilder, Document document) throws IOException, JDOMException {
        Element element = document.getRootElement();
        if (element.getName().equals("encrypted-datasource") && element.getNamespace().equals((Object)Data2Constants.NS_DATASOURCE)) {
            m_Log.info((Object)"loading encrypted datasource");
            String string = element.getAttributeValue("version");
            if (!"1".equals(string)) {
                throw new IOException("Incorrect encryption version: " + string);
            }
            String string2 = element.getText();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ByteUtil.decodeBase64((String)string2));
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            Document document2 = sAXBuilder.build((InputStream)gZIPInputStream);
            gZIPInputStream.close();
            return document2;
        }
        return document;
    }

    public static IDataSource load(InputStream inputStream) throws IOException {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            Document document = sAXBuilder.build(inputStream);
            document = DSUtil2.decryptIfNecessary(sAXBuilder, document);
            IDataSource iDataSource = DataSourceDefinition.load((DataSourceManager)dataSourceManager, (Element)document.getRootElement());
            return iDataSource;
        }
        catch (JDOMException jDOMException) {
            m_Log.error((Object)("Can't load from input stream: " + String.valueOf((Object)jDOMException)), (Throwable)jDOMException);
            throw new IOException("Unable to load from input stream: " + String.valueOf((Object)jDOMException));
        }
    }

    public static void setFileObject(IDataSource iDataSource, FileObject fileObject) {
        ICachedFile iCachedFile = (ICachedFile)iDataSource.getAdapter(ICachedFile.class);
        if (iCachedFile != null) {
            iCachedFile.setFileObject(RepositoryConverter.toFO(fileObject));
        }
    }

    public static FileObject getFileObject(IDataSource iDataSource) {
        ICachedFile iCachedFile = (ICachedFile)iDataSource.getAdapter(ICachedFile.class);
        if (iCachedFile != null) {
            RMLFileObject rMLFileObject = iCachedFile.getFileObject();
            if (rMLFileObject != null) {
                return RepositoryConverter.toFO(rMLFileObject);
            }
            return null;
        }
        return null;
    }

    public static void close(FileObject fileObject) {
    }

    public static int generate(CompositeDataSource compositeDataSource, PushContext pushContext, DataStore dataStore) throws DataException {
        IDataStore iDataStore;
        DataListener2 dataListener2 = DataStoreRegistry.getDataListener((PushContext)pushContext, (DataStore)dataStore);
        if (dataListener2 instanceof IDataStore) {
            iDataStore = (IDataStore)dataListener2;
            iDataStore.setContext(pushContext);
            iDataStore.setName(dataStore.getName());
        }
        if (dataListener2 != null) {
            iDataStore = new RecordCounter(dataListener2);
            JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
            javaScriptEngine.pushScope((Scriptable)new CompositeScope(compositeDataSource));
            compositeDataSource.initScript(pushContext);
            dataStore.getDataSource().pushTo(pushContext, (DataListener)iDataStore);
            javaScriptEngine.popScope();
            return iDataStore.getCount();
        }
        return -1;
    }

    public static Map<String, Object> buildMap(PushContext pushContext, String string, DataStore dataStore) {
        String string2 = "Custom Java DataStore".equals(string) ? dataStore.getProperty("Java_ClassName") : string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string3 = DataStoreRegistry.getPrefix((String)string2);
        if (StringUtil.notEmpty((String)string3)) {
            Map map = dataStore.getProperties();
            for (Object object : map.keySet()) {
                if (!((String)object).startsWith(string3) || ((String)object).equals("Java_ClassName")) continue;
                Object v = map.get(object);
                if (((String)(object = ((String)object).substring(string3.length()))).length() <= 0) continue;
                boolean bl = true;
                if (((String)object).length() > 1) {
                    boolean bl2 = bl = !Character.isUpperCase(((String)object).charAt(1));
                }
                if (bl) {
                    object = Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
                }
                hashMap.put((String)object, v);
            }
        }
        if (!hashMap.containsKey("name")) {
            hashMap.put("name", dataStore.getName());
        }
        return hashMap;
    }

    public static IDataSource clone(IDataSource iDataSource) {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        Element element = DataSourceDefinition.save((IDataSource)iDataSource);
        return DataSourceDefinition.load((DataSourceManager)dataSourceManager, (Element)element);
    }
}

