/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.ds;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.data2.AbstractDataSource;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DSLookup;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceDSL;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.NullDataListener;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.ParameterUtil;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.data2.datasource.composite.CompositeScope;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.datasource.composite.Result;
import com.elixirtech.data2.output.CSVDataStore;
import com.elixirtech.data2.output.XMLDataStore;
import com.elixirtech.data2.output.XlsxDataStore2;
import com.elixirtech.ensemble.EnsembleAction;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.DataStoreGO;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.canvas.ResultGO;
import com.elixirtech.ensemble.ds.DLThrobber;
import com.elixirtech.ensemble.ds.DSBuilder;
import com.elixirtech.ensemble.ds.DSPanel;
import com.elixirtech.ensemble.ds.DataTableModel;
import com.elixirtech.ensemble.ds.DataTableMouseListener;
import com.elixirtech.ensemble.ds.GenerateDataWorker;
import com.elixirtech.ensemble.ds.IDataAccess2;
import com.elixirtech.ensemble.ds.MutableDataSource;
import com.elixirtech.ensemble.ds.RowHeader;
import com.elixirtech.ensemble.ui.ThrobbingPushContext;
import com.elixirtech.ensemble.util.TablePrinter;
import com.elixirtech.ensemble.wizard.ParameterUI;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.i18n.I18NUtilJ;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.ui.ClipboardUtil;
import com.elixirtech.ui.CurrentTab;
import com.elixirtech.ui.FileSaveDialog;
import com.elixirtech.ui.LCellRenderer;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingWorker;
import com.elixirtech.ui.TableUtil;
import com.elixirtech.util.FileUtil;
import com.elixirtech.v2.repository.FileObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mozilla.javascript.Scriptable;

public class DataTable
extends JPanel
implements CurrentTab,
ListSelectionListener,
ItemListener {
    private static final String[] EXTENSIONS = new String[]{".xml", ".xlsx", ".csv", ".ds"};
    private static final String[] NAMES = new String[]{"DataTable.XMLData", "DataTable.XlsxData", "DataTable.CommaSeparatedData", "DataTable.DataSource"};
    private static final String[] NAMES_UI = I18NUtil.getStrings(I18N.ENSEMBLE, NAMES);
    DSPanel m_DSPanel;
    MutableDataSource m_MutableDataSource;
    DataTableModel m_TableModel;
    JTable m_Table;
    JCheckBox m_CountAllRecords = new JCheckBox(I18N.ENSEMBLE.getString("DataTable.CountAllRecords"));
    JComboBox m_DataStores;
    private JToolBar m_ToolBar;
    private JLabel m_Label;
    private LoadAction m_Load = new LoadAction();
    private GenerateAction m_Generate = new GenerateAction();
    private AbstractAction m_SaveAs = new SaveAsAction();
    private AbstractAction m_Print = new PrintAction();
    private AbstractAction m_Copy = new CopyAction();
    private RowHeader m_RowHeader;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DataTable.class);

    public DataTable(DSPanel dSPanel, MutableDataSource mutableDataSource) {
        this.m_DSPanel = dSPanel;
        this.m_MutableDataSource = mutableDataSource;
        this.setLayout(new BorderLayout());
        this.m_DataStores = new JComboBox(DataTable.getDataStores(this.getDataSource()));
        this.m_DataStores.setName("DataStore");
        this.m_DataStores.setRenderer(new LCellRenderer());
        this.m_DataStores.addItemListener(this);
        this.buildToolbar();
        this.m_TableModel = new DataTableModel();
        this.m_TableModel.setShowColumnTypes(true);
        this.m_Table = SwingFactory.newTable();
        this.m_Table.setModel(this.m_TableModel);
        this.m_Table.setAutoResizeMode(0);
        this.m_Table.getSelectionModel().addListSelectionListener(this);
        this.m_Table.addMouseListener(new DataTableMouseListener(this));
        JScrollPane jScrollPane = new JScrollPane(this.m_Table);
        this.m_RowHeader = new RowHeader(this.m_Table, this.m_TableModel);
        jScrollPane.setRowHeaderView(this.m_RowHeader);
        this.add((Component)jScrollPane, "Center");
        this.checkEnabled();
    }

    public IDataSource getDataSource() {
        return MutableDataSource.unwrap(this.m_MutableDataSource);
    }

    private void buildToolbar() {
        this.m_ToolBar = SwingFactory.newToolBar();
        this.m_ToolBar.add(this.m_DataStores);
        this.m_ToolBar.add(this.m_Load);
        this.m_ToolBar.add(this.m_Generate);
        this.m_ToolBar.add(this.m_SaveAs);
        this.m_ToolBar.add(this.m_Print);
        this.m_ToolBar.add(this.m_Copy);
        this.m_Label = new JLabel();
        this.m_Label.setFont(UIManager.getFont("Tree.font"));
        this.m_ToolBar.add(this.m_Label);
        this.m_CountAllRecords.setOpaque(false);
        this.m_ToolBar.add(this.m_CountAllRecords);
        this.m_ToolBar.add(Box.createHorizontalGlue());
        this.add((Component)this.m_ToolBar, "North");
    }

    public JTable getSwingTable() {
        return this.m_Table;
    }

    @Override
    public void setCurrent(boolean bl) {
        if (bl) {
            DataStore dataStore = (DataStore)this.m_DataStores.getSelectedItem();
            this.m_DataStores.setModel(DataTable.getDataStores(this.getDataSource()));
            this.m_DataStores.setSelectedItem(dataStore);
        }
    }

    public FileObject getFileObject() {
        return this.m_DSPanel.getFileObject();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.m_Copy.setEnabled(this.m_Table.getSelectedRowCount() > 0);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.checkEnabled();
    }

    private void checkEnabled() {
        DataStore dataStore = (DataStore)this.m_DataStores.getSelectedItem();
        this.m_Load.setEnabled(dataStore != null);
        this.m_Generate.setEnabled(dataStore != null && !dataStore.isResult());
        int n = this.m_TableModel.getRowCount();
        this.m_SaveAs.setEnabled(dataStore != null && n > 0);
        this.m_Print.setEnabled(n > 0);
    }

    public void load(PushContext pushContext) {
        this.m_Load.load(pushContext);
    }

    public void generate(DataStoreGO dataStoreGO) throws DataException {
        new GenerateDataWorker((CompositeDataSource)this.getDataSource(), dataStoreGO);
    }

    public void view(InOutGO inOutGO, IDataSource iDataSource, DSLookup dSLookup) {
        this.setCurrentDataStore(null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (DataTable.getParams(inOutGO, hashMap, dSLookup)) {
            GenerateWorker generateWorker = new GenerateWorker(iDataSource, hashMap);
            generateWorker.start();
        }
    }

    public void run(InOutGO inOutGO, IDataSource iDataSource) {
        this.setCurrentDataStore(null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (DataTable.getParams(inOutGO, hashMap, (DSLookup)new DataSourceDSL(this.getDataSource()))) {
            boolean bl = this.m_CountAllRecords.isSelected();
            this.m_TableModel.setCountAll(bl);
            try {
                ThrobbingPushContext throbbingPushContext = ThrobbingPushContext.getPushContext(hashMap);
                ((CompositeDataSource)this.getDataSource()).initScript((PushContext)throbbingPushContext);
                iDataSource.pushTo((PushContext)throbbingPushContext, (DataListener)new NullDataListener());
            }
            catch (RuntimeException runtimeException) {
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(Bundle.ARCH.getString("Error"), (Throwable)runtimeException);
            }
        }
    }

    public void viewDataStore(DataStoreGO dataStoreGO) {
        CompositeDataSource compositeDataSource = (CompositeDataSource)this.getDataSource();
        DataStore dataStore = compositeDataSource.getDataStore(dataStoreGO);
        if (dataStore != null) {
            this.view((InOutGO)dataStoreGO, dataStore.getDataSource(), new DataSourceDSL((IDataSource)compositeDataSource));
            this.setCurrentDataStore(dataStore);
        } else {
            ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18NUtilJ.getString(I18N.ENSEMBLE, "DataTable.CANT_LOCATE_DATASTORE", dataStoreGO.getText()));
        }
    }

    public void viewResult(ResultGO resultGO) {
        CompositeDataSource compositeDataSource = (CompositeDataSource)this.getDataSource();
        this.view((InOutGO)resultGO, (IDataSource)compositeDataSource, new DataSourceDSL((IDataSource)compositeDataSource));
        this.setCurrentDataStore(compositeDataSource.getResult());
    }

    public void setCurrentDataStore(DataStore dataStore) {
        this.m_DataStores.setSelectedItem(dataStore);
        this.checkEnabled();
    }

    public static ComboBoxModel getDataStores(IDataSource iDataSource) {
        Object object;
        IDataSource iDataSource2 = MutableDataSource.unwrap(iDataSource);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        m_Log.info((Object)"building data stores");
        m_Log.info((Object)("ds is type " + iDataSource2.getType()));
        if (iDataSource2.getType() == "Composite") {
            m_Log.info((Object)"Is composite ds");
            object = (CompositeDataSource)MutableDataSource.unwrap(iDataSource2);
            DSBuilder dSBuilder = new DSBuilder((CompositeDataSource)object);
            dSBuilder.buildResult();
            arrayList.addAll(object.getDataStores());
            Collections.sort(arrayList);
            arrayList.add(0, object.getResult());
        } else {
            object = new Result(iDataSource2);
            arrayList.add(object);
        }
        object = new DefaultComboBoxModel();
        for (DataStore dataStore : arrayList) {
            ((DefaultComboBoxModel)object).addElement(dataStore);
        }
        return object;
    }

    public DataTableModel getModel() {
        return this.m_TableModel;
    }

    public boolean isCountAllRecords() {
        return this.m_CountAllRecords.isSelected();
    }

    public void updateDecorations() {
        this.checkEnabled();
        TableUtil.setBestColumnWidths(this.m_Table, 5, 500);
        if (this.m_CountAllRecords.isSelected()) {
            String string = I18N.ENSEMBLE.getString("DataTable.ShowingXOfY");
            Object[] objectArray = new Object[]{String.valueOf(this.m_TableModel.getRowCount()), String.valueOf(this.m_TableModel.getTotalRowCount())};
            string = MessageFormat.format(string, objectArray);
            this.m_Label.setText(string);
        } else {
            String string = I18N.ENSEMBLE.getString("DataTable.ShowingX");
            Object[] objectArray = new Object[]{String.valueOf(this.m_TableModel.getRowCount())};
            string = MessageFormat.format(string, objectArray);
            this.m_Label.setText(string);
        }
        this.m_RowHeader.invalidate();
        this.m_RowHeader.validate();
        this.m_RowHeader.repaint();
    }

    public static void printTable(JTable jTable) {
        TablePrinter tablePrinter = new TablePrinter(jTable);
        DataTable.print(tablePrinter);
    }

    public static void print(Printable printable) {
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        HashDocAttributeSet hashDocAttributeSet = new HashDocAttributeSet();
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        SimpleDoc simpleDoc = new SimpleDoc(printable, sERVICE_FORMATTED, hashDocAttributeSet);
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(sERVICE_FORMATTED, hashDocAttributeSet);
        PrintService printService2 = ServiceUI.printDialog(null, 100, 100, printServiceArray, printService, sERVICE_FORMATTED, hashPrintRequestAttributeSet);
        if (printService2 != null) {
            try {
                DocPrintJob docPrintJob = printService2.createPrintJob();
                docPrintJob.print(simpleDoc, hashPrintRequestAttributeSet);
            }
            catch (PrintException printException) {
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(Bundle.ARCH.getString("Error"), (Throwable)printException);
            }
        }
    }

    public static void saveAs(IDataSource iDataSource) {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        DataTable.saveAs(iDataSource, elixirFrame.getFrame());
    }

    public static void saveAs(final IDataSource iDataSource, JFrame jFrame) {
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!DataTable.getParams(iDataSource.getParameters(), hashMap, (DSLookup)new DataSourceDSL(iDataSource))) {
            return;
        }
        FileSaveDialog fileSaveDialog = DataTable.getFileSaveDialog();
        if (fileSaveDialog.showSaveDialog(jFrame) == 0) {
            final File file = fileSaveDialog.getSelectedFile();
            final String string = fileSaveDialog.getFileFilter().getDescription();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    DataTable.doSave(iDataSource, hashMap, file, string);
                }
            };
            thread.start();
        }
    }

    public static FileSaveDialog getFileSaveDialog() {
        FileSaveDialog fileSaveDialog = new FileSaveDialog();
        fileSaveDialog.setDialogTitle(I18N.ENSEMBLE.getString("DataTable.SaveData"));
        fileSaveDialog.removeChoosableFileFilter(fileSaveDialog.getAcceptAllFileFilter());
        for (int i = 0; i < EXTENSIONS.length; ++i) {
            fileSaveDialog.addFilter(EXTENSIONS[i], NAMES_UI[i]);
        }
        fileSaveDialog.setFileFilter(fileSaveDialog.getChoosableFileFilters()[0]);
        return fileSaveDialog;
    }

    private static void doSave(IDataSource iDataSource, Map<String, String> map, File file, String string) {
        try {
            File file2 = null;
            if (string.equals(NAMES_UI[0])) {
                file2 = DataTable.writeXML(iDataSource, map, file);
            } else if (string.equals(NAMES_UI[1])) {
                file2 = DataTable.writeXlsx(iDataSource, map, file);
            } else if (string.equals(NAMES_UI[2])) {
                file2 = DataTable.writeCSV(iDataSource, map, file);
            } else if (string.equals(NAMES_UI[3])) {
                file2 = DataTable.writeDataSource(iDataSource, map, file);
            }
            m_Log.info((Object)("Data written to " + String.valueOf(file2)));
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error saving data: " + String.valueOf(exception)), (Throwable)exception);
        }
    }

    private static File writeXML(IDataSource iDataSource, Map<String, String> map, File file) throws DataException, UnsupportedEncodingException, FileNotFoundException, IOException {
        ThrobbingPushContext throbbingPushContext = ThrobbingPushContext.getPushContext(map);
        File file2 = DataTable.ensureExtension(file, "xml");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8");
        XMLDataStore xMLDataStore = new XMLDataStore((Writer)outputStreamWriter);
        xMLDataStore.setContext((PushContext)throbbingPushContext);
        iDataSource.pushTo((PushContext)throbbingPushContext, (DataListener)new DLThrobber(throbbingPushContext, (DataListener)xMLDataStore));
        ((Writer)outputStreamWriter).close();
        return file2;
    }

    private static File writeXlsx(IDataSource iDataSource, Map<String, String> map, File file) throws DataException, FileNotFoundException, IOException {
        ThrobbingPushContext throbbingPushContext = ThrobbingPushContext.getPushContext(map);
        File file2 = DataTable.ensureExtension(file, "xlsx");
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        XlsxDataStore2 xlsxDataStore2 = new XlsxDataStore2();
        xlsxDataStore2.setOutputStream((OutputStream)fileOutputStream);
        xlsxDataStore2.setContext((PushContext)throbbingPushContext);
        xlsxDataStore2.setFirstRowHeader(true);
        iDataSource.pushTo((PushContext)throbbingPushContext, (DataListener)new DLThrobber(throbbingPushContext, (DataListener)xlsxDataStore2));
        fileOutputStream.close();
        return file2;
    }

    private static File writeCSV(IDataSource iDataSource, Map<String, String> map, File file) throws DataException, IOException {
        ThrobbingPushContext throbbingPushContext = ThrobbingPushContext.getPushContext(map);
        File file2 = DataTable.ensureExtension(file, "csv");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8");
        CSVDataStore cSVDataStore = new CSVDataStore((Writer)outputStreamWriter);
        cSVDataStore.setContext((PushContext)throbbingPushContext);
        iDataSource.pushTo((PushContext)throbbingPushContext, (DataListener)new DLThrobber(throbbingPushContext, (DataListener)cSVDataStore));
        ((Writer)outputStreamWriter).close();
        return file2;
    }

    private static File writeDataSource(IDataSource iDataSource, Map<String, String> map, File file) throws DataException, UnsupportedEncodingException, FileNotFoundException, IOException {
        ThrobbingPushContext throbbingPushContext = ThrobbingPushContext.getPushContext(map);
        File file2 = DataTable.ensureExtension(file, "ds");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8");
        XMLDataStore xMLDataStore = new XMLDataStore((Writer)outputStreamWriter);
        xMLDataStore.setContext((PushContext)throbbingPushContext);
        iDataSource.pushTo((PushContext)throbbingPushContext, (DataListener)new DLThrobber(throbbingPushContext, (DataListener)xMLDataStore));
        ((Writer)outputStreamWriter).close();
        return file2;
    }

    private static File ensureExtension(File file, String string) {
        String string2 = file.getAbsolutePath();
        if (!string2.endsWith("." + string)) {
            string2 = FileUtil.setExtension(string2, string);
            return new File(string2);
        }
        return file;
    }

    public static boolean getParams(InOutGO inOutGO, Map<String, String> map, DSLookup dSLookup) {
        ArgumentMap argumentMap = new ArgumentMap();
        inOutGO.buildParameters(argumentMap);
        List list = argumentMap.getParameters();
        return DataTable.getParams(list, map, dSLookup);
    }

    public static boolean getParams(List<Parameter> list, Map<String, String> map, DSLookup dSLookup) {
        if (ParameterUtil.getParamCount(list) > 0) {
            ParameterUI parameterUI = new ParameterUI(list, dSLookup);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(parameterUI);
            if (!parameterUI.isFinished()) {
                return false;
            }
            parameterUI.populateProperties(map);
        }
        return true;
    }

    private class LoadAction
    extends EnsembleAction {
        public LoadAction() {
            super("DataSource.Data.Load");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IDataAccess2 iDataAccess2 = (IDataAccess2)Elixir.get(IDataAccess2.class);
            String string = DataTable.this.m_DSPanel.getFileObject().getPathString();
            DataStore dataStore = (DataStore)DataTable.this.m_DataStores.getSelectedItem();
            iDataAccess2.loadData(DataTable.this, string, DataTable.this.getDataSource(), dataStore, null);
        }

        public void load(PushContext pushContext) {
            IDataAccess2 iDataAccess2 = (IDataAccess2)Elixir.get(IDataAccess2.class);
            String string = DataTable.this.m_DSPanel.getFileObject().getPathString();
            Result result = new Result(DataTable.this.getDataSource());
            iDataAccess2.loadData(DataTable.this, string, DataTable.this.getDataSource(), (DataStore)result, pushContext);
        }
    }

    private class GenerateAction
    extends EnsembleAction {
        public GenerateAction() {
            super("DataSource.Data.Generate");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataStore dataStore = (DataStore)DataTable.this.m_DataStores.getSelectedItem();
            new GenerateDataWorker((CompositeDataSource)DataTable.this.getDataSource(), dataStore);
        }
    }

    private class SaveAsAction
    extends EnsembleAction {
        public SaveAsAction() {
            super("DataSource.Data.SaveAs");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataStore dataStore = (DataStore)DataTable.this.m_DataStores.getSelectedItem();
            DataTable.saveAs(DataTable.this.m_TableModel.getDataSource());
        }
    }

    private class PrintAction
    extends EnsembleAction {
        public PrintAction() {
            super("DataSource.Data.Print");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataTable.printTable(DataTable.this.m_Table);
        }
    }

    private class CopyAction
    extends EnsembleAction {
        public CopyAction() {
            super("DataSource.Data.Copy");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int[] nArray = DataTable.this.m_Table.getSelectedRows();
                MyDataSource myDataSource = new MyDataSource(nArray);
                ThrobbingPushContext throbbingPushContext = ThrobbingPushContext.getPushContext(null);
                StringWriter stringWriter = new StringWriter();
                XMLDataStore xMLDataStore = new XMLDataStore((Writer)stringWriter);
                xMLDataStore.setContext((PushContext)throbbingPushContext);
                myDataSource.pushTo((PushContext)throbbingPushContext, (DataListener)xMLDataStore);
                stringWriter.close();
                ClipboardUtil.setText(stringWriter.toString());
            }
            catch (Exception exception) {
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18N.ENSEMBLE.getString("DataTable.COPY_FAILED"), (Throwable)exception);
            }
        }
    }

    private class GenerateWorker
    extends SwingWorker {
        private final IDataSource m_Src;
        private final Map<String, String> m_Values;

        public GenerateWorker(IDataSource iDataSource, Map<String, String> map) {
            this.m_Src = iDataSource;
            this.m_Values = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object construct() {
            boolean bl = DataTable.this.m_CountAllRecords.isSelected();
            IDataSource iDataSource = DataTable.this.getDataSource();
            DataTable.this.m_TableModel.setCountAll(bl);
            JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
            javaScriptEngine.pushScope((Scriptable)new CompositeScope((CompositeDataSource)iDataSource));
            try {
                ThrobbingPushContext throbbingPushContext = ThrobbingPushContext.getPushContext(this.m_Values);
                throbbingPushContext.setParameter("elx.max-rows", "500");
                if (this.m_Src != DataTable.this.getDataSource()) {
                    ((CompositeDataSource)iDataSource).initScript((PushContext)throbbingPushContext);
                }
                DataTable.this.m_TableModel.setUIName(this.m_Src.getName());
                DataTable.this.m_TableModel.setPushContext((PushContext)throbbingPushContext);
                this.m_Src.pushTo((PushContext)throbbingPushContext, (DataListener)DataTable.this.m_TableModel);
                Boolean bl2 = Boolean.TRUE;
                return bl2;
            }
            catch (Throwable throwable) {
                String string = throwable.getMessage();
                if (string == null) {
                    string = "Can't load data";
                }
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(string, throwable);
                Boolean bl3 = Boolean.FALSE;
                return bl3;
            }
            finally {
                javaScriptEngine.popScope();
            }
        }

        @Override
        public void finished() {
            super.finished();
            if (this.getValue() == Boolean.TRUE) {
                DataTable.this.m_TableModel.fireTableStructureChanged();
                DataTable.this.updateDecorations();
                DataTable.this.m_DSPanel.setSelectedComponent(DataTable.this);
            }
        }

        @Override
        public void interrupt() {
            super.interrupt();
            DataTable.this.m_TableModel.fireTableStructureChanged();
            DataTable.this.updateDecorations();
        }
    }

    private class MyDataSource
    extends AbstractDataSource {
        private int[] m_Rows;

        public MyDataSource(int[] nArray) {
            this.m_Rows = nArray;
        }

        public String getName() {
            return "Clipboard Data";
        }

        public String getDescription() {
            return null;
        }

        public String getType() {
            return "Data";
        }

        public DataSchema getSchema() {
            return DataTable.this.getDataSource().getSchema();
        }

        public void pushTo(PushContext pushContext, DataListener dataListener) {
            DataRecord dataRecord;
            dataListener.startData((IDataSource)this);
            for (int i = 0; i < this.m_Rows.length && dataListener.processRecord(dataRecord = DataTable.this.m_TableModel.getRecord(this.m_Rows[i])); ++i) {
            }
            dataListener.endData((IDataSource)this);
        }
    }
}

