/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.ds;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IAdaptable;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IThrobber;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.GroupNode;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.attributes.Format;
import com.elixirtech.data2.datasource.NamedDataSource;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.ui.SwingUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class DataTableModel
extends AbstractTableModel
implements DataListener2 {
    private PushContext m_Context;
    private IThrobber m_Throbber;
    private List<DataRecord> m_Rows = new ArrayList<DataRecord>();
    private String m_Name;
    private DataSchema m_Schema;
    private int m_TotalRowCount;
    private boolean m_CountAll;
    private boolean m_ShowColumnTypes;
    private GroupNode m_Root;
    private GroupNode m_Current;
    private boolean m_SchemaChanged;
    private int m_Limit = 500;
    private boolean m_Editable;
    private boolean m_ErrorReported;
    private Set<String> m_HideColumns = new HashSet<String>();
    private int[] m_ColumnIndices;
    private String m_UIName = "UI";
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DataTableModel.class);

    public DataTableModel() {
        this.m_Throbber = (IThrobber)Elixir.get(IThrobber.class);
    }

    public void setThrobber(IThrobber iThrobber) {
        this.m_Throbber = iThrobber;
    }

    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IAdaptable.class) {
            return clazz.cast(this);
        }
        if (clazz == IDataSource.class) {
            return clazz.cast(new NamedDataSource(this.m_UIName, null));
        }
        return null;
    }

    public void clear() {
        this.m_Schema = null;
        this.m_Rows.clear();
        this.fireTableStructureChanged();
    }

    public void setUIName(String string) {
        this.m_UIName = string;
    }

    public void setPushContext(PushContext pushContext) {
        this.m_Context = pushContext;
    }

    public void setLimit(int n) {
        this.m_Limit = n;
    }

    public int getLimit() {
        return this.m_Limit;
    }

    public void setHideColumns(Set<String> set) {
        if (!set.equals(this.m_HideColumns)) {
            this.m_HideColumns = set;
            this.m_SchemaChanged = true;
        }
    }

    public Set<String> getHideColumns() {
        return this.m_HideColumns;
    }

    public void setEditable(boolean bl) {
        this.m_Editable = bl;
    }

    public boolean isEditable() {
        return this.m_Editable;
    }

    public void clearErrorReported() {
        this.m_ErrorReported = false;
    }

    public boolean isErrorReported() {
        return this.m_ErrorReported;
    }

    public IDataSource getDataSource() {
        DataRecord[] dataRecordArray = new DataRecord[this.m_Rows.size()];
        this.m_Rows.toArray(dataRecordArray);
        return new DataTable(this.m_Name, this.m_Schema, dataRecordArray);
    }

    public void setCountAll(boolean bl) {
        this.m_CountAll = bl;
    }

    @Override
    public int getColumnCount() {
        if (this.m_Schema == null) {
            return 0;
        }
        return this.m_ColumnIndices.length;
    }

    @Override
    public String getColumnName(int n) {
        if (this.m_Schema == null) {
            return "";
        }
        if (n >= this.m_ColumnIndices.length) {
            return null;
        }
        int n2 = this.m_ColumnIndices[n];
        if (this.m_ShowColumnTypes) {
            return "<html><center>" + this.m_Schema.getColumnName(n2) + "<br>(" + this.m_Schema.getColumnType(n2).getTypeName() + ")</center></html>";
        }
        return this.m_Schema.getColumnName(n2);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    public boolean isShowColumnTypes() {
        return this.m_ShowColumnTypes;
    }

    public void setShowColumnTypes(boolean bl) {
        this.m_ShowColumnTypes = bl;
    }

    @Override
    public int getRowCount() {
        return this.m_Rows.size();
    }

    public void setTotalRowCount(int n) {
        this.m_TotalRowCount = n;
    }

    public int getTotalRowCount() {
        return this.m_TotalRowCount;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n >= this.m_Rows.size()) {
            return null;
        }
        DataRecord dataRecord = this.m_Rows.get(n);
        if (n2 >= this.m_ColumnIndices.length) {
            return null;
        }
        int n3 = this.m_ColumnIndices[n2];
        Object[] objectArray = dataRecord.getData();
        if (n3 >= objectArray.length) {
            m_Log.warn((Object)("No data for columnIdx=" + n2 + ", actualIdx=" + n3));
            return null;
        }
        try {
            return this.format(objectArray, n3);
        }
        catch (Throwable throwable) {
            m_Log.error((Object)("Error formatting data for column " + n3 + ": " + String.valueOf(throwable)), throwable);
            return "!";
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.m_Editable;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.m_Editable) {
            int n3 = this.m_ColumnIndices[n2];
            DataRecord dataRecord = this.m_Rows.get(n);
            DataType dataType = this.m_Schema.getColumnType(n3);
            try {
                Object object2 = object instanceof String ? this.m_Schema.parse(dataType, (String)object) : object;
                dataRecord.setData(n3, object2);
            }
            catch (Exception exception) {
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18NUtil.getString(I18N.ENSEMBLE, "DataTableModel.INVALID_VALUE", object, dataType.getTypeName()));
                this.m_ErrorReported = true;
            }
        }
    }

    public DataRecord getRecord(int n) {
        return this.m_Rows.get(n);
    }

    public int indexOf(DataRecord dataRecord) {
        return this.m_Rows.indexOf(dataRecord);
    }

    public void startData(IDataSource iDataSource) {
        int n;
        assert (this.m_Context != null) : "DataTableModel needs setPushContext called before pushTo is invoked";
        this.m_Rows.clear();
        this.m_Name = iDataSource.getName();
        DataSchema dataSchema = iDataSource.getSchema();
        if (this.m_Schema == null) {
            if (dataSchema != null) {
                this.m_SchemaChanged = true;
            }
        } else if (!this.m_Schema.equals((Object)dataSchema)) {
            this.m_SchemaChanged = true;
        }
        this.m_Schema = dataSchema;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = this.m_Schema.getColumnCount();
        for (n = 0; n < n2; ++n) {
            String string = this.m_Schema.getColumnName(n);
            if (this.m_HideColumns.contains(string)) continue;
            arrayList.add(n);
        }
        this.m_ColumnIndices = new int[arrayList.size()];
        for (n = 0; n < this.m_ColumnIndices.length; ++n) {
            this.m_ColumnIndices[n] = (Integer)arrayList.get(n);
        }
        this.m_TotalRowCount = 0;
        this.m_Current = this.m_Root = new GroupNode();
    }

    public void startGroup(DataGroup dataGroup) {
        this.m_Current = new GroupNode(this.m_Current, dataGroup.getName());
        this.m_Current.setStart(this.m_Rows.size());
    }

    public boolean processRecord(DataRecord dataRecord) {
        if (this.m_Throbber != null && this.m_TotalRowCount % 50 == 0) {
            this.m_Throbber.updateThrobber();
        }
        if (this.m_Limit == 0 || this.m_TotalRowCount < this.m_Limit) {
            this.m_Rows.add(dataRecord);
        }
        ++this.m_TotalRowCount;
        if (this.m_Limit > 0 && this.m_TotalRowCount >= this.m_Limit && !this.m_CountAll) {
            return false;
        }
        return !this.m_Context.isAborted();
    }

    public void endGroup(DataGroup dataGroup) {
        this.m_Current.setStop(this.m_Rows.size() - 1);
        this.m_Current = this.m_Current.getParent();
    }

    public void endData(IDataSource iDataSource) {
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (DataTableModel.this.m_Throbber != null) {
                    DataTableModel.this.m_Throbber.resetThrobber();
                }
                if (DataTableModel.this.m_SchemaChanged) {
                    DataTableModel.this.fireTableStructureChanged();
                } else {
                    DataTableModel.this.fireTableDataChanged();
                }
            }
        });
    }

    public GroupNode getRoot() {
        return this.m_Root;
    }

    public void setSchemaChanged(boolean bl) {
        this.m_SchemaChanged = bl;
    }

    public boolean isSchemaChanged() {
        return this.m_SchemaChanged;
    }

    protected String format(Object[] objectArray, int n) {
        DataAttributes dataAttributes = this.m_Schema.getAttributes(n);
        Format format = (Format)dataAttributes.getAttribute(Format.class);
        if (format != null) {
            return String.format(format.getFormat(), objectArray[n]);
        }
        DataType dataType = this.m_Schema.getColumnType(n);
        return this.m_Schema.format(dataType, objectArray[n]);
    }
}

