/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.ds;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.IFileTypeManager;
import com.elixirtech.arch.repository.RepositorySaveWizard;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.RawDataSource;
import com.elixirtech.ensemble.DataSourceFileType;
import com.elixirtech.ensemble.EnsembleAction;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.ds.DSUtil2;
import com.elixirtech.ensemble.ds.DataTable;
import com.elixirtech.ensemble.ds.DataTableModel;
import com.elixirtech.util.FileUtil;
import com.elixirtech.v2.repository.FileObject;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class DataTableMouseListener
extends MouseAdapter {
    private DataTable m_DataTable;

    public DataTableMouseListener(DataTable dataTable) {
        this.m_DataTable = dataTable;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        }
    }

    protected FileObject chooseTargetFile(FileObject fileObject) {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        RepositorySaveWizard repositorySaveWizard = new RepositorySaveWizard("Save Selection", fileObject);
        I18N.ENSEMBLE_MAP.injectObject(null, repositorySaveWizard.myPage(), "RepositorySaveDSWizard");
        elixirFrame.showWizard(repositorySaveWizard);
        if (repositorySaveWizard.isFinished()) {
            return repositorySaveWizard.getSelection();
        }
        return null;
    }

    protected static FileObject createChild(FileObject fileObject, String string) throws IOException {
        int n = 1;
        while (true) {
            block4: {
                FileObject fileObject2 = fileObject.getChildJ("Temp" + n + string);
                try {
                    if (fileObject2 == null) {
                        return fileObject.createData("Temp" + n + string);
                    }
                }
                catch (IOException iOException) {
                    if (n <= 100) break block4;
                    throw iOException;
                }
            }
            ++n;
        }
    }

    private void doPopup(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        boolean bl = this.m_DataTable.getSwingTable().getSelectedRowCount() > 0;
        String string = bl ? "DataTable.SAVE_SEL_AS" : "DataTable.SAVE_SCHEMA_AS";
        JMenu jMenu = new JMenu(I18N.ENSEMBLE.getString(string));
        jMenu.add(new SaveTabularAction());
        jPopupMenu.add(jMenu);
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private class SaveTabularAction
    extends EnsembleAction {
        public SaveTabularAction() {
            super("DataTable.SaveTabular");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IFileTypeManager iFileTypeManager = (IFileTypeManager)Elixir.get(IFileTypeManager.class);
            FileType fileType = (FileType)iFileTypeManager.getFileType(DataSourceFileType.MIME_TYPE()).get();
            FileObject fileObject = DataTableMouseListener.this.chooseTargetFile(DataTableMouseListener.this.m_DataTable.getFileObject());
            if (fileObject != null) {
                try {
                    JTable jTable = DataTableMouseListener.this.m_DataTable.getSwingTable();
                    DataTableModel dataTableModel = (DataTableModel)jTable.getModel();
                    com.elixirtech.data2.DataTable dataTable = (com.elixirtech.data2.DataTable)dataTableModel.getDataSource();
                    DataSchema dataSchema = dataTable.getSchema();
                    int[] nArray = jTable.getSelectedRows();
                    DataRecord[] dataRecordArray = new DataRecord[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        dataRecordArray[i] = dataTable.getRecord(nArray[i]);
                    }
                    com.elixirtech.data2.DataTable dataTable2 = new com.elixirtech.data2.DataTable("selection", dataSchema, dataRecordArray);
                    RawDataSource rawDataSource = new RawDataSource(dataTable2);
                    rawDataSource.setName(FileUtil.getNameWithoutExtension(fileObject.getName()));
                    fileObject = DSUtil2.save(fileObject, (IDataSource)rawDataSource);
                    Action action = fileType.getDefaultAction(fileObject);
                    action.actionPerformed(null);
                }
                catch (IOException iOException) {
                    ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18N.ENSEMBLE.getString("DataTable.CANT_CREATE_CHILD"), (Throwable)iOException);
                }
            }
        }
    }
}

