/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.ds;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.data2.DSLookup;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceDSL;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.DataStoreGO;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.ds.DSUtil;
import com.elixirtech.ensemble.ds.DataTable;
import com.elixirtech.ensemble.ui.ThrobbingPushContext;
import com.elixirtech.ui.SwingWorker;
import java.util.HashMap;
import java.util.Map;

public class GenerateDataWorker
extends SwingWorker {
    private final DataStore m_Store;
    private final CompositeDataSource m_DataSource;
    private final Map<String, String> m_Values = new HashMap<String, String>();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(GenerateDataWorker.class);

    public GenerateDataWorker(CompositeDataSource compositeDataSource, DataStoreGO dataStoreGO) throws DataException {
        this.m_DataSource = compositeDataSource;
        String string = compositeDataSource.getDiagram().getNodeId((Node)dataStoreGO);
        this.m_Store = this.m_DataSource.getDataStore(dataStoreGO);
        if (this.m_Store != null) {
            assert (!this.m_Store.isResult());
            if (DataTable.getParams((InOutGO)dataStoreGO, this.m_Values, (DSLookup)new DataSourceDSL((IDataSource)this.m_DataSource))) {
                this.start();
            }
        } else {
            throw new DataException("Can't locate DataStore named " + string);
        }
    }

    public GenerateDataWorker(CompositeDataSource compositeDataSource, DataStore dataStore) {
        assert (!dataStore.isResult());
        this.m_DataSource = compositeDataSource;
        this.m_Store = dataStore;
    }

    @Override
    public Object construct() {
        m_Log.debug((Object)"constructing...");
        try {
            ThrobbingPushContext throbbingPushContext = ThrobbingPushContext.getPushContext(this.m_Values);
            DSUtil.generate((CompositeDataSource)this.m_DataSource, (PushContext)throbbingPushContext, (DataStore)this.m_Store);
        }
        catch (DataException dataException) {
            ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18N.ENSEMBLE.getString("GenerateDataWorker.ERROR_LOADING_DATA"), (Throwable)dataException);
        }
        catch (RuntimeException runtimeException) {
            ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18N.ENSEMBLE.getString("GenerateDataWorker.ERROR_LOADING_DATA"), (Throwable)runtimeException);
        }
        finally {
            m_Log.debug((Object)"complete");
        }
        return null;
    }
}

