/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.ds;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.worker.AbortableSwingWorker;
import com.elixirtech.data2.DSLookup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataSourceDSL;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.ds.DataTable;
import com.elixirtech.ensemble.ds.DataTableModel;
import com.elixirtech.ensemble.ui.ThrobbingPushContext;
import java.util.HashMap;
import java.util.Map;

public class LoadDataWorker
extends AbortableSwingWorker {
    private DataTable m_DataTable;
    private IDataSource m_DataSource;
    private DataStore m_DataStore;
    private PushContext m_Context;
    private Map<String, String> m_Values = new HashMap<String, String>();

    public LoadDataWorker(DataTable dataTable, IDataSource iDataSource, DataStore dataStore, PushContext pushContext) {
        super("Load " + iDataSource.getName());
        this.m_DataTable = dataTable;
        this.m_DataSource = iDataSource;
        this.m_DataStore = dataStore;
        this.m_Context = pushContext;
        if (this.m_Context == null) {
            if (this.m_DataStore.isResult()) {
                if (DataTable.getParams(this.m_DataSource.getParameters(), this.m_Values, (DSLookup)new DataSourceDSL(this.m_DataSource))) {
                    this.start();
                }
            } else if (DataTable.getParams(this.m_DataStore.getParameters(), this.m_Values, (DSLookup)new DataSourceDSL(this.m_DataSource))) {
                this.m_DataSource = this.m_DataStore.getDataSource();
                this.start();
            }
        } else {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object construct() {
        DataTableModel dataTableModel;
        DataTableModel dataTableModel2 = dataTableModel = this.m_DataTable.getModel();
        synchronized (dataTableModel2) {
            dataTableModel.setCountAll(this.m_DataTable.isCountAllRecords());
            try {
                if (this.m_Context == null) {
                    this.m_Context = ThrobbingPushContext.getPushContext(this.m_Values);
                }
                if (this.m_Context instanceof DefaultPushContext) {
                    this.register((DefaultPushContext)this.m_Context);
                }
                dataTableModel.setPushContext(this.m_Context);
                this.m_DataSource.pushTo(this.m_Context, (DataListener)dataTableModel);
            }
            catch (Exception exception) {
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18N.ENSEMBLE.getString("GenerateDataWorker.ERROR_LOADING_DATA"), (Throwable)exception);
            }
        }
        return null;
    }

    @Override
    public void interrupt() {
        super.interrupt();
        this.m_DataTable.getModel().fireTableStructureChanged();
        this.m_DataTable.updateDecorations();
        this.m_Context = null;
        this.m_Values = null;
    }

    @Override
    public void finished() {
        super.finished();
        this.m_DataTable.getModel().fireTableStructureChanged();
        this.m_DataTable.updateDecorations();
        this.m_Context = null;
        this.m_Values = null;
    }
}

