/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.ds;

import com.elixirtech.data2.GroupNode;
import com.elixirtech.ensemble.ds.DataTableModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ToolTipManager;

public class RowHeader
extends JComponent {
    private DataTableModel m_TableModel;
    JTable m_Table;
    private int m_RowHeight;
    private List<GroupNode> m_LeafNodes = new ArrayList<GroupNode>();
    private int m_ChildDepth;

    public RowHeader(JTable jTable, DataTableModel dataTableModel) {
        this.m_Table = jTable;
        this.m_TableModel = dataTableModel;
        this.m_RowHeight = this.m_Table.getRowHeight();
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(new ML());
    }

    @Override
    public Dimension getPreferredSize() {
        int n = 0;
        GroupNode groupNode = this.m_TableModel.getRoot();
        this.m_ChildDepth = 0;
        if (groupNode != null && groupNode.hasChildren()) {
            this.m_ChildDepth = this.childDepth(groupNode);
            n = 10 + 8 * this.m_ChildDepth;
        }
        int n2 = this.m_Table.getRowCount() * this.m_RowHeight;
        return new Dimension(n, n2);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Dimension dimension;
        if (this.isOpaque()) {
            dimension = this.getSize();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(Color.black);
        }
        this.m_LeafNodes.clear();
        dimension = this.m_TableModel.getRoot();
        if (dimension.hasChildren()) {
            Iterator iterator = dimension.getChildIterator();
            while (iterator.hasNext()) {
                GroupNode groupNode = (GroupNode)iterator.next();
                this.render(graphics, 5, groupNode);
            }
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        GroupNode groupNode = this.getGroupNode(n, n2);
        if (groupNode != null) {
            this.setToolTipText(groupNode.getName());
        } else {
            this.setToolTipText(null);
        }
        return true;
    }

    protected GroupNode getGroupNode(int n, int n2) {
        int n3 = Math.max(0, (n - 3) / 8) + 1;
        int n4 = n2 / this.m_RowHeight;
        if (n4 >= this.m_Table.getRowCount()) {
            return null;
        }
        if (n4 < 0 || n4 >= this.m_LeafNodes.size()) {
            return null;
        }
        GroupNode groupNode = this.m_LeafNodes.get(n4);
        for (int i = 0; i < this.m_ChildDepth - n3; ++i) {
            groupNode = groupNode.getParent();
        }
        return groupNode;
    }

    protected void render(Graphics graphics, int n, GroupNode groupNode) {
        int n2 = groupNode.getStart();
        int n3 = groupNode.getStop();
        int n4 = n2 * this.m_RowHeight + this.m_RowHeight / 3;
        int n5 = n3 * this.m_RowHeight + 2 * this.m_RowHeight / 3;
        graphics.drawLine(n, n4, n, n5);
        graphics.drawLine(n, n4, n + 3, n4);
        graphics.drawLine(n, n5, n + 3, n5);
        if (groupNode.hasChildren()) {
            Iterator iterator = groupNode.getChildIterator();
            while (iterator.hasNext()) {
                GroupNode groupNode2 = (GroupNode)iterator.next();
                this.render(graphics, n + 8, groupNode2);
            }
        } else {
            for (int i = n2; i <= n3; ++i) {
                this.m_LeafNodes.add(groupNode);
            }
        }
    }

    protected int childDepth(GroupNode groupNode) {
        int n = 0;
        GroupNode groupNode2 = groupNode;
        while (groupNode2.hasChildren()) {
            groupNode2 = (GroupNode)groupNode2.getChildList().get(0);
            ++n;
        }
        return n;
    }

    private class ML
    extends MouseAdapter {
        private ML() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            GroupNode groupNode = RowHeader.this.getGroupNode(mouseEvent.getX(), mouseEvent.getY());
            if (groupNode != null) {
                RowHeader.this.m_Table.getSelectionModel().setSelectionInterval(groupNode.getStart(), groupNode.getStop());
            }
        }
    }
}

