/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.ds;

import com.elixirtech.arch.IAdaptable;
import com.elixirtech.arch.IDirtyState;
import com.elixirtech.arch.ISecurity;
import com.elixirtech.arch.js.ScriptEditor;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.editor.JEditor;
import com.elixirtech.editor.JEditorToolBar;
import com.elixirtech.ui.CurrentTab;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ScriptPanel
extends JPanel
implements CurrentTab,
IAdaptable {
    private CompositeDataSource m_DataSource;
    private ScriptEditor m_ScriptEditor;
    private JEditor m_Editor;
    private JEditorToolBar m_ToolBar;

    public ScriptPanel(CompositeDataSource compositeDataSource) {
        this.setLayout(new BorderLayout());
        this.m_DataSource = compositeDataSource;
        this.m_ScriptEditor = new ScriptEditor();
        this.m_Editor = this.m_ScriptEditor.getEditor();
        this.m_Editor.setText(this.m_DataSource.getJavaScript());
        this.m_Editor.setDirty(false);
        ISecurity iSecurity = (ISecurity)this.m_DataSource.getAdapter(ISecurity.class);
        this.m_Editor.setEditable(!iSecurity.isReadOnly());
        this.m_ToolBar = new JEditorToolBar(this.m_Editor);
        this.add((Component)this.m_ToolBar, "North");
        this.add((Component)this.m_ScriptEditor.getComponent(), "Center");
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IAdaptable.class) {
            return clazz.cast(this);
        }
        if (clazz == IDirtyState.class) {
            return clazz.cast(this.m_Editor);
        }
        return null;
    }

    public void setScript(String string) {
        boolean bl = this.m_Editor.isDirty();
        this.m_Editor.setText(string);
        this.m_Editor.setDirty(bl);
    }

    public String getScript() {
        return this.m_Editor.getText();
    }

    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setCurrent(boolean bl) {
        if (bl) {
            this.setScript(this.m_DataSource.getJavaScript());
            this.m_ScriptEditor.refresh();
        } else {
            this.m_DataSource.setJavaScript(this.getScript());
        }
    }

    public void dispose() {
        this.m_ToolBar.dispose();
    }
}

