/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard;

import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DSLookup;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.ParameterPanel;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.ui.wizard.WizardPage;
import java.awt.BorderLayout;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;

public class ParameterUI
extends Wizard
implements ArgumentMap.ICallback {
    List<Parameter> m_Parameters;
    DSLookup m_DSLookup;
    private ParameterPage m_ParameterPage;

    public ParameterUI(List<Parameter> list, DSLookup dSLookup) {
        super(I18N.ENSEMBLE.getString("ParameterUIWizard.TITLE"));
        this.m_Parameters = list;
        this.m_DSLookup = dSLookup;
        this.m_ParameterPage = new ParameterPage();
        this.m_ParameterPage.setWizard(this);
        this.m_Pages.add(this.m_ParameterPage);
    }

    public String getValue(String string) {
        return this.m_ParameterPage.getValue(string);
    }

    @Override
    public boolean canFinish() {
        return true;
    }

    @Override
    public boolean performFinish() {
        this.m_Finished = true;
        return true;
    }

    public void populateProperties(Map<String, String> map) {
        for (Parameter parameter : this.m_Parameters) {
            String string = parameter.getName();
            map.put(string, this.m_ParameterPage.getValue(string));
        }
    }

    public String substitute(String string) {
        return ArgumentMap.substitute((String)string, (ArgumentMap.ICallback)this);
    }

    public String getValue(String string, String string2) {
        return this.getValue(string);
    }

    private class ParameterPage
    extends WizardPage
    implements DSLookup {
        private ParameterPanel m_Panel;

        public ParameterPage() {
            super("Parameters", null);
            I18N.ENSEMBLE_MAP.injectObject(null, this, "ParameterUI");
        }

        @Override
        public void setWizard(IWizard iWizard) {
            super.setWizard(iWizard);
            this.m_Component.setLayout(new BorderLayout());
            this.m_Component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_Panel = new ParameterPanel(ParameterUI.this.m_Parameters, this);
            this.m_Component.add(new JScrollPane(this.m_Panel, 20, 31));
        }

        public String getValue(String string) {
            return this.m_Panel.getValue(string);
        }

        public IDataSource getDataSource(String string) throws DataException {
            if (ParameterUI.this.m_DSLookup != null) {
                return ParameterUI.this.m_DSLookup.getDataSource(string);
            }
            return null;
        }
    }
}

