/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.concat;

import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.ConcatGO;
import com.elixirtech.ensemble.canvas.DataFlowGO;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.GOFirstPage;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConcatPage
extends GOFirstPage<ConcatGO> {
    private I18NComboBox m_Type;
    private JList m_List;
    private DefaultListModel m_Model;
    private JButton m_MoveUp;
    private JButton m_MoveDown;
    static final String[] KEYS = new String[]{"ConcatPage.Union", "ConcatPage.Intersection"};
    static final String[] IDS = new String[]{"Union", "Intersection"};

    public ConcatPage(ConcatGO concatGO) {
        super(concatGO, "Concat", "<dynamic>");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "ConcatPage");
    }

    @Override
    public void performFinish() {
        super.performFinish();
        ((ConcatGO)this.m_GO).setUserProperty("Concat_Type", this.m_Type.getSelectedId());
        ((ConcatGO)this.m_GO).setInFlows(this.m_Model.toArray());
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    public IWizardPage getNextPage() {
        return null;
    }

    @Override
    public boolean isPageComplete() {
        boolean bl;
        boolean bl2 = bl = ((ConcatGO)this.m_GO).getSchema() != null;
        if (bl) {
            this.setError(null);
        } else {
            this.setError(I18N.ENSEMBLE.getString("GO.CANT_READ_SCHEMA"));
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    public void up() {
        int n = this.m_List.getSelectedIndex();
        this.m_Model.add(n - 1, this.m_Model.remove(n));
        this.m_List.setSelectedIndex(n - 1);
    }

    public void down() {
        int n = this.m_List.getSelectedIndex();
        this.m_Model.add(n + 1, this.m_Model.remove(n));
        this.m_List.setSelectedIndex(n + 1);
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.buildComponents();
        this.addComponents();
        this.positionComponents();
        I18N.ENSEMBLE_MAP.injectComponents("ConcatPage.", this.m_Component);
        this.checkEnabled();
    }

    private void buildComponents() {
        this.m_Type = I18NComboBox.apply(I18NComboBox.buildModel(IDS, I18N.ENSEMBLE, KEYS));
        this.m_Type.setName("type");
        this.m_Type.setSelectedId(((ConcatGO)this.m_GO).getUserProperty("Concat_Type"));
        this.m_Model = new DefaultListModel();
        Object[] objectArray = this.getFlows();
        for (int i = 0; i < objectArray.length; ++i) {
            this.m_Model.addElement(objectArray[i]);
        }
        this.m_List = SwingFactory.newList(this.m_Model);
        this.m_List.setCellRenderer(new LCR());
        this.m_List.addListSelectionListener(new LSL(this));
        this.m_MoveUp = new JButton(StandardIcons.UP);
        this.m_MoveUp.addActionListener(new CodeBlock((Object)this, "up"));
        this.m_MoveDown = new JButton(StandardIcons.DOWN);
        this.m_MoveDown.addActionListener(new CodeBlock((Object)this, "down"));
    }

    private void addComponents() {
        this.addLabel(SwingFactory.newLabel("type-label"));
        this.m_Component.add(this.m_Type);
        this.m_Component.add(SwingFactory.newScrollPane("list", this.m_List));
        this.m_Component.add("up", this.m_MoveUp);
        this.m_Component.add("down", this.m_MoveDown);
    }

    private void positionComponents() {
        this.putRight("GOFirstPage.name", "GOFirstPage.name-label,type-label", 10);
        this.alignBelow("type", "GOFirstPage.name");
        this.stickRight("type");
        this.stickLeft("list");
        this.putBelow("list", "type", 10);
        this.putLeft("list", "up");
        this.stickBottom("list");
        this.stickRight("up");
        this.putBelow("up", "type", 10);
        this.stickRight("down");
        this.putBelow("down", "up");
    }

    protected void checkEnabled() {
        int n = this.m_List.getSelectedIndex();
        int n2 = this.m_List.getModel().getSize();
        this.m_MoveUp.setEnabled(n > 0);
        this.m_MoveDown.setEnabled(n >= 0 && n < n2 - 1);
    }

    protected Object[] getFlows() {
        return ((ConcatGO)this.m_GO).getInFlows();
    }

    protected void setFlows(Object[] objectArray) {
        ((ConcatGO)this.m_GO).setInFlows(objectArray);
    }

    static class LCR
    extends DefaultListCellRenderer {
        LCR() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            DataFlowGO dataFlowGO = (DataFlowGO)object;
            String string = ((InOutGO)dataFlowGO.getStartGO()).getText();
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }
    }

    static class LSL
    implements ListSelectionListener {
        private ConcatPage m_Page;

        public LSL(ConcatPage concatPage) {
            this.m_Page = concatPage;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.m_Page.checkEnabled();
        }
    }
}

