/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.cube;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.IRenderable2;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.SortNode;
import com.elixirtech.ensemble.cube.ICubeWrapper;
import com.elixirtech.ensemble.wizard.cube.HierarchyPage;
import com.elixirtech.ensemble.wizard.cube.LevelChoice;
import com.elixirtech.ensemble.wizard.cube.LevelDialog;
import com.elixirtech.icons.EnsembleIcons;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.ui.LCellRenderer;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.TitledBorder;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.util.CodeBlock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class AxesPanel
extends JPanel {
    private IWizard m_Wizard;
    private ICubeWrapper m_ICube;
    private boolean m_Initialized;
    JList m_Dimensions;
    private Axis m_Rows = new Axis(I18N.ENSEMBLE.getString("AxesPanel.ROW_DIMENSIONS"));
    private Axis m_Columns = new Axis(I18N.ENSEMBLE.getString("AxesPanel.COL_DIMENSIONS"));
    Set<Choice> m_AvailableDimensions = new TreeSet<Choice>();
    private Map<String, Choice> m_AvailableMap = new HashMap<String, Choice>();
    private static final Icon FIELD = EnsembleIcons.FIELD;
    private static final Icon HIERARCHY = EnsembleIcons.HIERARCHY;

    public AxesPanel(IWizard iWizard, ICubeWrapper iCubeWrapper) {
        this.m_Wizard = iWizard;
        this.m_ICube = iCubeWrapper;
        this.m_Dimensions = SwingFactory.newList();
        this.m_Dimensions.setCellRenderer(new LCellRenderer());
        this.setLayout(new GridLayout(1, 2));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.m_Dimensions), "Center");
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.add(this.m_Columns);
        jPanel2.add(this.m_Rows);
        this.add(jPanel2);
        if (iCubeWrapper.isReadOnly()) {
            this.m_Columns.setEnabled(false);
            this.m_Rows.setEnabled(false);
            this.m_Dimensions.setEnabled(false);
        }
    }

    public void setRowDimensions(SortNode[] sortNodeArray) {
        for (int i = 0; i < sortNodeArray.length; ++i) {
            Choice choice = this.m_AvailableMap.get(sortNodeArray[i].getName());
            if (choice == null) continue;
            LevelChoice levelChoice = new LevelChoice(sortNodeArray[i], choice.getRenderableIcon());
            this.m_Rows.m_Model.addElement(levelChoice);
        }
    }

    public void setColumnDimensions(SortNode[] sortNodeArray) {
        for (int i = 0; i < sortNodeArray.length; ++i) {
            Choice choice = this.m_AvailableMap.get(sortNodeArray[i].getName());
            if (choice == null) continue;
            LevelChoice levelChoice = new LevelChoice(sortNodeArray[i], choice.getRenderableIcon());
            this.m_Columns.m_Model.addElement(levelChoice);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.m_Dimensions.setModel(this.getDimensionModel());
            if (!this.m_Initialized) {
                this.setRowDimensions(this.m_ICube.getCubeRows());
                this.setColumnDimensions(this.m_ICube.getCubeColumns());
                this.m_Initialized = true;
            }
            this.updateButtons();
        }
    }

    public boolean isInitialized() {
        return this.m_Initialized;
    }

    protected int getRowCount() {
        return this.m_Rows.getCount();
    }

    protected int getColumnCount() {
        return this.m_Columns.getCount();
    }

    protected SortNode[] getRowDimensions() {
        return this.m_Rows.getDimensions();
    }

    protected SortNode[] getColumnDimensions() {
        return this.m_Columns.getDimensions();
    }

    protected ListModel getDimensionModel() {
        Choice choice;
        DefaultListModel<Choice> defaultListModel = new DefaultListModel<Choice>();
        this.m_AvailableDimensions.clear();
        this.m_AvailableMap.clear();
        DataSchema dataSchema = this.m_ICube.getDataSchema();
        if (dataSchema != null) {
            int n = dataSchema.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String string = dataSchema.getColumnName(i);
                choice = new Choice(string, FIELD);
                this.m_AvailableDimensions.add(choice);
                this.m_AvailableMap.put(string, choice);
            }
        }
        HierarchyPage hierarchyPage = (HierarchyPage)this.m_Wizard.getPage("Dimension");
        String[] stringArray = hierarchyPage.getHierarchyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            choice = new Choice(stringArray[i], HIERARCHY);
            this.m_AvailableDimensions.add(choice);
            this.m_AvailableMap.put(stringArray[i], choice);
        }
        Iterator<Choice> iterator = this.m_AvailableDimensions.iterator();
        while (iterator.hasNext()) {
            defaultListModel.addElement(iterator.next());
        }
        return defaultListModel;
    }

    protected void updateButtons() {
        IWizardContainer iWizardContainer = this.m_Wizard.getContainer();
        if (iWizardContainer != null) {
            iWizardContainer.updateButtons();
        }
    }

    public class Axis
    extends JPanel {
        private boolean m_Enabled = true;
        private JButton m_In = this.button(StandardIcons.RIGHT);
        private JButton m_Out = this.button(StandardIcons.LEFT);
        private JButton m_Up = this.button(StandardIcons.UP);
        private JButton m_Down = this.button(StandardIcons.DOWN);
        private JButton m_Dots = SwingFactory.newDotsButton();
        private JList m_List = SwingFactory.newList();
        DefaultListModel m_Model = new DefaultListModel();

        public Axis(String string) {
            this.setLayout(new BorderLayout());
            this.setBorder(new TitledBorder(new JLabel(string)));
            this.m_List.setCellRenderer(new LCellRenderer());
            this.m_List.setModel(this.m_Model);
            this.m_List.addListSelectionListener(new CodeBlock((Object)this, "updateButtons"));
            Box box = Box.createVerticalBox();
            box.add(this.m_In);
            box.add(this.m_Out);
            this.add((Component)box, "West");
            this.add(new JScrollPane(this.m_List));
            JPanel jPanel = new JPanel(new GridLayout(3, 1));
            jPanel.add(this.m_Up);
            jPanel.add(this.m_Down);
            jPanel.add(this.m_Dots);
            this.add((Component)jPanel, "East");
            this.m_In.addActionListener(new CodeBlock((Object)this, "in"));
            this.m_Out.addActionListener(new CodeBlock((Object)this, "out"));
            this.m_Up.addActionListener(new CodeBlock((Object)this, "up"));
            this.m_Down.addActionListener(new CodeBlock((Object)this, "down"));
            this.m_Dots.addActionListener(new CodeBlock((Object)this, "edit"));
            this.updateButtons();
        }

        public int getCount() {
            return this.m_Model.getSize();
        }

        public void updateAvailable() {
            ArrayList<SortNode> arrayList = new ArrayList<SortNode>();
            int n = this.m_Model.getSize();
            for (int i = 0; i < n; ++i) {
                SortNode sortNode = (SortNode)this.m_Model.elementAt(i);
                if (AxesPanel.this.m_AvailableMap.containsKey(sortNode.getName())) continue;
                arrayList.add(sortNode);
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.m_Model.removeElement(iterator.next());
            }
        }

        public SortNode[] getDimensions() {
            this.updateAvailable();
            SortNode[] sortNodeArray = new SortNode[this.m_Model.getSize()];
            for (int i = 0; i < sortNodeArray.length; ++i) {
                sortNodeArray[i] = (SortNode)this.m_Model.elementAt(i);
            }
            return sortNodeArray;
        }

        public void in() {
            Object[] objectArray = AxesPanel.this.m_Dimensions.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                LevelChoice levelChoice = new LevelChoice((Choice)objectArray[i]);
                int n = this.m_Model.size();
                this.m_Model.addElement(levelChoice);
                this.m_List.setSelectedIndex(n);
            }
            this.updateButtons();
        }

        public void out() {
            Object[] objectArray = this.m_List.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.m_Model.removeElement(objectArray[i]);
            }
            this.updateButtons();
        }

        public void up() {
            int[] nArray = this.m_List.getSelectedIndices();
            if (nArray.length > 0) {
                Arrays.sort(nArray);
                if (nArray[0] > 0) {
                    for (int i = 0; i < nArray.length; ++i) {
                        Object e = this.m_Model.remove(nArray[i]);
                        int n = i;
                        nArray[n] = nArray[n] - 1;
                        this.m_Model.add(nArray[i], e);
                    }
                    this.m_List.setSelectedIndices(nArray);
                }
            }
        }

        public void down() {
            int[] nArray = this.m_List.getSelectedIndices();
            if (nArray.length > 0) {
                Arrays.sort(nArray);
                if (nArray[nArray.length - 1] < this.m_Model.size() - 1) {
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        Object e = this.m_Model.remove(nArray[i]);
                        int n = i;
                        nArray[n] = nArray[n] + 1;
                        this.m_Model.add(nArray[i], e);
                    }
                    this.m_List.setSelectedIndices(nArray);
                }
            }
        }

        public void edit() {
            int[] nArray = this.m_List.getSelectedIndices();
            if (nArray.length == 1) {
                Object e = this.m_Model.elementAt(nArray[0]);
                ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
                LevelDialog levelDialog = new LevelDialog(elixirFrame.getFrame(), AxesPanel.this.m_ICube.getDataSchema(), (LevelChoice)e, AxesPanel.this.m_ICube.isShowUITitles());
                elixirFrame.showModal(levelDialog);
                this.repaint();
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            this.m_Enabled = bl;
            this.m_In.setEnabled(bl);
            this.m_Out.setEnabled(bl);
            this.m_Up.setEnabled(bl);
            this.m_Down.setEnabled(bl);
            this.m_List.setEnabled(bl);
        }

        public void updateButtons() {
            int[] nArray = this.m_List.getSelectedIndices();
            boolean bl = nArray.length > 0;
            boolean bl2 = nArray.length > 1;
            boolean bl3 = bl && !bl2 && ((LevelChoice)this.m_List.getSelectedValue()).isHierarchy();
            this.m_Up.setEnabled(this.m_Enabled && bl);
            this.m_Down.setEnabled(this.m_Enabled && bl);
            this.m_Dots.setEnabled(this.m_Enabled && bl && !bl3);
        }

        private JButton button(Icon icon) {
            JButton jButton = new JButton(icon);
            jButton.setMargin(new Insets(0, 0, 0, 0));
            return jButton;
        }
    }

    class Choice
    implements IRenderable2,
    Comparable<Choice> {
        private String m_Name;
        private Icon m_Icon;

        public Choice(String string, Icon icon) {
            this.m_Name = string;
            this.m_Icon = icon;
        }

        @Override
        public String getRenderableName() {
            return this.m_Name;
        }

        @Override
        public Icon getRenderableIcon() {
            return this.m_Icon;
        }

        @Override
        public int compareTo(Choice choice) {
            return this.m_Name.compareTo(choice.m_Name);
        }
    }
}

