/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.cube;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceDSL;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.data2.olap.Cube;
import com.elixirtech.data2.olap.CubeDataSource;
import com.elixirtech.data2.olap.CubeHelper;
import com.elixirtech.data2.olap.Dimension;
import com.elixirtech.data2.olap.Hierarchy;
import com.elixirtech.data2.olap.IDimension;
import com.elixirtech.data2.olap.Level;
import com.elixirtech.data2.olap.Measure;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.CompositeDiagram;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.canvas.SortNode;
import com.elixirtech.ensemble.cube.ICubeWrapper;
import com.elixirtech.ensemble.cube.IMeasure;
import com.elixirtech.ensemble.ds.DSPanel;
import com.elixirtech.ensemble.wizard.ParameterUI;
import com.elixirtech.ensemble.wizard.cube.AxisPage;
import com.elixirtech.ensemble.wizard.cube.CubeInfo;
import com.elixirtech.ensemble.wizard.cube.FlagsPage;
import com.elixirtech.ensemble.wizard.cube.HierarchyPage;
import com.elixirtech.ensemble.wizard.cube.HierarchyPanel;
import com.elixirtech.ensemble.wizard.cube.ICubeWizard;
import com.elixirtech.ensemble.wizard.cube.LevelChoice;
import com.elixirtech.ensemble.wizard.cube.MeasurePage;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingWorker;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;

public class CachePage
extends WizardPage
implements ActionListener,
ItemListener {
    public static final String NAME = "Cache";
    private ICubeWrapper m_ICube;
    private ArchLayout m_Layout;
    private JButton m_Infer;
    ResultSchemaPanel m_SchemaPanel;
    DataSchema m_CubeSchema;

    public CachePage() {
        super(NAME, null);
        I18N.ENSEMBLE_MAP.injectObject(null, this, "CubeCachePage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_ICube = ((ICubeWizard)((Object)iWizard)).getCube();
        this.m_CubeSchema = this.m_ICube.getCachedSchema();
        this.buildComponent();
    }

    public void performFinish() {
        this.m_ICube.setCachedSchema(this.m_CubeSchema);
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public IWizardPage getNextPage() {
        return null;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.updateButtons();
            Set<String> set = this.m_SchemaPanel.getDiscardSet();
            this.m_SchemaPanel.setSchema(this.m_CubeSchema, set);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        CubeInfo cubeInfo;
        String string;
        int n;
        DataSchema dataSchema = this.m_ICube.getDataSchema();
        IFunctionFactory iFunctionFactory = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
        AxisPage axisPage = (AxisPage)this.m_Wizard.getPage("Axis");
        MeasurePage measurePage = (MeasurePage)this.m_Wizard.getPage("Measure");
        FlagsPage flagsPage = (FlagsPage)this.m_Wizard.getPage("Flags");
        IDimension[] iDimensionArray = this.buildDimensions(axisPage.getRowDimensions());
        IDimension[] iDimensionArray2 = this.buildDimensions(axisPage.getColumnDimensions());
        IMeasure[] iMeasureArray = measurePage.getMeasures();
        Measure[] measureArray = new Measure[iMeasureArray.length];
        for (n = 0; n < measureArray.length; ++n) {
            string = iMeasureArray[n].getName();
            int n2 = dataSchema.getColumnIndex(string);
            cubeInfo = iFunctionFactory.getFunction(CubeHelper.CUBE_DATA_TYPE, iMeasureArray[n].getFunction());
            String string2 = iMeasureArray[n].getPattern();
            measureArray[n] = new Measure(string, n2, (Function)cubeInfo, string2);
        }
        n = 0;
        string = "All";
        String string3 = "All";
        if (flagsPage != null) {
            n = flagsPage.isKeepColumnTotals() ? 1 : 0;
            string = flagsPage.getRowTitle();
            string3 = flagsPage.getColumnTitle();
        }
        cubeInfo = new CubeInfo(iDimensionArray, iDimensionArray2, measureArray);
        this.inferCubeSchema(dataSchema, cubeInfo, n != 0, string, string3);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateButtons();
    }

    protected IDimension[] buildDimensions(SortNode[] sortNodeArray) {
        HierarchyPage hierarchyPage = (HierarchyPage)this.m_Wizard.getPage("Dimension");
        IDimension[] iDimensionArray = new IDimension[sortNodeArray.length];
        for (int i = 0; i < sortNodeArray.length; ++i) {
            Hierarchy hierarchy;
            if (this.isHierarchy(sortNodeArray[i].getName())) {
                hierarchy = new Hierarchy(sortNodeArray[i].getName());
                HierarchyPanel.Dimension dimension = hierarchyPage.getHierarchy(sortNodeArray[i].getName());
                for (int j = 0; j < dimension.path.length; ++j) {
                    LevelChoice levelChoice = dimension.path[j];
                    hierarchy.addLevel(new Level(levelChoice.getName(), levelChoice.getSortOrder(), levelChoice.getGroupOn(), levelChoice.getGroupData(), levelChoice.getDerivedField()));
                }
                iDimensionArray[i] = hierarchy;
                continue;
            }
            hierarchy = new Level(sortNodeArray[i].getName(), sortNodeArray[i].getSortOrder(), sortNodeArray[i].getGroupOn(), sortNodeArray[i].getGroupData(), null);
            iDimensionArray[i] = new Dimension((Level)hierarchy);
        }
        return iDimensionArray;
    }

    protected boolean isHierarchy(String string) {
        HierarchyPage hierarchyPage = (HierarchyPage)this.m_Wizard.getPage("Dimension");
        return hierarchyPage.isHierarchy(string);
    }

    protected void buildComponent() {
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.m_Layout = new ArchLayout();
        this.m_Component.setLayout(this.m_Layout);
        this.m_Infer = SwingFactory.newButton("infer");
        this.m_Infer.addActionListener(this);
        this.m_Component.add("infer", this.m_Infer);
        this.m_SchemaPanel = new ResultSchemaPanel(true);
        this.m_Component.add("schema", this.m_SchemaPanel);
        this.m_Layout.hCenter("infer");
        this.m_Layout.stickTop("infer");
        this.m_Layout.stickLeft("schema");
        this.m_Layout.stickRight("schema");
        this.m_Layout.putBelow("schema", "infer", 3);
        this.m_Layout.stickBottom("schema");
        I18N.ENSEMBLE_MAP.injectComponents("CubeCachePage.", this.m_Component);
        this.updateButtons();
    }

    protected void updateButtons() {
        MeasurePage measurePage = (MeasurePage)this.m_Wizard.getPage("Measure");
        DataSchema dataSchema = this.m_ICube.getDataSchema();
        int n = measurePage.getMeasureCount();
        IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
        IPanelView iPanelView = iViewModel != null ? iViewModel.getCurrentView() : null;
        boolean bl = iPanelView instanceof DSPanel && n > 0 && dataSchema != null;
        this.m_Infer.setEnabled(bl);
        if (bl) {
            this.setError(null);
        } else if (n == 0) {
            this.setError("No measures defined");
        }
        IWizardContainer iWizardContainer = this.m_Wizard.getContainer();
        if (iWizardContainer != null) {
            iWizardContainer.updateMessage();
        }
    }

    protected void inferCubeSchema(DataSchema dataSchema, CubeInfo cubeInfo, boolean bl, String string, String string2) {
        DSPanel dSPanel;
        IDataSource iDataSource;
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
        IPanelView iPanelView = iViewModel.getCurrentView();
        if (iPanelView instanceof DSPanel && (iDataSource = (dSPanel = (DSPanel)iViewModel.getCurrentView()).getDataSource(this.m_ICube.getInput())) != null) {
            ArgumentMap argumentMap;
            HashMap<String, String> hashMap = null;
            List list = null;
            InOutGO inOutGO = this.m_ICube.getInput();
            if (inOutGO != null) {
                argumentMap = new ArgumentMap();
                inOutGO.buildParameters(argumentMap);
                list = argumentMap.getParameters();
            } else {
                list = iDataSource.getParameters();
            }
            if (list.size() > 0) {
                argumentMap = dSPanel.getDataSource();
                DataSourceDSL dataSourceDSL = new DataSourceDSL((IDataSource)argumentMap);
                ParameterUI parameterUI = new ParameterUI(list, dataSourceDSL);
                elixirFrame.showWizard(parameterUI);
                if (!parameterUI.isFinished()) {
                    return;
                }
                hashMap = new HashMap<String, String>();
                parameterUI.populateProperties(hashMap);
            }
            new InferSchema(iDataSource, cubeInfo, bl, hashMap, string, string2);
        }
    }

    private class InferSchema
    extends SwingWorker {
        private DefaultPushContext m_Context;
        private IDataSource m_DataSource;
        private IDimension[] m_Rows;
        private IDimension[] m_Columns;
        private Measure[] m_Measures;
        private boolean m_KeepColumnTotals;
        private Map<String, String> m_Values;
        private String m_RowTitle;
        private String m_ColumnTitle;

        public InferSchema(IDataSource iDataSource, CubeInfo cubeInfo, boolean bl, Map<String, String> map, String string, String string2) {
            this.m_DataSource = iDataSource;
            this.m_Rows = cubeInfo.rows;
            this.m_Columns = cubeInfo.cols;
            this.m_Measures = cubeInfo.measures;
            this.m_KeepColumnTotals = bl;
            this.m_Values = map;
            this.m_RowTitle = string;
            this.m_ColumnTitle = string2;
            Set<String> set = CachePage.this.m_SchemaPanel.getDiscardSet();
            CachePage.this.m_SchemaPanel.setSchema(null, set);
            IErrorHandler iErrorHandler = (IErrorHandler)Elixir.get(IErrorHandler.class);
            iErrorHandler.setProgress("Inferring Schema");
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.setWaitCursor();
            this.start();
        }

        private JavaScriptEngine prepareEngine() {
            CompositeDiagram compositeDiagram;
            CompositeDataSource compositeDataSource;
            String string;
            InOutGO inOutGO;
            JavaScriptEngine javaScriptEngine = null;
            this.m_Context = new DefaultPushContext();
            if (this.m_Values != null) {
                this.m_Context.setParameters(this.m_Values);
            }
            if ((inOutGO = CachePage.this.m_ICube.getInput()) != null && StringUtil.notEmpty(string = (compositeDataSource = (compositeDiagram = (CompositeDiagram)inOutGO.getDiagram()).getDataSource()).getJavaScript())) {
                javaScriptEngine = JavaScriptEngine.getInstance();
                try {
                    javaScriptEngine.execute("Composite Script", string);
                }
                catch (Throwable throwable) {
                    ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18N.ENSEMBLE.getString("CachePage.COMPOSITE_SCRIPT_ERROR"), throwable);
                }
            }
            return javaScriptEngine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object construct() {
            JavaScriptEngine javaScriptEngine = this.prepareEngine();
            try {
                Cube cube = new Cube(DataTable.build((PushContext)this.m_Context, (IDataSource)this.m_DataSource));
                CubeDataSource cubeDataSource = new CubeDataSource("infer", cube, this.m_Rows, this.m_Columns, this.m_Measures);
                cubeDataSource.setKeepColumnTotals(this.m_KeepColumnTotals);
                cubeDataSource.setRowTitle(this.m_RowTitle);
                cubeDataSource.setColumnTitle(this.m_ColumnTitle);
                DataSchema dataSchema = cubeDataSource.getSchema();
                return dataSchema;
            }
            catch (RuntimeException runtimeException) {
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18N.ENSEMBLE.getString("Error.CANT_INFER_SCHEMA"), (Throwable)runtimeException);
                Object var3_5 = null;
                return var3_5;
            }
            finally {
                if (javaScriptEngine != null) {
                    JavaScriptEngine.disposeInstance();
                }
            }
        }

        @Override
        public void finished() {
            DataSchema dataSchema = (DataSchema)this.getValue();
            if (dataSchema != null) {
                CachePage.this.m_CubeSchema = dataSchema;
            }
            Set<String> set = CachePage.this.m_SchemaPanel.getDiscardSet();
            CachePage.this.m_SchemaPanel.setSchema(CachePage.this.m_CubeSchema, set);
            IErrorHandler iErrorHandler = (IErrorHandler)Elixir.get(IErrorHandler.class);
            iErrorHandler.setProgress(null);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.setArrowCursor();
        }
    }
}

