/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.cube;

import com.elixirtech.data2.DataSchema;
import com.elixirtech.ensemble.cube.ICubeWrapper;
import com.elixirtech.ensemble.wizard.cube.AxisPage;
import com.elixirtech.ensemble.wizard.cube.CachePage;
import com.elixirtech.ensemble.wizard.cube.FlagsPage;
import com.elixirtech.ensemble.wizard.cube.HierarchyPage;
import com.elixirtech.ensemble.wizard.cube.ICubeWizard;
import com.elixirtech.ensemble.wizard.cube.MeasurePage;
import com.elixirtech.icons.EnsembleIcons;
import com.elixirtech.wizard.GOWizard;
import javax.swing.Icon;

public class CubeWizard
extends GOWizard
implements ICubeWizard {
    private ICubeWrapper m_ICube;
    private HierarchyPage m_HierarchyPage;
    private AxisPage m_AxisPage;
    private MeasurePage m_MeasurePage;
    private FlagsPage m_FlagsPage;
    private CachePage m_CachePage;
    private Icon m_CubeIcon;

    public CubeWizard(ICubeWrapper iCubeWrapper) {
        super("CubeWizard.TITLE");
        this.m_ICube = iCubeWrapper;
        this.m_CubeIcon = EnsembleIcons.CUBEHEADER;
        this.setReadOnly(iCubeWrapper.isReadOnly());
        this.buildPages();
    }

    @Override
    public ICubeWrapper getCube() {
        return this.m_ICube;
    }

    @Override
    public boolean performFinish() {
        this.m_HierarchyPage.performFinish();
        this.m_AxisPage.performFinish();
        this.m_CachePage.performFinish();
        this.m_MeasurePage.performFinish();
        this.m_FlagsPage.performFinish();
        this.m_ICube.setDirty();
        return true;
    }

    protected DataSchema getSchema() {
        return this.m_ICube.getDataSchema();
    }

    protected String[] getHierarchyNames() {
        return this.m_HierarchyPage.getHierarchyNames();
    }

    protected void buildPages() {
        this.m_HierarchyPage = new HierarchyPage();
        this.m_HierarchyPage.setIcon(this.m_CubeIcon);
        this.m_AxisPage = new AxisPage();
        this.m_AxisPage.setIcon(this.m_CubeIcon);
        this.m_MeasurePage = new MeasurePage();
        this.m_MeasurePage.setIcon(this.m_CubeIcon);
        this.m_FlagsPage = new FlagsPage();
        this.m_FlagsPage.setIcon(this.m_CubeIcon);
        this.m_CachePage = new CachePage();
        this.m_CachePage.setIcon(this.m_CubeIcon);
        this.m_Pages.add(this.m_HierarchyPage);
        this.m_Pages.add(this.m_AxisPage);
        this.m_Pages.add(this.m_MeasurePage);
        this.m_Pages.add(this.m_FlagsPage);
        this.m_Pages.add(this.m_CachePage);
        this.m_HierarchyPage.setWizard(this);
        this.m_AxisPage.setWizard(this);
        this.m_MeasurePage.setWizard(this);
        this.m_FlagsPage.setWizard(this);
        this.m_CachePage.setWizard(this);
    }
}

