/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.cube;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.cube.ICubeWrapper;
import com.elixirtech.ensemble.wizard.cube.HierarchyDialog;
import com.elixirtech.ensemble.wizard.cube.LevelChoice;
import com.elixirtech.ui.EditableTable;
import com.elixirtech.ui.table.ElxTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class HierarchyPanel
extends JPanel
implements ActionListener {
    private ICubeWrapper m_ICube;
    private DataSchema m_Schema;
    List<Dimension> m_Hierarchies = new ArrayList<Dimension>();
    private HierarchyModel m_Model;
    private EditableTable m_Table;
    static final String[] COLUMNS = new String[]{"TableModel.Name", "TableModel.Elements"};

    public HierarchyPanel(ICubeWrapper iCubeWrapper) {
        this.setLayout(new BorderLayout());
        this.setName("hier");
        this.m_Model = new HierarchyModel();
        this.m_Table = new EditableTable(this.m_Model, true, false);
        this.m_Table.setSingleSelectionMode();
        this.m_Table.setColumnWidth(0, 150);
        this.m_Table.setAutoResizeMode(3);
        this.m_Table.addActionListener(this);
        this.add((Component)this.m_Table, "Center");
        this.m_ICube = iCubeWrapper;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("plus".equals(string)) {
            this.addDimension();
        } else if ("minus".equals(string)) {
            this.removeDimension();
        } else if ("edit".equals(string)) {
            this.editDimension();
        }
    }

    public boolean isHierarchy(String string) {
        return this.getDimension(string) != null;
    }

    public void setSchema(DataSchema dataSchema) {
        this.m_Schema = dataSchema;
    }

    public DataSchema getSchema() {
        return this.m_Schema;
    }

    public void removeAllDimensions() {
        this.m_Hierarchies.clear();
    }

    public void addDimension(String string, LevelChoice[] levelChoiceArray) {
        this.m_Hierarchies.add(new Dimension(string, levelChoiceArray));
    }

    public int getDimensionCount() {
        return this.m_Hierarchies.size();
    }

    public Dimension getDimension(int n) {
        return this.m_Hierarchies.get(n);
    }

    public Dimension getDimension(String string) {
        if (string != null) {
            for (Dimension dimension : this.m_Hierarchies) {
                if (!dimension.name.equals(string)) continue;
                return dimension;
            }
        }
        return null;
    }

    public void addDimension() {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        String string = I18N.ENSEMBLE.getString("HierarchyPanel.ADD_HIERARCHY");
        HierarchyDialog hierarchyDialog = new HierarchyDialog(this.m_Schema, elixirFrame.getFrame(), string, new Dimension("", new LevelChoice[0]), this.m_ICube);
        elixirFrame.showModal(hierarchyDialog);
        if (hierarchyDialog.isOk()) {
            Dimension dimension = hierarchyDialog.getDimension();
            this.m_Model.addDimension(dimension);
            int n = this.m_Hierarchies.indexOf(dimension);
            this.m_Table.select(n);
        }
    }

    public void editDimension() {
        int n = this.m_Table.getSelectedRow();
        Dimension dimension = this.m_Hierarchies.get(n);
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        String string = I18N.ENSEMBLE.getString("HierarchyPanel.EDIT_HIERARCHY");
        HierarchyDialog hierarchyDialog = new HierarchyDialog(this.m_Schema, elixirFrame.getFrame(), string, dimension, this.m_ICube);
        elixirFrame.showModal(hierarchyDialog);
        this.m_Model.updateDimension(dimension);
    }

    public void removeDimension() {
        int n = this.m_Table.getSelectedRow();
        Dimension dimension = this.m_Hierarchies.get(n);
        this.m_Model.removeDimension(dimension);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_Table.setEnabled(bl);
    }

    private class HierarchyModel
    extends ElxTableModel {
        public HierarchyModel() {
            super(I18N.ENSEMBLE, COLUMNS);
        }

        @Override
        public int getRowCount() {
            return HierarchyPanel.this.m_Hierarchies.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Dimension dimension = HierarchyPanel.this.m_Hierarchies.get(n);
            if (n2 == 0) {
                return dimension.name;
            }
            LevelChoice[] levelChoiceArray = dimension.path;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < levelChoiceArray.length; ++i) {
                stringBuffer.append(levelChoiceArray[i].getRenderableName());
                if (i >= levelChoiceArray.length - 1) continue;
                stringBuffer.append("/");
            }
            return stringBuffer.toString();
        }

        public void addDimension(Dimension dimension) {
            int n = HierarchyPanel.this.m_Hierarchies.size();
            HierarchyPanel.this.m_Hierarchies.add(dimension);
            this.fireTableRowsInserted(n, n);
        }

        public void removeDimension(Dimension dimension) {
            int n = HierarchyPanel.this.m_Hierarchies.indexOf(dimension);
            if (n >= 0) {
                HierarchyPanel.this.m_Hierarchies.remove(dimension);
                this.fireTableRowsDeleted(n, n);
            }
        }

        public void updateDimension(Dimension dimension) {
            int n = HierarchyPanel.this.m_Hierarchies.indexOf(dimension);
            if (n >= 0) {
                this.fireTableRowsUpdated(n, n);
            }
        }
    }

    public static class Dimension {
        public String name;
        public LevelChoice[] path;

        public Dimension(String string, LevelChoice[] levelChoiceArray) {
            this.name = string;
            this.path = levelChoiceArray;
        }
    }
}

