/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.cube;

import com.elixirtech.arch.IRenderable2;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.SortNode;
import com.elixirtech.ensemble.wizard.cube.AxesPanel;
import com.elixirtech.icons.EnsembleIcons;
import java.util.Locale;
import javax.swing.Icon;

public class LevelChoice
extends SortNode
implements IRenderable2,
Comparable<LevelChoice> {
    private Icon m_Icon;

    public LevelChoice(AxesPanel.Choice choice) {
        this(choice.getRenderableName(), choice.getRenderableIcon());
    }

    public LevelChoice(SortNode sortNode, Icon icon) {
        this.setName(sortNode.getName());
        this.setSortOrder(sortNode.getSortOrder());
        this.setGroupOn(sortNode.getGroupOn());
        this.setGroupData(sortNode.getGroupData());
        this.setDerivedField(sortNode.getDerivedField());
        this.setShowTotals(sortNode.isShowTotals());
        this.setTotalTitle(sortNode.getTotalTitle());
        this.m_Icon = icon;
    }

    public LevelChoice(String string, Icon icon) {
        this.setName(string);
        this.m_Icon = icon;
        this.setSortOrder("Ascending");
        this.setGroupOn("Each Value");
    }

    @Override
    public int compareTo(LevelChoice levelChoice) {
        return this.getName().compareTo(levelChoice.getName());
    }

    public boolean isHierarchy() {
        return this.m_Icon == EnsembleIcons.HIERARCHY;
    }

    @Override
    public String getRenderableName() {
        if (this.isHierarchy()) {
            return this.getName();
        }
        if ("Each Value".equals(this.getGroupOn())) {
            return this.getName();
        }
        return this.getName() + "." + this.groupI18N(this.getGroupOn());
    }

    @Override
    public Icon getRenderableIcon() {
        return this.m_Icon;
    }

    private String groupI18N(String string) {
        String string2 = string.replace(' ', '_').toUpperCase(Locale.ENGLISH);
        return I18N.ENSEMBLE.getString("Group." + string2);
    }
}

