/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.cube;

import com.elixirtech.data2.DataSchema;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.cube.ICubeWrapper;
import com.elixirtech.ensemble.cube.IMeasure;
import com.elixirtech.ensemble.wizard.cube.ICubeWizard;
import com.elixirtech.ensemble.wizard.cube.MeasurePanel;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.WizardPage;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;

public class MeasurePage
extends WizardPage {
    public static final String NAME = "Measure";
    private ICubeWrapper m_ICube;
    private MeasurePanel m_MeasurePanel;

    public MeasurePage() {
        super(NAME, null);
        I18N.ENSEMBLE_MAP.injectObject(null, this, "MeasurePage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_ICube = ((ICubeWizard)((Object)iWizard)).getCube();
        this.buildComponent();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            DataSchema dataSchema = this.m_ICube.getDataSchema();
            if (dataSchema != null) {
                this.m_MeasurePanel.setSchema(dataSchema);
            } else {
                this.setError(I18N.ENSEMBLE.getString("MeasurePage.CANT_READ_SCHEMA"));
            }
        }
    }

    public int getMeasureCount() {
        return this.m_MeasurePanel.getMeasureCount();
    }

    public IMeasure[] getMeasures() {
        int n = this.m_MeasurePanel.getMeasureCount();
        IMeasure[] iMeasureArray = new IMeasure[n];
        for (int i = 0; i < n; ++i) {
            iMeasureArray[i] = this.m_MeasurePanel.getMeasure(i);
        }
        return iMeasureArray;
    }

    public void performFinish() {
        this.m_ICube.removeAllMeasures();
        int n = this.m_MeasurePanel.getMeasureCount();
        for (int i = 0; i < n; ++i) {
            IMeasure iMeasure = this.m_MeasurePanel.getMeasure(i);
            this.m_ICube.addMeasure(iMeasure);
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    @Override
    public IWizardPage getNextPage() {
        IWizardPage iWizardPage = this.m_Wizard.getPage("Flags");
        if (iWizardPage == null) {
            iWizardPage = this.m_Wizard.getPage("Cache");
        }
        return iWizardPage;
    }

    @Override
    public boolean isPageComplete() {
        IWizardContainer iWizardContainer;
        boolean bl = true;
        this.setError(null);
        int n = this.m_MeasurePanel.getMeasureCount();
        if (n == 0) {
            this.setError(I18N.ENSEMBLE.getString("MeasurePage.ONE_MEASURE_REQUIRED"));
            bl = false;
        }
        if ((iWizardContainer = this.m_Wizard.getContainer()) != null) {
            iWizardContainer.updateMessage();
        }
        return bl;
    }

    protected void buildComponent() {
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.m_Component.setLayout(new BorderLayout());
        this.m_MeasurePanel = new MeasurePanel(this.m_Wizard);
        int n = this.m_ICube.getMeasureCount();
        for (int i = 0; i < n; ++i) {
            IMeasure iMeasure = this.m_ICube.getMeasure(i);
            this.m_MeasurePanel.addMeasure(iMeasure);
        }
        if (this.m_ICube.isReadOnly()) {
            this.m_MeasurePanel.setEnabled(false);
        }
        this.m_Component.add(this.m_MeasurePanel);
    }
}

