/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.cube;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.FunctionFactory;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.data2.olap.CubeHelper;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.cube.IMeasure;
import com.elixirtech.ensemble.wizard.cube.MeasureHolder;
import com.elixirtech.ui.OrderedEditableTable;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class MeasurePanel
extends JPanel
implements ActionListener {
    private IWizard m_Wizard;
    private OrderedEditableTable m_Table;
    private MeasureModel m_Model;
    private DataSchema m_Schema;
    List<IMeasure> m_Measures = new ArrayList<IMeasure>();
    static final String[] COLUMNS = new String[]{"TableModel.Name", "TableModel.Function", "TableModel.Pattern"};

    public MeasurePanel(IWizard iWizard) {
        this.m_Wizard = iWizard;
        this.setLayout(new BorderLayout());
        this.m_Model = new MeasureModel();
        this.m_Table = new OrderedEditableTable(this.m_Model, true, false);
        this.m_Table.setSingleSelectionMode();
        this.m_Table.setColumnWidth(0, 100);
        this.m_Table.setAutoResizeMode(3);
        this.m_Table.setDefaultRenderer(Function.class, new FunctionCellRenderer());
        this.m_Table.addActionListener(this);
        this.add(this.m_Table);
        this.updateButtons();
    }

    public void setSchema(DataSchema dataSchema) {
        this.m_Schema = dataSchema;
        this.updateButtons();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("plus".equals(string)) {
            this.addMeasure();
        } else if ("minus".equals(string)) {
            this.removeMeasure();
        } else if ("edit".equals(string)) {
            this.editMeasure();
        } else if ("up".equals(string)) {
            this.upMeasure();
        } else if ("down".equals(string)) {
            this.downMeasure();
        }
        this.updateButtons();
    }

    public int getMeasureCount() {
        return this.m_Measures.size();
    }

    public IMeasure getMeasure(int n) {
        return this.m_Measures.get(n);
    }

    public void addMeasure(IMeasure iMeasure) {
        this.m_Model.addMeasure(iMeasure);
    }

    public void addMeasure() {
        try {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            String string = I18N.ENSEMBLE.getString("MeasurePanel.AddMeasure");
            MeasureDialog measureDialog = new MeasureDialog(elixirFrame.getFrame(), string, new MeasureHolder());
            elixirFrame.showModal(measureDialog);
            if (measureDialog.isOk()) {
                IMeasure iMeasure = measureDialog.getMeasure();
                this.m_Model.addMeasure(iMeasure);
                int n = this.m_Measures.indexOf(iMeasure);
                this.m_Table.select(n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void editMeasure() {
        int n = this.m_Table.getSelectedRow();
        IMeasure iMeasure = this.m_Measures.get(n);
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        String string = I18N.ENSEMBLE.getString("MeasurePanel.EditMeasure");
        MeasureDialog measureDialog = new MeasureDialog(elixirFrame.getFrame(), string, iMeasure);
        elixirFrame.showModal(measureDialog);
        if (measureDialog.isOk()) {
            this.m_Model.updateMeasure(iMeasure);
        }
    }

    public void removeMeasure() {
        int n = this.m_Table.getSelectedRow();
        IMeasure iMeasure = this.m_Measures.get(n);
        this.m_Model.removeMeasure(iMeasure);
    }

    public void upMeasure() {
        int n = this.m_Table.getSelectedRow();
        this.m_Model.moveUp(n);
        this.m_Table.select(n - 1);
    }

    public void downMeasure() {
        int n = this.m_Table.getSelectedRow();
        this.m_Model.moveDown(n);
        this.m_Table.select(n + 1);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_Table.setEnabled(bl);
    }

    protected void updateButtons() {
        IWizardContainer iWizardContainer = this.m_Wizard.getContainer();
        if (iWizardContainer != null) {
            iWizardContainer.updateButtons();
        }
    }

    protected String[] getSchemaColumns() {
        String[] stringArray = null;
        if (this.m_Schema == null) {
            stringArray = new String[]{};
        } else {
            stringArray = new String[this.m_Schema.getColumnCount()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.m_Schema.getColumnName(i);
            }
        }
        return stringArray;
    }

    private class MeasureModel
    extends ElxTableModel {
        public MeasureModel() {
            super(I18N.ENSEMBLE, COLUMNS);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return String.class;
            }
            if (n == 1) {
                return Function.class;
            }
            if (n == 2) {
                return String.class;
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return MeasurePanel.this.m_Measures.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            IMeasure iMeasure = MeasurePanel.this.m_Measures.get(n);
            if (n2 == 0) {
                return iMeasure.getName();
            }
            if (n2 == 1) {
                return iMeasure.getFunction();
            }
            return iMeasure.getPattern();
        }

        public void addMeasure(IMeasure iMeasure) {
            int n = MeasurePanel.this.m_Measures.size();
            MeasurePanel.this.m_Measures.add(iMeasure);
            this.fireTableRowsInserted(n, n);
        }

        public void removeMeasure(IMeasure iMeasure) {
            int n = MeasurePanel.this.m_Measures.indexOf(iMeasure);
            if (n >= 0) {
                MeasurePanel.this.m_Measures.remove(iMeasure);
                this.fireTableRowsDeleted(n, n);
            }
        }

        public void updateMeasure(IMeasure iMeasure) {
            int n = MeasurePanel.this.m_Measures.indexOf(iMeasure);
            if (n >= 0) {
                this.fireTableRowsUpdated(n, n);
            }
        }

        public void moveUp(int n) {
            IMeasure iMeasure = MeasurePanel.this.m_Measures.remove(n);
            MeasurePanel.this.m_Measures.add(n - 1, iMeasure);
            this.fireTableRowsUpdated(n - 1, n);
        }

        public void moveDown(int n) {
            IMeasure iMeasure = MeasurePanel.this.m_Measures.remove(n);
            MeasurePanel.this.m_Measures.add(n + 1, iMeasure);
            this.fireTableRowsUpdated(n, n + 1);
        }
    }

    private class FunctionCellRenderer
    extends DefaultTableCellRenderer {
        public FunctionCellRenderer() {
            this.setFont(UIManager.getFont("Tree.font"));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = FunctionFactory.getI18N((Object)object);
            return super.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
        }
    }

    public class MeasureDialog
    extends JDialog {
        private IMeasure m_Measure;
        private JComboBox m_Name;
        private JComboBox m_Function;
        private JTextField m_Pattern;
        private JButton m_Ok;
        private boolean m_IsOk;

        public MeasureDialog(JFrame jFrame, String string, IMeasure iMeasure) {
            super(jFrame, string, true);
            this.m_Measure = iMeasure;
            ArchLayout archLayout = new ArchLayout();
            JPanel jPanel = new JPanel(archLayout);
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.getContentPane().add(jPanel);
            jPanel.add(SwingFactory.newLabel("name-label"));
            jPanel.add(SwingFactory.newLabel("function-label"));
            jPanel.add(SwingFactory.newLabel("pattern-label"));
            this.m_Name = new JComboBox<String>(MeasurePanel.this.getSchemaColumns());
            this.m_Name.setSelectedItem(this.m_Measure.getName());
            this.m_Name.addItemListener(new CodeBlock((Object)this, "checkEnabled"));
            jPanel.add("name", this.m_Name);
            IFunctionFactory iFunctionFactory = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
            this.m_Function = new JComboBox<Function>(iFunctionFactory.getAllCube());
            this.m_Function.setRenderer(new FunctionComboRenderer());
            this.m_Function.setSelectedItem(iFunctionFactory.getFunction(CubeHelper.CUBE_DATA_TYPE, this.m_Measure.getFunction()));
            jPanel.add("function", this.m_Function);
            this.m_Pattern = new JTextField();
            this.m_Pattern.setText(this.m_Measure.getPattern());
            jPanel.add("pattern", this.m_Pattern);
            this.m_Ok = SwingFactory.newOkButton(new CodeBlock((Object)this, "ok"));
            jPanel.add("ok", this.m_Ok);
            JButton jButton = SwingFactory.newCancelButton(new CodeBlock((Object)this, "cancel"));
            jPanel.add("cancel", jButton);
            I18N.ENSEMBLE_MAP.injectComponents("MeasureDialog.", this);
            this.positionComponents(archLayout);
            this.setLocationRelativeTo(jFrame);
            this.checkEnabled();
        }

        private void positionComponents(ArchLayout archLayout) {
            archLayout.stickLeft("name-label");
            archLayout.vCenter("name-label", "name");
            archLayout.stickLeft("function-label");
            archLayout.vCenter("function-label", "function");
            archLayout.stickLeft("pattern-label");
            archLayout.vCenter("pattern-label", "pattern");
            archLayout.putRight("name", "name-label,function-label,pattern-label", 10);
            archLayout.stickRight("name");
            archLayout.stickTop("name");
            archLayout.alignBelow("function", "name");
            archLayout.stickRight("function");
            archLayout.alignBelow("pattern", "function");
            archLayout.stickRight("pattern");
            archLayout.putLeft("ok", "cancel", -10);
            archLayout.vCenter("ok", "cancel");
            archLayout.stickRight("cancel");
            archLayout.putBelow("cancel", "pattern", 5);
            this.pack();
            Dimension dimension = this.getPreferredSize();
            this.setSize(dimension.width + 20, dimension.height);
        }

        public void ok() {
            this.m_Measure.setName((String)this.m_Name.getSelectedItem());
            Function function = (Function)this.m_Function.getSelectedItem();
            this.m_Measure.setFunction(function.getName());
            this.m_Measure.setPattern(this.m_Pattern.getText());
            this.m_IsOk = true;
            this.dispose();
        }

        public void cancel() {
            this.m_Measure = null;
            this.dispose();
        }

        public boolean isOk() {
            return this.m_IsOk;
        }

        public IMeasure getMeasure() {
            return this.m_Measure;
        }

        public void checkEnabled() {
            this.m_Ok.setEnabled(StringUtil.notEmpty((String)this.m_Name.getSelectedItem()));
        }
    }

    private static class FunctionComboRenderer
    extends DefaultListCellRenderer {
        private FunctionComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2 = FunctionFactory.getI18N((Object)object);
            return super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
        }
    }
}

