/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.dataflow;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceDSL;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.ParameterUtil;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.data2.datasource.processor.attributes.AttributesSchemaPanel;
import com.elixirtech.data2.values.InfoBuilder;
import com.elixirtech.data2.values.ValuesDialog;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.CompositeDiagram;
import com.elixirtech.ensemble.canvas.DataFlowGO;
import com.elixirtech.ensemble.canvas.DataSourceGO;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.ds.DSPanel;
import com.elixirtech.ensemble.wizard.ParameterUI;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.ui.DoubleClickListener;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.ui.wizard.WizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;

class DataFlowPage
extends WizardPage {
    private final DataFlowGO m_GO;
    private ResultSchemaPanel m_SchemaPanel;

    public DataFlowPage(DataFlowGO dataFlowGO) {
        super("DataFlowType", "Properties");
        this.m_GO = dataFlowGO;
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DataFlowPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Component.setLayout(new BorderLayout());
        this.m_SchemaPanel = new AttributesSchemaPanel(true, true);
        DataSchema dataSchema = this.m_GO.getSchema();
        if (dataSchema != null) {
            Set<String> set = Collections.emptySet();
            this.m_SchemaPanel.setSchema(dataSchema, set);
        }
        this.m_SchemaPanel.addDoubleClickListener(new DCL());
        this.m_Component.add((Component)this.m_SchemaPanel, "Center");
    }

    public void performFinish() {
    }

    @Override
    public boolean canFlipToNextPage() {
        return true;
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    protected static boolean getParams(List<Parameter> list, Map<String, String> map) {
        if (ParameterUtil.getParamCount(list) > 0) {
            Object object;
            Object object2;
            IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
            IPanelView iPanelView = iViewModel.getCurrentView();
            DataSourceDSL dataSourceDSL = null;
            if (iPanelView instanceof DSPanel) {
                object2 = (DSPanel)iViewModel.getCurrentView();
                object = ((DSPanel)object2).getDataSource();
                dataSourceDSL = new DataSourceDSL((IDataSource)object);
            }
            object2 = new ParameterUI(list, dataSourceDSL);
            object = (ElixirFrame)Elixir.get(ElixirFrame.class);
            object.showWizard((IWizard)object2);
            if (!((Wizard)object2).isFinished()) {
                return false;
            }
            ((ParameterUI)object2).populateProperties(map);
        }
        return true;
    }

    private class DCL
    implements DoubleClickListener {
        private DCL() {
        }

        @Override
        public void doubleClick(MouseEvent mouseEvent) {
            String string = DataFlowPage.this.m_SchemaPanel.getSelectedName();
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            ValuesDialog valuesDialog = new ValuesDialog(elixirFrame.getFrame());
            CompositeDiagram compositeDiagram = (CompositeDiagram)DataFlowPage.this.m_GO.getDiagram();
            CompositeDataSource compositeDataSource = compositeDiagram.getDataSource();
            InOutGO inOutGO = (InOutGO)DataFlowPage.this.m_GO.getStartGO();
            compositeDataSource.rebuildFromDiagram(inOutGO);
            IDataSource iDataSource = compositeDataSource.getDataSource(inOutGO);
            if (iDataSource == null && inOutGO instanceof DataSourceGO) {
                iDataSource = ((DataSourceGO)inOutGO).getDataSource();
            }
            try {
                DataSchema dataSchema = iDataSource.getSchema();
                if (dataSchema != null) {
                    int n = dataSchema.getColumnIndex(string);
                    if (n >= 0) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        ArgumentMap argumentMap = new ArgumentMap();
                        inOutGO.buildParameters(argumentMap);
                        if (DataFlowPage.getParams(argumentMap.getParameters(), hashMap)) {
                            DefaultPushContext defaultPushContext = new DefaultPushContext();
                            defaultPushContext.setParameters(hashMap);
                            InfoBuilder infoBuilder = new InfoBuilder(iDataSource, n);
                            iDataSource.pushTo((PushContext)defaultPushContext, (DataListener)infoBuilder);
                            valuesDialog.setColumnInfo(infoBuilder);
                            valuesDialog.setLocationRelativeTo(elixirFrame.getFrame());
                            elixirFrame.showModal(valuesDialog);
                        }
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (RuntimeException runtimeException) {
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18N.ENSEMBLE.getString("InspectField.Exception"), (Throwable)runtimeException);
            }
        }
    }
}

