/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.datasource;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.repository.RepositoryTree;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.DataSourceGO;
import com.elixirtech.ensemble.canvas.GOUtil;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import com.elixirtech.wizard.GOFirstPage;
import java.awt.Color;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DataSourcePage
extends GOFirstPage<DataSourceGO>
implements ChangeListener {
    public static final String PAGE_NAME = "DataSource";
    private JTextField m_DSName;
    private JTabbedPane m_Tabs;
    private RepositoryTree m_Tree;
    private ResultSchemaPanel m_SchemaPanel;
    private boolean m_IsEditing;

    public DataSourcePage(DataSourceGO dataSourceGO) {
        super(dataSourceGO, PAGE_NAME, "Properties");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DataSourcePage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_DSName = SwingFactory.newTextField("dsname");
        Repository repository = (Repository)Elixir.get(Repository.class);
        RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
        FileType fileType = (FileType)repositoryExplorer.getFileType(String.valueOf(MimeTypes.DS())).get();
        this.m_Tree = RepositoryTree.apply("DataSourceGOWizard", repository, fileType);
        this.m_Component.add(SwingFactory.newLabel("dsname-label"));
        this.m_Component.add(this.m_DSName);
        this.m_Tabs = new JTabbedPane();
        this.m_Tabs.setName("tab");
        this.m_Component.add(this.m_Tabs);
        this.m_Tabs.addTab(I18N.ENSEMBLE.getString("DataSourcePage.DATASOURCES"), new JScrollPane(this.m_Tree));
        this.scrollTree(repository);
        CodeBlock codeBlock = new CodeBlock((Object)this, "dsnameChanged");
        this.m_DSName.getDocument().addDocumentListener(codeBlock);
        this.m_DSName.getDocument().addDocumentListener(new FieldWatcher(iWizard));
        CodeBlock codeBlock2 = new CodeBlock((Object)this, "treeChanged");
        this.m_Tree.addTreeSelectionListener(codeBlock2);
        this.m_SchemaPanel = new ResultSchemaPanel();
        DataSchema dataSchema = ((DataSourceGO)this.m_GO).getOriginalSchema();
        if (dataSchema != null) {
            Set set = GOUtil.getDiscardSet((Node)this.m_GO, (String)"DataSource_Discard");
            this.m_SchemaPanel.setSchema(dataSchema, set);
        }
        this.m_Tabs.addTab(I18N.ENSEMBLE.getString("DataSourcePage.SCHEMA"), this.m_SchemaPanel);
        this.m_Tabs.addChangeListener(this);
        I18N.ENSEMBLE_MAP.injectComponents("DataSourcePage.", this.m_Component);
        this.positionComponents();
    }

    private void scrollTree(Repository repository) {
        Object object = ((DataSourceGO)this.m_GO).getUserProperty(PAGE_NAME);
        if (object != null) {
            if (!((String)object).endsWith(".ds")) {
                object = (String)object + ".ds";
            }
            this.m_DSName.setText((String)object);
            FileObject fileObject = repository.getFileJ((String)object);
            if (fileObject != null) {
                this.m_Tree.setSelectionJ(fileObject);
            } else {
                this.m_DSName.setForeground(Color.RED);
            }
        }
    }

    private void positionComponents() {
        this.stickLeft("dsname-label");
        this.vCenter("dsname-label", "dsname");
        this.putRight("GOFirstPage.name", "GOFirstPage.name-label,dsname-label", 10);
        this.alignBelow("dsname", "GOFirstPage.name");
        this.stickRight("dsname");
        this.stickLeft("tab");
        this.stickRight("tab");
        this.stickBottom("tab");
        this.putBelow("tab", "dsname", 10);
    }

    @Override
    public void performFinish() {
        String string;
        super.performFinish();
        FileObject fileObject = this.m_Tree.getSelectionJ();
        String string2 = string = fileObject != null ? fileObject.getPathString() : null;
        if (string != null) {
            ((DataSourceGO)this.m_GO).setUserProperty(PAGE_NAME, string);
        }
        GOUtil.setDiscardSet((Node)this.m_GO, (String)"DataSource_Discard", this.m_SchemaPanel.getDiscardSet());
        this.m_Tree.dispose();
    }

    protected IDataSource getDataSource() {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        FileObject fileObject = this.m_Tree.getSelectionJ();
        if (fileObject == null) {
            return null;
        }
        String string = fileObject.getPathString();
        if (string == null) {
            return null;
        }
        try {
            return dataSourceManager.getDataSource(dataSourceManager, string);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    @Override
    public boolean isPageComplete() {
        boolean bl;
        this.setError(null);
        FileObject fileObject = this.m_Tree.getSelectionJ();
        boolean bl2 = bl = fileObject != null && fileObject.isData();
        if (!bl) {
            this.setError(I18N.ENSEMBLE.getString("DataSourcePage.DATASOURCE_REQUIRED"));
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.m_Tabs.getSelectedComponent() == this.m_SchemaPanel) {
            FileObject fileObject;
            String string;
            String string2 = ((DataSourceGO)this.m_GO).getUserProperty(PAGE_NAME);
            if (string2 == null) {
                string2 = "";
            }
            String string3 = string = (fileObject = this.m_Tree.getSelectionJ()) != null ? fileObject.getPathString() : null;
            if (!string2.equals(string)) {
                DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
                try {
                    IDataSource iDataSource;
                    DataSchema dataSchema = null;
                    if (string != null && (iDataSource = dataSourceManager.getDataSource(dataSourceManager, string)) != null) {
                        dataSchema = iDataSource.getSchema();
                    }
                    iDataSource = this.m_SchemaPanel.getDiscardSet();
                    this.m_SchemaPanel.setSchema(dataSchema, (Set<String>)iDataSource);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    public void dsnameChanged() {
        if (!this.m_IsEditing) {
            this.m_IsEditing = true;
            Object object = this.m_DSName.getText();
            if (!((String)object).endsWith(".ds")) {
                object = (String)object + ".ds";
            }
            object = this.stripAnyRepositoryPrefix((String)object);
            Repository repository = (Repository)Elixir.get(Repository.class);
            FileObject fileObject = repository.getFileJ((String)object);
            if (fileObject != null) {
                this.m_Tree.setSelectionJ(fileObject);
                this.m_DSName.setForeground(Color.BLACK);
            } else {
                this.m_Tree.setSelectionJ(null);
                this.m_DSName.setForeground(Color.RED);
            }
            IWizardContainer iWizardContainer = this.m_Wizard.getContainer();
            if (iWizardContainer != null) {
                iWizardContainer.updateButtons();
            }
            this.m_IsEditing = false;
        }
    }

    public void treeChanged() {
        if (!this.m_IsEditing) {
            this.m_IsEditing = true;
            FileObject fileObject = this.m_Tree.getSelectionJ();
            if (fileObject != null) {
                this.m_DSName.setText(fileObject.getPathString());
                this.m_DSName.setForeground(Color.BLACK);
                IWizardContainer iWizardContainer = this.m_Wizard.getContainer();
                if (iWizardContainer != null) {
                    iWizardContainer.updateButtons();
                }
            }
            this.m_IsEditing = false;
        }
    }

    private String stripAnyRepositoryPrefix(String string) {
        if (string != null && string.startsWith("repository:")) {
            return string.substring(11);
        }
        return string;
    }
}

