/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.datasource;

import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.DataSourceGO;
import com.elixirtech.ensemble.wizard.datasource.DataSourcePage;
import com.elixirtech.ensemble.wizard.datasource.ParameterModel;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

class DataSourcePropertiesPage
extends WizardPage
implements ActionListener {
    public static final String PAGE_NAME = "Properties";
    private final DataSourceGO m_GO;
    private ParameterModel m_Model;
    private JTable m_Table;
    private JButton m_Propagate;

    public DataSourcePropertiesPage(DataSourceGO dataSourceGO) {
        super(PAGE_NAME, null);
        this.m_GO = dataSourceGO;
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DataSourcePropertiesPage");
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Model = new ParameterModel(iWizard, this.m_GO);
        this.m_Table = SwingFactory.newTable();
        this.m_Table.setModel(this.m_Model);
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Component.setLayout(new BorderLayout());
        this.m_Component.add(new JScrollPane(this.m_Table));
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.m_Propagate = new JButton(I18N.ENSEMBLE.getString("DataSourcePropertiesPage.PROPAGATE_PARAMETERS"));
        this.m_Propagate.addActionListener(this);
        jPanel.add(this.m_Propagate);
        this.m_Component.add((Component)jPanel, "South");
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            DataSourcePage dataSourcePage = (DataSourcePage)this.m_Wizard.getPage("DataSource");
            IDataSource iDataSource = dataSourcePage.getDataSource();
            ArrayList<Parameter> arrayList = null;
            arrayList = iDataSource != null ? iDataSource.getParameters() : new ArrayList<Parameter>();
            this.m_Model.setParameters(arrayList);
            this.m_Propagate.setEnabled(arrayList.size() > 0);
        } else {
            this.disposeEditor();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.disposeEditor();
        int n = this.m_Model.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.m_Model.getValueAt(i, 0);
            String string2 = (String)this.m_Model.getActualValueAt(i, 1);
            if (!StringUtil.isEmpty(string2)) continue;
            this.m_Model.setValueAt("${" + string + "}", i, 1);
        }
        this.m_Model.fireTableDataChanged();
    }

    public void performFinish() {
        this.disposeEditor();
        this.m_Model.performFinish();
    }

    private void disposeEditor() {
        TableCellEditor tableCellEditor = this.m_Table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
            this.m_Table.removeEditor();
        }
    }
}

