/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.datasource;

import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.DataSourceGO;
import com.elixirtech.ensemble.canvas.ParameterNode;
import com.elixirtech.ensemble.wizard.datasource.DataSourcePage;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.ui.wizard.IWizard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class ParameterModel
extends ElxTableModel {
    static final String[] COLUMNS = new String[]{"TableModel.Name", "TableModel.Value"};
    private final DataSourceGO m_GO;
    private final List<Pair> m_Items = new ArrayList<Pair>();

    public ParameterModel(IWizard iWizard, DataSourceGO dataSourceGO) {
        super(I18N.ENSEMBLE, COLUMNS);
        this.m_GO = dataSourceGO;
        DataSourcePage dataSourcePage = (DataSourcePage)iWizard.getPage("DataSource");
        IDataSource iDataSource = dataSourcePage.getDataSource();
        if (iDataSource != null) {
            List list = iDataSource.getParameters();
            HashMap<String, Parameter> hashMap = new HashMap<String, Parameter>();
            for (Parameter parameter : list) {
                hashMap.put(parameter.getName(), parameter);
            }
            int n = this.m_GO.getParameterCount();
            for (int i = 0; i < n; ++i) {
                ParameterNode parameterNode = this.m_GO.getParameter(i);
                Parameter parameter = (Parameter)hashMap.get(parameterNode.getName());
                if (parameter == null) continue;
                Pair pair = new Pair(parameter);
                pair.value = parameterNode.getValue();
                this.m_Items.add(pair);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.m_Items.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Pair pair = this.m_Items.get(n);
        if (n2 == 0) {
            return pair.getName();
        }
        return pair.getValue();
    }

    public Object getActualValueAt(int n, int n2) {
        Pair pair = this.m_Items.get(n);
        if (n2 == 0) {
            return pair.getName();
        }
        return pair.value;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 1) {
            Pair pair = this.m_Items.get(n);
            String string = (String)object;
            if (string.trim().length() == 0) {
                string = null;
            }
            pair.value = string;
        }
    }

    public void setParameters(List<Parameter> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Pair pair : this.m_Items) {
            if (pair.value == null) continue;
            hashMap.put(pair.getName(), pair.value);
        }
        this.m_Items.clear();
        for (Parameter parameter : list) {
            if (parameter.getName().startsWith("elixir.report.ds")) continue;
            Pair pair = new Pair(parameter);
            pair.value = (String)hashMap.get(pair.getName());
            this.m_Items.add(pair);
        }
        Collections.sort(this.m_Items);
    }

    public void performFinish() {
        this.m_GO.removeAllParameters();
        for (Pair pair : this.m_Items) {
            if (pair.value == null) continue;
            this.m_GO.addParameter(pair.getName(), pair.value);
        }
    }

    private class Pair
    implements Comparable<Pair> {
        public Parameter parameter;
        public String value;

        public Pair(Parameter parameter) {
            this.parameter = parameter;
            this.value = null;
        }

        public String getName() {
            return this.parameter.getName();
        }

        public String getValue() {
            if (this.value == null) {
                return this.parameter.getDefaultValue();
            }
            return this.value;
        }

        @Override
        public int compareTo(Pair pair) {
            return this.getName().compareTo(pair.getName());
        }
    }
}

