/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.datastore;

import com.elixirtech.arch.ui.ViewablePasswordField;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.data2.output.sql.Dialect;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.datastore.ErrorStorePage;
import com.elixirtech.ensemble.wizard.datastore.TypePage;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.util.StringUtil;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public abstract class BaseJDBCPage
extends TypePage {
    protected JTextField m_URL;
    protected JComboBox m_Dialect;
    protected JTextField m_User;
    protected ViewablePasswordField m_Password;
    protected JTextField m_Table;
    protected JCheckBox m_TableExists;
    protected JCheckBox m_AppendData;
    protected JCheckBox m_AutoCommit;
    protected JCheckBox m_UpdateInsert;

    public BaseJDBCPage(String string) {
        super(string);
        this.m_NextPage = "ErrorStore";
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    @Override
    public IWizardPage getNextPage() {
        return this.m_Wizard.getPage(this.m_NextPage);
    }

    protected void buildLabel(JComponent jComponent) {
        String string = jComponent.getName();
        this.m_Component.add(string + "-label", SwingFactory.newLabel(string));
        this.m_Component.add(string, jComponent);
        this.m_Layout.stickLeft(string + "-label");
        this.m_Layout.vCenter(string + "-label", string);
    }

    public static String[] getDialectNames() {
        String[] stringArray = Dialect.getNames();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = I18N.ENSEMBLE.getString("JDBCPage.DEFAULT_DIALECT");
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    protected void buildComponents() {
        this.m_URL = SwingFactory.newTextField("url");
        this.m_Dialect = SwingFactory.newComboBox("dialect", BaseJDBCPage.getDialectNames());
        this.m_User = SwingFactory.newTextField("user");
        this.m_Password = new ViewablePasswordField();
        this.m_Password.setName("password");
        this.m_Table = SwingFactory.newTextField("table");
        this.m_TableExists = SwingFactory.newCheckBox("exists");
        this.m_AppendData = SwingFactory.newCheckBox("append");
        this.m_AutoCommit = SwingFactory.newCheckBox("commit");
        this.m_UpdateInsert = SwingFactory.newCheckBox("insert");
    }

    protected void initComponents(Node node) {
        assert (node != null);
        String string = node.getUserProperty("JDBC_Dialect");
        if (StringUtil.notEmpty(string)) {
            this.m_Dialect.setSelectedItem(string);
        } else {
            this.m_Dialect.setSelectedIndex(0);
        }
        this.m_URL.setText(node.getUserProperty("JDBC_URL"));
        this.m_User.setText(node.getUserProperty("JDBC_User"));
        this.m_Password.setText(node.getUserProperty("JDBC_Password"));
        this.m_Table.setText(node.getUserProperty("JDBC_TableName"));
        this.m_TableExists.setSelected(node.isUserProperty("JDBC_Exists"));
        this.m_AppendData.setSelected(node.isUserProperty("JDBC_Append"));
        this.m_AutoCommit.setSelected(node.isUserProperty("JDBC_AutoCommit"));
        this.m_UpdateInsert.setSelected(node.isUserProperty("JDBC_UpdateInsert"));
    }

    protected void addComponents() {
        this.buildLabel(this.m_URL);
        this.buildLabel(this.m_Dialect);
        this.buildLabel(this.m_User);
        this.buildLabel(this.m_Password);
        this.buildLabel(this.m_Table);
        this.m_Component.add(this.m_TableExists);
        this.m_Component.add(this.m_AppendData);
        this.m_Component.add(this.m_UpdateInsert);
    }

    public void performFinish(Node node) {
        if (this.m_Dialect.getSelectedIndex() > 0) {
            node.setUserProperty("JDBC_Dialect", (String)this.m_Dialect.getSelectedItem());
        } else {
            node.setUserProperty("JDBC_Dialect", "");
        }
        node.setUserProperty("JDBC_URL", this.m_URL.getText());
        node.setUserProperty("JDBC_User", this.m_User.getText());
        node.setUserProperty("JDBC_Password", this.m_Password.getText());
        node.setUserProperty("JDBC_TableName", this.m_Table.getText());
        node.setUserProperty("JDBC_Exists", this.m_TableExists.isSelected());
        node.setUserProperty("JDBC_Append", this.m_AppendData.isSelected());
        node.setUserProperty("JDBC_AutoCommit", this.m_AutoCommit.isSelected());
        node.setUserProperty("JDBC_UpdateInsert", this.m_UpdateInsert.isSelected());
        ((ErrorStorePage)this.getNextPage()).performFinish();
    }
}

