/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.datastore;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.ds.DSUtil2;
import com.elixirtech.ensemble.wizard.datastore.CheckFileAccess;
import com.elixirtech.ensemble.wizard.datastore.DataStoreWizard;
import com.elixirtech.ensemble.wizard.datastore.INodeHolder;
import com.elixirtech.ensemble.wizard.datastore.TypePage;
import com.elixirtech.ui.FileSaveDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.FileUtil;
import com.elixirtech.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class BinaryPage
extends TypePage
implements ActionListener {
    private JTextField m_URL;
    private JButton m_Dots;
    private JCheckBox m_Compress;

    public BinaryPage() {
        super("Binary");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DataStore.BinaryPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        Node node = ((INodeHolder)((Object)this.m_Wizard)).getNode();
        this.m_URL = SwingFactory.newTextField("url");
        if (node != null) {
            this.m_URL.setText(node.getUserProperty("display"));
        }
        this.m_URL.getDocument().addDocumentListener(new FieldWatcher(iWizard));
        this.m_Dots = SwingFactory.newDotsButton("dots", this);
        this.m_Dots.setEnabled(!iWizard.isReadOnly() && !DSUtil2.isRemote());
        this.m_Compress = SwingFactory.newCheckBox("compress");
        if (node != null) {
            this.m_Compress.setSelected(node.isUserProperty("Binary_Compress"));
        }
        this.m_Component.add(SwingFactory.newLabel("url-label"));
        this.m_Component.add(this.m_URL);
        this.m_Component.add(this.m_Dots);
        this.m_Component.add(this.m_Compress);
        I18N.ENSEMBLE_MAP.injectComponents("DataStore.BinaryPage.", this.m_Component);
        this.positionComponents();
    }

    @Override
    public boolean isPageComplete() {
        boolean bl = true;
        this.setError(null);
        if (StringUtil.isEmpty(this.m_URL.getText())) {
            this.setError(I18N.ENSEMBLE.getString("DataStore.URL_REQUIRED"));
            bl = false;
        } else if (!CheckFileAccess.isOk(this.m_URL.getText())) {
            this.setError(I18N.ENSEMBLE.getString("DataStore.INVALID_FILE_LOCATION"));
            bl = false;
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    private void positionComponents() {
        this.stickLeft("url-label");
        this.vCenter("url-label", "url");
        this.putRight("url", "url-label", 10);
        this.stickTop("url");
        this.putLeft("url", "dots");
        this.stickRight("dots");
        this.stickTop("dots");
        this.setHeight("dots", "url");
        this.alignBelow("compress", "url", 10);
    }

    @Override
    public void performFinish() {
        INodeHolder iNodeHolder = (INodeHolder)((Object)this.m_Wizard);
        Node node = iNodeHolder.getNode();
        node.setUserProperty("display", this.m_URL.getText());
        node.setUserProperty("Binary_URL", DataStoreWizard.ensureURL(this.m_URL.getText()));
        node.setUserProperty("Binary_Compress", this.m_Compress.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        FileSaveDialog fileSaveDialog = new FileSaveDialog();
        fileSaveDialog.removeChoosableFileFilter(fileSaveDialog.getAcceptAllFileFilter());
        fileSaveDialog.setFilter("bin", I18N.ENSEMBLE.getString("DataStore.BinaryPage.BinaryFiles"));
        if (fileSaveDialog.showSaveDialog(this.m_Component) == 0) {
            this.m_URL.setText(FileUtil.asURL(fileSaveDialog.getSelectedFile()));
        }
    }
}

