/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.datastore;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.ds.DSUtil2;
import com.elixirtech.ensemble.wizard.datastore.CheckFileAccess;
import com.elixirtech.ensemble.wizard.datastore.DataStoreWizard;
import com.elixirtech.ensemble.wizard.datastore.INodeHolder;
import com.elixirtech.ensemble.wizard.datastore.TypePage;
import com.elixirtech.ui.FileSaveDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.FileUtil;
import com.elixirtech.util.StringUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class CSVPage
extends TypePage
implements ActionListener {
    private static final String[] QUALIFIER_NAMES = new String[]{"", "\"", "'", "`"};
    private static final String NONE = "None";
    private JTextField m_URL;
    private JButton m_Dots;
    private JRadioButton m_Tab;
    private JRadioButton m_Semicolon;
    private JRadioButton m_Comma;
    private JRadioButton m_Space;
    private JRadioButton m_Other;
    private JTextField m_Separator;
    private JComboBox m_Qualifier;
    private JCheckBox m_AppendData;

    public CSVPage() {
        super("CSV File");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DataStore.CSVPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        Node node = ((INodeHolder)((Object)this.m_Wizard)).getNode();
        this.m_URL = SwingFactory.newTextField("url");
        if (node != null) {
            this.m_URL.setText(node.getUserProperty("display"));
        }
        this.m_URL.getDocument().addDocumentListener(new FieldWatcher(iWizard));
        this.m_Dots = SwingFactory.newDotsButton("dots", this);
        this.m_Dots.setEnabled(!iWizard.isReadOnly() && !DSUtil2.isRemote());
        Box box = this.buildSeparator(node);
        this.m_Qualifier = SwingFactory.newComboBox("qualifier", QUALIFIER_NAMES);
        JTextField jTextField = (JTextField)this.m_Qualifier.getEditor().getEditorComponent();
        jTextField.setDocument(new SingleCharDocument());
        this.m_Qualifier.setEditable(true);
        Dimension dimension = this.m_Qualifier.getPreferredSize();
        this.m_Qualifier.setPreferredSize(new Dimension(50, dimension.height));
        this.m_Qualifier.setSelectedIndex(0);
        if (node != null) {
            String string = node.getUserProperty("CSV_Qualifier");
            if (NONE.equals(string) || StringUtil.isEmpty(string)) {
                this.m_Qualifier.setSelectedIndex(0);
            } else {
                this.m_Qualifier.setSelectedItem(Character.valueOf(string.charAt(0)));
            }
        }
        this.m_AppendData = SwingFactory.newCheckBox("append");
        if (node != null) {
            this.m_AppendData.setSelected(node.isUserProperty("CSV_Append"));
        }
        this.m_Component.add(SwingFactory.newLabel("url-label"));
        this.m_Component.add(this.m_URL);
        this.m_Component.add(this.m_Dots);
        this.m_Component.add(SwingFactory.newLabel("separator-label"));
        this.m_Component.add(box);
        this.m_Component.add(SwingFactory.newLabel("qualifier-label"));
        this.m_Component.add(this.m_Qualifier);
        this.m_Component.add(this.m_AppendData);
        I18N.ENSEMBLE_MAP.injectComponents("DataStore.CSVPage.", this.m_Component);
        this.positionComponents();
    }

    @Override
    public boolean isPageComplete() {
        boolean bl = true;
        this.setError(null);
        if (StringUtil.isEmpty(this.m_URL.getText())) {
            this.setError(I18N.ENSEMBLE.getString("DataStore.URL_REQUIRED"));
            bl = false;
        } else if (!CheckFileAccess.isOk(this.m_URL.getText())) {
            this.setError(I18N.ENSEMBLE.getString("DataStore.INVALID_FILE_LOCATION"));
            bl = false;
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    private Box buildSeparator(Node node) {
        this.m_Tab = SwingFactory.newRadioButton("Tab");
        this.m_Semicolon = SwingFactory.newRadioButton("Semicolon");
        this.m_Comma = SwingFactory.newRadioButton("Comma");
        this.m_Space = SwingFactory.newRadioButton("Space");
        this.m_Other = SwingFactory.newRadioButton("Other");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_Tab);
        buttonGroup.add(this.m_Semicolon);
        buttonGroup.add(this.m_Comma);
        buttonGroup.add(this.m_Space);
        buttonGroup.add(this.m_Other);
        this.m_Separator = new JTextField(2);
        this.m_Tab.setSelected(true);
        Box box = Box.createHorizontalBox();
        box.setName("separator");
        box.add(this.m_Tab);
        box.add(this.m_Semicolon);
        box.add(this.m_Comma);
        box.add(this.m_Space);
        box.add(this.m_Other);
        box.add(this.m_Separator);
        box.add(Box.createHorizontalGlue());
        this.setSeparator(node != null ? node.getUserProperty("CSV_Separator") : "Comma");
        return box;
    }

    private void positionComponents() {
        this.stickLeft("url-label");
        this.vCenter("url-label", "url");
        this.putRight("url", "url-label,separator-label,qualifier-label", 10);
        this.stickTop("url");
        this.putLeft("url", "dots");
        this.stickRight("dots");
        this.stickTop("dots");
        this.setHeight("dots", "url");
        this.stickLeft("separator-label");
        this.vCenter("separator-label", "separator");
        this.alignBelow("separator", "url");
        this.stickLeft("qualifier-label");
        this.vCenter("qualifier-label", "qualifier");
        this.alignBelow("qualifier", "separator");
        this.alignBelow("append", "qualifier");
    }

    @Override
    public void performFinish() {
        INodeHolder iNodeHolder = (INodeHolder)((Object)this.m_Wizard);
        Node node = iNodeHolder.getNode();
        node.setUserProperty("display", this.m_URL.getText());
        node.setUserProperty("CSV_URL", DataStoreWizard.ensureURL(this.m_URL.getText()));
        node.setUserProperty("CSV_Separator", this.getSeparator());
        String string = NONE;
        if (this.m_Qualifier.getSelectedIndex() != 0) {
            string = String.valueOf(this.m_Qualifier.getSelectedItem()).trim();
            string = StringUtil.isEmpty(string) ? NONE : string.substring(0, 1);
        }
        node.setUserProperty("CSV_Qualifier", string);
        node.setUserProperty("CSV_Append", this.m_AppendData.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        FileSaveDialog fileSaveDialog = new FileSaveDialog();
        fileSaveDialog.removeChoosableFileFilter(fileSaveDialog.getAcceptAllFileFilter());
        fileSaveDialog.setFilter("csv", I18N.ENSEMBLE.getString("DataStore.CVSPage.CSVFiles"));
        if (fileSaveDialog.showSaveDialog(this.m_Component) == 0) {
            this.m_URL.setText(FileUtil.asURL(fileSaveDialog.getSelectedFile()));
        }
    }

    protected String getSeparator() {
        if (this.m_Tab.isSelected()) {
            return "Tab";
        }
        if (this.m_Semicolon.isSelected()) {
            return "Semicolon";
        }
        if (this.m_Comma.isSelected()) {
            return "Comma";
        }
        if (this.m_Space.isSelected()) {
            return "Space";
        }
        return this.m_Separator.getText();
    }

    protected void setSeparator(String string) {
        if ("Tab".equals(string)) {
            this.m_Tab.setSelected(true);
        } else if ("Semicolon".equals(string)) {
            this.m_Semicolon.setSelected(true);
        } else if ("Comma".equals(string)) {
            this.m_Comma.setSelected(true);
        } else if ("Space".equals(string)) {
            this.m_Space.setSelected(true);
        } else {
            this.m_Other.setSelected(true);
            this.m_Separator.setText(string);
        }
    }

    private static class SingleCharDocument
    extends PlainDocument {
        private SingleCharDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string.length() > 0) {
                this.remove(0, this.getLength());
                super.insertString(0, string.substring(0, 1), attributeSet);
            }
        }
    }
}

