/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.datastore;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.datastore.ConnectionPoolHelper;
import com.elixirtech.ensemble.wizard.datastore.ErrorStorePage;
import com.elixirtech.ensemble.wizard.datastore.INodeHolder;
import com.elixirtech.ensemble.wizard.datastore.JDBCPage;
import com.elixirtech.ensemble.wizard.datastore.TypePage;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ConnectionPoolPage
extends TypePage {
    public static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ConnectionPoolPage.class);
    private JComboBox<String> poolDropdown;
    private JTextArea m_Description;
    private JComboBox m_Dialect;
    private JTextField m_Table;
    private JCheckBox m_TableExists;
    private JCheckBox m_AppendData;
    private JCheckBox m_AutoCommit;
    private JCheckBox m_UpdateInsert;

    public ConnectionPoolPage() {
        super("Connection Pool");
        this.m_NextPage = "ErrorStore";
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DataStore.ConnectionPoolPage");
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    @Override
    public IWizardPage getNextPage() {
        return this.m_Wizard.getPage(this.m_NextPage);
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        Node node = ((INodeHolder)((Object)this.m_Wizard)).getNode();
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.m_Layout = new ArchLayout();
        this.m_Component.setLayout(this.m_Layout);
        this.buildComponents();
        if (node != null) {
            this.initComponents(node);
        }
    }

    private void buildComponents() {
        FieldWatcher fieldWatcher = new FieldWatcher(this.getWizard());
        JPanel jPanel = new JPanel();
        jPanel.setName("pool");
        jPanel.setLayout(new BorderLayout());
        this.poolDropdown = new JComboBox<String>(ConnectionPoolHelper.getPool());
        this.poolDropdown.setName("pool");
        this.poolDropdown.addItemListener(fieldWatcher);
        jPanel.add("Center", this.poolDropdown);
        this.m_Component.add(jPanel);
        this.stickLeft("pool");
        this.stickTop("pool");
        this.stickRight("pool");
        JLabel jLabel = SwingFactory.newLabel("table");
        jLabel.setName("table-label");
        JLabel jLabel2 = SwingFactory.newLabel("dialect");
        jLabel2.setName("dialect-label");
        this.m_Table = new JTextField(30);
        this.m_Table.setName("table");
        this.m_Table.getDocument().addDocumentListener(fieldWatcher);
        this.m_TableExists = SwingFactory.newCheckBox("exists");
        this.m_AppendData = SwingFactory.newCheckBox("append");
        this.m_AutoCommit = SwingFactory.newCheckBox("commit");
        this.m_UpdateInsert = SwingFactory.newCheckBox("insert");
        this.m_Dialect = SwingFactory.newComboBox("dialect", JDBCPage.getDialectNames());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        jPanel2.setName("jdbc");
        ArchLayout archLayout = new ArchLayout();
        jPanel2.setLayout(archLayout);
        jPanel2.add(jLabel);
        jPanel2.add(this.m_Table);
        jPanel2.add(jLabel2);
        jPanel2.add(this.m_Dialect);
        JPanel jPanel3 = new JPanel(new GridLayout(2, 2));
        jPanel3.setName("options");
        jPanel3.add(this.m_TableExists);
        jPanel3.add(this.m_AppendData);
        jPanel3.add(this.m_AutoCommit);
        jPanel3.add(this.m_UpdateInsert);
        jPanel2.add(jPanel3);
        archLayout.stickTop("table-label");
        archLayout.stickTop("table");
        archLayout.stickLeft("table-label");
        archLayout.putRight("table", "table-label", 30);
        archLayout.alignBelow("dialect-label", "table-label");
        archLayout.alignBelow("dialect", "table", 5);
        archLayout.vCenter("dialect-label", "dialect");
        archLayout.putBelow("options", "dialect", 5);
        archLayout.hCenter("options");
        this.m_Component.add(jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setName("description");
        TitledBorder titledBorder = BorderFactory.createTitledBorder(I18N.ENSEMBLE.getString("DataStore.ConnectionPoolPage.description-label.text"));
        jPanel4.setBorder(titledBorder);
        jPanel4.setLayout(new BorderLayout());
        this.m_Description = new JTextArea(4, 25);
        this.m_Description.setOpaque(false);
        this.m_Description.setEditable(false);
        this.m_Description.setName("description");
        jPanel4.add("Center", this.m_Description);
        this.m_Component.add(jPanel4);
        this.stickRight("description");
        this.alignBelow("description", "pool");
        this.stickRight("jdbc");
        this.alignBelow("jdbc", "description", 3);
        I18N.ENSEMBLE_MAP.injectComponents("DataStore.ConnectionPoolPage.", this.m_Component);
    }

    private void initComponents(Node node) {
        String string = node.getUserProperty("JDBC_FileURL");
        String string2 = node.getUserProperty("JDBC_Dialect");
        if (StringUtil.notEmpty(string2)) {
            this.m_Dialect.setSelectedItem(string2);
        } else {
            this.m_Dialect.setSelectedIndex(0);
        }
        this.m_Table.setText(node.getUserProperty("JDBC_TableName"));
        this.m_TableExists.setSelected(node.isUserProperty("JDBC_Exists"));
        this.m_AppendData.setSelected(node.isUserProperty("JDBC_Append"));
        this.m_AutoCommit.setSelected(node.isUserProperty("JDBC_AutoCommit"));
        this.m_UpdateInsert.setSelected(node.isUserProperty("JDBC_UpdateInsert"));
        if (!StringUtil.isEmpty(string)) {
            this.poolDropdown.setSelectedItem(string);
        }
    }

    @Override
    public void performFinish() {
        INodeHolder iNodeHolder = (INodeHolder)((Object)this.m_Wizard);
        Node node = iNodeHolder.getNode();
        String string = String.valueOf(this.poolDropdown.getSelectedItem());
        if (!StringUtil.isEmpty(string)) {
            node.setUserProperty("JDBC_FileURL", string);
        }
        if (this.m_Dialect.getSelectedIndex() > 0) {
            node.setUserProperty("JDBC_Dialect", (String)this.m_Dialect.getSelectedItem());
        } else {
            node.setUserProperty("JDBC_Dialect", "");
        }
        node.setUserProperty("JDBC_TableName", this.m_Table.getText());
        node.setUserProperty("JDBC_Exists", this.m_TableExists.isSelected());
        node.setUserProperty("JDBC_Append", this.m_AppendData.isSelected());
        node.setUserProperty("JDBC_AutoCommit", this.m_AutoCommit.isSelected());
        node.setUserProperty("JDBC_UpdateInsert", this.m_UpdateInsert.isSelected());
        ((ErrorStorePage)this.getNextPage()).performFinish();
    }

    @Override
    public boolean isPageComplete() {
        boolean bl = true;
        this.setError(null);
        String string = String.valueOf(this.poolDropdown.getSelectedItem());
        if (StringUtil.isEmpty(string)) {
            this.setError(I18N.ENSEMBLE.getString("DataStore.POOL_REQUIRED"));
            bl = false;
        } else if (StringUtil.isEmpty(this.m_Table.getText())) {
            this.setError(I18N.ENSEMBLE.getString("DataStore.TABLE_REQUIRED"));
            bl = false;
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }
}

