/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.wizard.datastore;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.datasource.composite.DataStoreRegistry;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.DataStoreGO;
import com.elixirtech.ensemble.canvas.GOUtil;
import com.elixirtech.ensemble.wizard.datastore.DataStoreWizard;
import com.elixirtech.ensemble.wizard.result.OrderableResultSchemaPanel;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.wizard.GOFirstPage;
import java.util.List;
import java.util.Set;

public class DataStoreTypePage
extends GOFirstPage<DataStoreGO> {
    public static final String PAGE_NAME = "DataStoreType";
    private I18NComboBox m_OutputTypes;
    private OrderableResultSchemaPanel m_SchemaPanel;

    public DataStoreTypePage(DataStoreGO dataStoreGO) {
        super(dataStoreGO, PAGE_NAME, "<dynamic>");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DataStoreTypePage");
    }

    @Override
    public void performFinish() {
        super.performFinish();
        ((DataStoreGO)this.m_GO).setType(this.m_OutputTypes.getSelectedId());
        GOUtil.setDiscardSet((Node)this.m_GO, (String)"DataStore_Discard", this.m_SchemaPanel.getDiscardSet());
        GOUtil.setOrderList((Node)this.m_GO, (String)"DataStore_Order", this.m_SchemaPanel.getOrderList());
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isOk() && this.getNextPage() != null;
    }

    @Override
    public IWizardPage getNextPage() {
        return this.m_Wizard.getPage(this.m_OutputTypes.getSelectedId());
    }

    @Override
    public boolean isPageComplete() {
        return this.isOk() && this.getNextPage() == null;
    }

    private boolean isOk() {
        String string;
        this.setError(null);
        boolean bl = true;
        if (((DataStoreGO)this.m_GO).getSchema() == null) {
            this.setError(I18N.ENSEMBLE.getString("GO.CANT_READ_SCHEMA"));
            bl = false;
        }
        if (!((DataStoreWizard)this.m_Wizard).isNameOk(string = this.m_Name.getText())) {
            this.setError(I18N.ENSEMBLE.getString("DataStoreTypePage.MUST_BE_UNIQUE"));
            bl = false;
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.buildComponents();
        this.addComponents();
        this.layoutComponents();
    }

    private void buildComponents() {
        String[] stringArray = DataStoreRegistry.getNames();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = "DataStore.Type." + stringArray[i].replace(' ', '_');
        }
        Name[] nameArray = I18NComboBox.buildModel(stringArray, I18N.ENSEMBLE, stringArray2);
        this.m_OutputTypes = I18NComboBox.apply(nameArray);
        this.m_OutputTypes.setName("list");
        this.m_OutputTypes.setSelectedId(((DataStoreGO)this.m_GO).getType());
        this.m_OutputTypes.addItemListener(new FieldWatcher(this.m_Wizard));
        this.m_SchemaPanel = new OrderableResultSchemaPanel(false);
        DataSchema dataSchema = ((DataStoreGO)this.m_GO).getSaveSchema();
        if (dataSchema != null) {
            Set set = GOUtil.getDiscardSet((Node)this.m_GO, (String)"DataStore_Discard");
            this.m_SchemaPanel.setSchema(dataSchema, set);
            List list = GOUtil.getOrderList((Node)this.m_GO, (String)"DataStore_Order");
            this.m_SchemaPanel.setOrderList(list);
        }
    }

    private void addComponents() {
        this.m_Component.add(SwingFactory.newLabel("list-label"));
        this.m_Component.add(this.m_OutputTypes);
        this.m_Component.add(this.m_SchemaPanel);
        I18N.ENSEMBLE_MAP.injectComponents("DataStoreTypePage.", this.m_Component);
    }

    private void layoutComponents() {
        this.putRight("GOFirstPage.name", "GOFirstPage.name-label,list-label", 10);
        this.stickLeft("list-label");
        this.vCenter("list-label", "list");
        this.alignBelow("list", "GOFirstPage.name", 5);
        this.stickRight("list");
        this.putBelow("schema", "list", 5);
        this.stickLeft("schema");
        this.stickRight("schema");
        this.stickBottom("schema");
    }
}

